/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.util;

public final class PackagePrefixChecker {
    private static final String PACKAGE_PREFIX = "org.omg.stub.";

    public static String packagePrefix() {
        return PACKAGE_PREFIX;
    }

    public static boolean hasBeenPrefixed(String string) {
        return string.startsWith(PackagePrefixChecker.packagePrefix());
    }

    public static boolean hasOffendingPrefix(String string) {
        return string.startsWith("java.") || string.equals("java") || string.startsWith("com.sun.") || string.equals("com.sun") || string.startsWith("net.jini.") || string.equals("net.jini") || string.startsWith("jini.") || string.equals("jini") || string.startsWith("javax.") || string.equals("javax");
    }

    public static boolean isOffendingPackage(String string) {
        return string != null && PackagePrefixChecker.hasOffendingPrefix(string);
    }

    public static String correctPackageName(String string) {
        if (string == null) {
            return string;
        }
        if (PackagePrefixChecker.hasOffendingPrefix(string)) {
            return PACKAGE_PREFIX + string;
        }
        return string;
    }

    public static String withoutPackagePrefix(String string) {
        if (PackagePrefixChecker.hasBeenPrefixed(string)) {
            return string.substring(PackagePrefixChecker.packagePrefix().length());
        }
        return string;
    }
}

