/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.ValueUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private static Hashtable translatedFields;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    boolean forProxyClass;
    private long suid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private boolean initialized = false;
    private Object lock = new Object();
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private Method writeReplaceObjectMethod;
    private Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static Class classSerializable;
    private static Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS;
    private static Comparator compareClassByName;
    private static final Comparator compareObjStrFieldsByName;
    private static Comparator compareMemberByName;
    static Class class$java$lang$Object;
    static Class class$java$io$ObjectOutputStream;
    static Class class$java$io$ObjectInputStream;
    static Class class$java$lang$String;
    static Class class$java$lang$Class;
    static Class class$java$io$Serializable;
    static Class class$java$io$Externalizable;

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final long getSerialVersionUID() {
        return this.suid;
    }

    static {
        try {
            Class.forName("com.sun.corba.se.internal.io.LibraryManager").getDeclaredMethod("load", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        descriptorFor = new ObjectStreamClassEntry[61];
        classSerializable = null;
        classExternalizable = null;
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        NO_FIELDS = new ObjectStreamField[0];
        compareClassByName = new CompareClassByName(null);
        compareObjStrFieldsByName = new CompareObjStrFieldsByName(null);
        compareMemberByName = new CompareMemberByName(null);
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        block7: for (int i2 = 0; i2 < this.fields.length; ++i2) {
            switch (this.fields[i2].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            Class clazz = this.ofClass;
            if (!this.serializable || this.externalizable || this.forProxyClass || this.name.equals("java.lang.String")) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(this, clazz){
                    private final Class val$cl;
                    private final ObjectStreamClass this$0;

                    public Object run() {
                        Object object;
                        Field[] fieldArray;
                        try {
                            fieldArray = this.val$cl.getDeclaredField("serialPersistentFields");
                            fieldArray.setAccessible(true);
                            object = (java.io.ObjectStreamField[])fieldArray.get(this.val$cl);
                            int n2 = fieldArray.getModifiers();
                            if (Modifier.isPrivate(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                                ObjectStreamClass.access$002(this.this$0, (ObjectStreamField[])ObjectStreamClass.access$100((Object[])fieldArray.get(this.val$cl)));
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            ObjectStreamClass.access$002(this.this$0, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            ObjectStreamClass.access$002(this.this$0, null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ObjectStreamClass.access$002(this.this$0, null);
                        }
                        catch (ClassCastException classCastException) {
                            ObjectStreamClass.access$002(this.this$0, null);
                        }
                        if (ObjectStreamClass.access$000(this.this$0) == null) {
                            fieldArray = this.val$cl.getDeclaredFields();
                            int n3 = 0;
                            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                                int n4 = fieldArray[i2].getModifiers();
                                if (Modifier.isStatic(n4) || Modifier.isTransient(n4)) continue;
                                objectStreamFieldArray[n3++] = new ObjectStreamField(fieldArray[i2]);
                            }
                            ObjectStreamClass.access$002(this.this$0, new ObjectStreamField[n3]);
                            System.arraycopy(objectStreamFieldArray, 0, ObjectStreamClass.access$000(this.this$0), 0, n3);
                        } else {
                            for (int i3 = ObjectStreamClass.access$000(this.this$0).length - 1; i3 >= 0; --i3) {
                                try {
                                    object = this.val$cl.getDeclaredField(ObjectStreamClass.access$000(this.this$0)[i3].getName());
                                    if (ObjectStreamClass.access$000(this.this$0)[i3].getType() != ((Field)object).getType()) continue;
                                    ObjectStreamClass.access$000(this.this$0)[i3].setField((Field)object);
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                    {
                        this.this$0 = objectStreamClass;
                        this.val$cl = clazz;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable()) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(this, clazz){
                    private final Class val$cl;
                    private final ObjectStreamClass this$0;

                    public Object run() {
                        int n2;
                        Class[] classArray;
                        if (this.this$0.forProxyClass) {
                            ObjectStreamClass.access$202(this.this$0, 0L);
                        } else {
                            try {
                                classArray = this.val$cl.getDeclaredField("serialVersionUID");
                                n2 = classArray.getModifiers();
                                if (Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                                    classArray.setAccessible(true);
                                    ObjectStreamClass.access$202(this.this$0, classArray.getLong(this.val$cl));
                                } else {
                                    ObjectStreamClass.access$202(this.this$0, ObjectStreamClass.access$300(this.val$cl));
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                ObjectStreamClass.access$202(this.this$0, ObjectStreamClass.access$300(this.val$cl));
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                ObjectStreamClass.access$202(this.this$0, ObjectStreamClass.access$300(this.val$cl));
                            }
                        }
                        ObjectStreamClass.access$402(this.this$0, ObjectStreamClass.access$600(this.val$cl, "writeReplace", ObjectStreamClass.access$500(), class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object));
                        ObjectStreamClass.access$702(this.this$0, ObjectStreamClass.access$600(this.val$cl, "readResolve", ObjectStreamClass.access$500(), class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object));
                        if (ObjectStreamClass.access$800(this.this$0) && !this.this$0.forProxyClass) {
                            try {
                                classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                                this.this$0.writeObjectMethod = this.val$cl.getDeclaredMethod("writeObject", classArray);
                                ObjectStreamClass.access$902(this.this$0, true);
                                n2 = this.this$0.writeObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                    this.this$0.writeObjectMethod = null;
                                    ObjectStreamClass.access$902(this.this$0, false);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            try {
                                classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
                                this.this$0.readObjectMethod = this.val$cl.getDeclaredMethod("readObject", classArray);
                                n2 = this.this$0.readObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                    this.this$0.readObjectMethod = null;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                    {
                        this.this$0 = objectStreamClass;
                        this.val$cl = clazz;
                    }
                });
            }
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            this.initialized = true;
        }
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n2 = objectStreamClass.ofClass.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n3];
        ObjectStreamClass.descriptorFor[n3] = objectStreamClassEntry;
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    static boolean access$800(ObjectStreamClass objectStreamClass) {
        return objectStreamClass.serializable;
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    static long access$202(ObjectStreamClass objectStreamClass, long l2) {
        objectStreamClass.suid = l2;
        return objectStreamClass.suid;
    }

    static boolean access$902(ObjectStreamClass objectStreamClass, boolean bl2) {
        objectStreamClass.hasWriteObjectMethod = bl2;
        return objectStreamClass.hasWriteObjectMethod;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    static Class[] access$500() {
        return noTypesList;
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            String string;
            Object object;
            int n2;
            Object[] objectArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, compareClassByName);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    dataOutputStream.writeUTF(((Class)objectArray[n2]).getName());
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, compareMemberByName);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object2 = objectArray[n2];
                int n4 = ((Field)object2).getModifiers();
                if (Modifier.isPrivate(n4) && (Modifier.isTransient(n4) || Modifier.isStatic(n4))) continue;
                dataOutputStream.writeUTF(((Field)object2).getName());
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)object2).getType()));
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            MethodSignature[] methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            for (int i2 = 0; i2 < methodSignatureArray.length; ++i2) {
                MethodSignature methodSignature = methodSignatureArray[i2];
                object = "<init>";
                string = methodSignature.signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeInt(methodSignature.member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            MethodSignature[] methodSignatureArray2 = MethodSignature.removePrivateAndSort(memberArray);
            for (int i3 = 0; i3 < methodSignatureArray2.length; ++i3) {
                object = methodSignatureArray2[i3];
                string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i4 = 0; i4 < Math.min(8, byArray.length); ++i4) {
                l2 += (long)(byArray[i4] & 0xFF) << i4 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    static long access$300(Class clazz) {
        return ObjectStreamClass._computeSerialVersionUID(clazz);
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getActualSerialVersionUID();
        }
        return 0L;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getSerialVersionUID();
        }
        return 0L;
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean bl2;
            boolean bl3 = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl4 = bl2 = clazz.isArray() && !clazz.getName().equals(this.name);
            if (!bl2 && !bl3) {
                throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(clazz.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable || !this.serializable && !this.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n2 = 0;
        block0: for (int i2 = 0; i2 < objectStreamFieldArray2.length; ++i2) {
            for (int i3 = n2; i3 < objectStreamFieldArray.length; ++i3) {
                if (!objectStreamFieldArray2[i2].getName().equals(objectStreamFieldArray[i3].getName())) continue;
                if (objectStreamFieldArray2[i2].isPrimitive() && !objectStreamFieldArray2[i2].typeEquals(objectStreamFieldArray[i3])) {
                    throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[i2].getName() + " of class " + this.name + " is incompatible.");
                }
                n2 = i3;
                objectStreamFieldArray2[i2].setField(objectStreamFieldArray[n2].getField());
                continue block0;
            }
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveObjectMethod = this.localClassDesc.readResolveObjectMethod;
    }

    private static native boolean hasStaticInitializer(Class var0);

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSerialVersionUIDStr() {
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.suid).toUpperCase();
        }
        return this.suidStr;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    ObjectStreamClass(String string, long l2) {
        this.name = string;
        this.suid = l2;
        this.superclass = null;
    }

    public boolean hasField(ValueMember valueMember) {
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            try {
                if (!this.fields[i2].getName().equals(valueMember.name) || !this.fields[i2].getSignature().equals(ValueUtility.getSignature(valueMember))) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n2 = clazz.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n3]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n3] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    static final ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            return objectStreamClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass == null) {
                Class clazz2;
                boolean bl2 = classSerializable.isAssignableFrom(clazz);
                ObjectStreamClass objectStreamClass2 = null;
                if (bl2 && (clazz2 = clazz.getSuperclass()) != null) {
                    objectStreamClass2 = ObjectStreamClass.lookup(clazz2);
                }
                boolean bl3 = false;
                if (bl2) {
                    boolean bl4 = bl3 = objectStreamClass2 != null && objectStreamClass2.isExternalizable() || classExternalizable.isAssignableFrom(clazz);
                    if (bl3) {
                        bl2 = false;
                    }
                }
                objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass2, bl2, bl3);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectStreamClass.init();
            return objectStreamClass;
        }
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl2, boolean bl3) {
        this.ofClass = clazz;
        if (Proxy.isProxyClass(clazz)) {
            this.forProxyClass = true;
        }
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl2;
        if (!this.forProxyClass) {
            this.externalizable = bl3;
        }
        ObjectStreamClass.insertDescriptorFor(this);
    }

    static ObjectStreamField[] access$000(ObjectStreamClass objectStreamClass) {
        return objectStreamClass.fields;
    }

    public final ObjectStreamField getField(String string) {
        for (int i2 = this.fields.length - 1; i2 >= 0; --i2) {
            if (!string.equals(this.fields[i2].getName())) continue;
            return this.fields[i2];
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    private static long computeStructuralUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                dataOutputStream.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(clazz2), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Object[] objectArray = objectStreamClass.getFields();
            if (objectArray.length > 1) {
                Arrays.sort(objectArray, compareObjStrFieldsByName);
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                dataOutputStream.writeUTF(((ObjectStreamField)objectArray[i2]).getName());
                dataOutputStream.writeUTF(((ObjectStreamField)objectArray[i2]).getSignature());
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i3 = 0; i3 < Math.min(8, byArray.length); ++i3) {
                l2 += (long)(byArray[i3] & 0xFF) << i3 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        Package package_;
        Package package_2 = clazz.getPackage();
        return package_2 == (package_ = clazz2.getPackage()) || package_2 != null && package_2.equals(package_);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return object;
    }

    static Object[] access$100(Object[] objectArray) throws NoSuchFieldException {
        return ObjectStreamClass.translateFields(objectArray);
    }

    private static Object[] translateFields(Object[] objectArray) throws NoSuchFieldException {
        try {
            java.io.ObjectStreamField[] objectStreamFieldArray = (java.io.ObjectStreamField[])objectArray;
            Object[] objectArray2 = null;
            if (translatedFields == null) {
                translatedFields = new Hashtable();
            }
            if ((objectArray2 = (Object[])translatedFields.get(objectStreamFieldArray)) != null) {
                return objectArray2;
            }
            Class clazz = Class.forName("com.sun.corba.se.internal.io.ObjectStreamField");
            objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            Object[] objectArray3 = new Object[2];
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectStreamClass.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class};
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            for (int i2 = objectStreamFieldArray.length - 1; i2 >= 0; --i2) {
                objectArray3[0] = objectStreamFieldArray[i2].getName();
                objectArray3[1] = objectStreamFieldArray[i2].getType();
                objectArray2[i2] = constructor.newInstance(objectArray3);
            }
            translatedFields.put(objectStreamFieldArray, objectArray2);
            return objectArray2;
        }
        catch (Throwable throwable) {
            throw new NoSuchFieldException();
        }
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static boolean compareClassNames(String string, String string2, char c2) {
        int n2;
        int n3 = string.lastIndexOf(c2);
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = string2.lastIndexOf(c2)) < 0) {
            n2 = 0;
        }
        return string.regionMatches(false, n3, string2, n2, string.length() - n3);
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[i2]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[i2]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static Field[] getDeclaredFields(Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(clazz){
            private final Class val$clz;
            {
                this.val$clz = clazz;
            }

            public Object run() {
                return this.val$clz.getDeclaredFields();
            }
        });
    }

    static ObjectStreamField[] access$002(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static Method access$402(ObjectStreamClass objectStreamClass, Method method) {
        objectStreamClass.writeReplaceObjectMethod = method;
        return objectStreamClass.writeReplaceObjectMethod;
    }

    static Method access$702(ObjectStreamClass objectStreamClass, Method method) {
        objectStreamClass.readResolveObjectMethod = method;
        return objectStreamClass.readResolveObjectMethod;
    }

    static Method access$600(Class clazz, String string, Class[] classArray, Class clazz2) {
        return ObjectStreamClass.getInheritableMethod(clazz, string, classArray, clazz2);
    }

    private static Method getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        Class clazz3;
        Method method = null;
        for (clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        method.setAccessible(true);
        int n2 = method.getModifiers();
        if ((n2 & 0x408) != 0) {
            return null;
        }
        if ((n2 & 5) != 0) {
            return method;
        }
        if ((n2 & 2) != 0) {
            return clazz == clazz3 ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        CompareClassByName(1 var1_1) {
            this();
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        CompareMemberByName(1 var1_1) {
            this();
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareObjStrFieldsByName
    implements Comparator {
        private CompareObjStrFieldsByName() {
        }

        CompareObjStrFieldsByName(1 var1_1) {
            this();
        }

        public int compare(Object object, Object object2) {
            ObjectStreamField objectStreamField = (ObjectStreamField)object;
            ObjectStreamField objectStreamField2 = (ObjectStreamField)object2;
            return objectStreamField.getName().compareTo(objectStreamField2.getName());
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            for (int i2 = 0; i2 < memberArray.length; ++i2) {
                if (Modifier.isPrivate(memberArray[i2].getModifiers())) continue;
                ++n2;
            }
            Object[] objectArray = new MethodSignature[n2];
            int n3 = 0;
            for (int i3 = 0; i3 < memberArray.length; ++i3) {
                if (Modifier.isPrivate(memberArray[i3].getModifiers())) continue;
                objectArray[n3] = new MethodSignature(memberArray[i3]);
                ++n3;
            }
            if (n3 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }
}

