/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.corba.PrincipalImpl;
import com.sun.corba.se.internal.corba.TypeCodeImpl;
import com.sun.corba.se.internal.core.ClientSubcontract;
import com.sun.corba.se.internal.core.CodeSetConversion;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.ORBVersionImpl;
import com.sun.corba.se.internal.core.ServerSubcontract;
import com.sun.corba.se.internal.core.SubcontractRegistry;
import com.sun.corba.se.internal.iiop.BufferManagerRead;
import com.sun.corba.se.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.se.internal.iiop.CDRInputStreamBase;
import com.sun.corba.se.internal.iiop.MarkAndResetHandler;
import com.sun.corba.se.internal.iiop.RestorableInputStream;
import com.sun.corba.se.internal.ior.ObjectKeyTemplate;
import com.sun.corba.se.internal.orbutil.CacheTable;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import com.sun.corba.se.internal.orbutil.RepositoryIdFactory;
import com.sun.corba.se.internal.orbutil.RepositoryIdInterface;
import com.sun.corba.se.internal.orbutil.RepositoryIdStrings;
import com.sun.corba.se.internal.orbutil.RepositoryIdUtility;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public class CDRInputStream_1_0
extends CDRInputStreamBase
implements RestorableInputStream {
    private static final String kReadMethod = "read";
    private static final int maxBlockLength = 0x7FFFFF00;
    protected BufferManagerRead bufferManagerRead;
    protected ByteBufferWithInfo bbwi;
    private boolean debug = false;
    protected boolean littleEndian;
    protected ORB orb;
    protected ValueHandler valueHandler = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private CacheTable codebaseCache = null;
    protected int blockLength = 0x7FFFFF00;
    protected int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    protected int valueIndirection = 0;
    protected int stringIndirection = 0;
    protected boolean isChunked = false;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.BTCConverter charConverter;
    private CodeSetConversion.BTCConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataInputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataInputStream:1.0"};
    protected MarkAndResetHandler markAndResetHandler = null;
    static Class class$org$omg$CORBA$portable$ObjectImpl;
    static Class class$java$rmi$Remote;
    static Class class$org$omg$CORBA$portable$Delegate;
    static Class class$org$omg$CORBA$portable$IDLEntity;
    static Class class$java$lang$String;
    static Class class$org$omg$CORBA$portable$InputStream;
    static Class class$org$omg$CORBA$portable$StreamableValue;
    static Class class$org$omg$CORBA$portable$CustomValue;
    static Class class$org$omg$CORBA$portable$ValueBase;

    public final byte read_octet() {
        this.alignAndCheck(1, 1);
        return this.bbwi.buf[this.bbwi.index++];
    }

    public final char read_char() {
        this.alignAndCheck(1, 1);
        return this.getConvertedChars(1, this.getCharConverter())[0];
    }

    public char read_wchar() {
        int n2;
        int n3;
        if (ORBUtility.isForeignORB(this.orb)) {
            throw new MARSHAL(1398079705, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n3 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n2 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
        } else {
            n2 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n3 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
        }
        return (char)((n2 << 8) + (n3 << 0));
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final double read_longdouble() {
        throw new NO_IMPLEMENT(1398079692, CompletionStatus.COMPLETED_MAYBE);
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public int getBufferLength() {
        return this.bbwi.buflen;
    }

    public int getIndex() {
        return this.bbwi.index;
    }

    public int getPosition() {
        return this.get_offset();
    }

    public int getSize() {
        return this.bbwi.index;
    }

    protected int get_offset() {
        return this.bbwi.index;
    }

    private int readValueTag() {
        return this.read_long();
    }

    public final int read_long() {
        int n2;
        int n3;
        int n4;
        int n5;
        this.alignAndCheck(4, 4);
        if (this.littleEndian) {
            n5 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n4 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n3 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n2 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
        } else {
            n2 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n3 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n4 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
            n5 = this.bbwi.buf[this.bbwi.index++] & 0xFF;
        }
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public final long read_longlong() {
        long l2;
        long l3;
        this.alignAndCheck(8, 8);
        if (this.littleEndian) {
            l3 = (long)this.read_long() & 0xFFFFFFFFL;
            l2 = (long)this.read_long() << 32;
        } else {
            l2 = (long)this.read_long() << 32;
            l3 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l2 | l3;
    }

    public final long read_ulonglong() {
        return this.read_longlong();
    }

    public final short read_short() {
        int n2;
        int n3;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n3 = this.bbwi.buf[this.bbwi.index++] << 0 & 0xFF;
            n2 = this.bbwi.buf[this.bbwi.index++] << 8 & 0xFF00;
        } else {
            n2 = this.bbwi.buf[this.bbwi.index++] << 8 & 0xFF00;
            n3 = this.bbwi.buf[this.bbwi.index++] << 0 & 0xFF;
        }
        return (short)(n2 | n3);
    }

    public final short read_ushort() {
        return this.read_short();
    }

    protected void checkBlockLength() {
        if (!this.isChunked) {
            return;
        }
        if (this.blockLength == this.get_offset()) {
            this.blockLength = 0x7FFFFF00;
            this.start_block();
        } else if (this.blockLength < this.get_offset()) {
            throw new MARSHAL("Chunk overflow at offset " + this.get_offset(), 1398079689, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void consumeEndian() {
        this.littleEndian = this.read_boolean();
    }

    private final void createRepositoryIdHandlers() {
        if (this.orb != null) {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility(this.orb);
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory(this.orb);
        } else {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
        }
    }

    private void end_block() {
        if (this.blockLength != 0x7FFFFF00) {
            if (this.blockLength == this.get_offset()) {
                this.blockLength = 0x7FFFFF00;
            } else if (this.blockLength > this.get_offset()) {
                this.skipToOffset(this.blockLength);
            } else {
                throw new MARSHAL("Incorrect chunk length " + this.blockLength + " at offset " + this.get_offset(), 1398079689, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private void handleEndOfValue() {
        if (!this.isChunked) {
            return;
        }
        while (this.blockLength != 0x7FFFFF00) {
            this.end_block();
            this.start_block();
        }
    }

    void performORBVersionSpecificInit() {
        this.createRepositoryIdHandlers();
    }

    public void printBuffer() {
        CDRInputStream_1_0.printBuffer(this.bbwi);
    }

    private void readEndTag() {
        if (this.isChunked) {
            int n2 = this.read_long();
            if (n2 >= 0) {
                if (n2 >= 0x7FFFFF00) {
                    this.bbwi.index -= 4;
                    this.read_value();
                    this.handleEndOfValue();
                    this.readEndTag();
                    return;
                }
                throw new MARSHAL("Read non-negative end tag: " + n2 + " at " + (this.get_offset() - 4), 1398079711, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.orb == null || ORBVersionImpl.FOREIGN.equals(this.orb.getORBVersion()) || ORBVersionImpl.NEWER.compareTo(this.orb.getORBVersion()) <= 0) {
                if (n2 < this.chunkedValueNestingLevel) {
                    throw new MARSHAL("Expecting fewer enclosing valuetypes.  Received end tag " + n2 + " but expected " + this.chunkedValueNestingLevel, 1398079710, CompletionStatus.COMPLETED_MAYBE);
                }
                if (n2 != this.chunkedValueNestingLevel) {
                    this.bbwi.index -= 4;
                }
            } else if (n2 != this.end_flag) {
                this.bbwi.index -= 4;
            }
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    public void reset() {
        this.markAndResetHandler.reset();
    }

    public void resetCodeSetConverters() {
        this.charConverter = null;
        this.wcharConverter = null;
    }

    private void start_block() {
        if (!this.isChunked) {
            return;
        }
        this.blockLength = 0x7FFFFF00;
        this.blockLength = this.read_long();
        if (this.blockLength > 0 && this.blockLength < 0x7FFFFF00) {
            this.blockLength += this.get_offset();
        } else {
            this.blockLength = 0x7FFFFF00;
            this.bbwi.index -= 4;
        }
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public final boolean read_boolean() {
        return this.read_octet() != 0;
    }

    public byte[] getByteBuffer() {
        return this.bbwi.buf;
    }

    protected final int computeAlignment(int n2) {
        int n3;
        if (n2 > 1 && (n3 = this.bbwi.index & n2 - 1) != 0) {
            return n2 - n3;
        }
        return 0;
    }

    void alignOnBoundary(int n2) {
        int n3 = this.computeAlignment(n2);
        if (this.bbwi.index + n3 <= this.bbwi.buflen) {
            this.bbwi.index += n3;
        }
    }

    protected final void checkForNegativeLength(int n2) {
        if (n2 < 0) {
            throw new MARSHAL("Bad string length: " + n2, 1398079706, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void mark(int n2) {
        this.markAndResetHandler.mark(this);
    }

    public void setBufferLength(int n2) {
        this.bbwi.buflen = n2;
    }

    public void setIndex(int n2) {
        this.bbwi.index = n2;
    }

    private void skipToOffset(int n2) {
        int n3;
        int n4 = n2 - this.get_offset();
        for (int i2 = 0; i2 < n4; i2 += n3) {
            int n5;
            int n6 = this.bbwi.buflen - this.bbwi.index;
            if (n6 <= 0) {
                this.grow(1, 1);
                n6 = this.bbwi.buflen - this.bbwi.index;
            }
            n3 = (n5 = n4 - i2) < n6 ? n5 : n6;
            this.bbwi.index += n3;
        }
    }

    protected void alignAndCheck(int n2, int n3) {
        this.checkBlockLength();
        this.bbwi.index += this.computeAlignment(n2);
        if (this.bbwi.index + n3 > this.bbwi.buflen) {
            this.grow(n2, n3);
        }
    }

    protected void grow(int n2, int n3) {
        this.bbwi.needed = n3;
        this.bbwi = this.bufferManagerRead.underflow(this.bbwi);
    }

    public void setByteBuffer(byte[] byArray) {
        this.bbwi.buf = byArray;
    }

    public final void read_octet_array(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            throw new BAD_PARAM();
        }
        if (n3 == 0) {
            return;
        }
        this.alignAndCheck(1, 1);
        for (int i2 = n2; i2 < n3 + n2; i2 += n4) {
            int n5;
            int n6 = this.bbwi.buflen - this.bbwi.index;
            if (n6 <= 0) {
                this.grow(1, 1);
                n6 = this.bbwi.buflen - this.bbwi.index;
            }
            n4 = (n5 = n3 + n2 - i2) < n6 ? n5 : n6;
            System.arraycopy(this.bbwi.buf, this.bbwi.index, byArray, i2, n4);
            this.bbwi.index += n4;
        }
    }

    public final void read_char_array(char[] cArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2 + n2] = this.read_char();
        }
    }

    public final void read_wchar_array(char[] cArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2 + n2] = this.read_wchar();
        }
    }

    public final void read_double_array(double[] dArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2 + n2] = this.read_double();
        }
    }

    public final void read_float_array(float[] fArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray[i2 + n2] = this.read_float();
        }
    }

    public final void read_long_array(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2 + n2] = this.read_long();
        }
    }

    public final void read_ulong_array(int[] nArray, int n2, int n3) {
        this.read_long_array(nArray, n2, n3);
    }

    public final void read_longlong_array(long[] lArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray[i2 + n2] = this.read_longlong();
        }
    }

    public final void read_ulonglong_array(long[] lArray, int n2, int n3) {
        this.read_longlong_array(lArray, n2, n3);
    }

    public final void read_short_array(short[] sArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray[i2 + n2] = this.read_short();
        }
    }

    public final void read_ushort_array(short[] sArray, int n2, int n3) {
        this.read_short_array(sArray, n2, n3);
    }

    public final void read_boolean_array(boolean[] blArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            blArray[i2 + n2] = this.read_boolean();
        }
    }

    protected CodeSetConversion.BTCConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharBTCConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.BTCConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharBTCConverter();
        }
        return this.wcharConverter;
    }

    char[] getConvertedChars(int n2, CodeSetConversion.BTCConverter bTCConverter) {
        if (this.bbwi.buflen - this.bbwi.index >= n2) {
            char[] cArray = bTCConverter.getChars(this.bbwi.buf, this.bbwi.index, n2);
            this.bbwi.index += n2;
            return cArray;
        }
        byte[] byArray = new byte[n2];
        this.read_octet_array(byArray, 0, byArray.length);
        return bTCConverter.getChars(byArray, 0, n2);
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    public BufferManagerRead getBufferManager() {
        return this.bufferManagerRead;
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("----- Input Buffer -----");
        System.out.println();
        System.out.println("Current index: " + byteBufferWithInfo.index);
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        try {
            char[] cArray = new char[16];
            for (int i2 = 0; i2 < byteBufferWithInfo.buflen; i2 += 16) {
                int n2;
                int n3;
                for (n3 = 0; n3 < 16 && n3 + i2 < byteBufferWithInfo.buflen; ++n3) {
                    String string;
                    n2 = byteBufferWithInfo.buf[i2 + n3];
                    if (n2 < 0) {
                        n2 = 256 + n2;
                    }
                    if ((string = Integer.toHexString(n2)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n3 < 16) {
                    System.out.print("   ");
                    ++n3;
                }
                for (n2 = 0; n2 < 16 && n2 + i2 < byteBufferWithInfo.buflen; ++n2) {
                    cArray[n2] = Character.isLetterOrDigit((char)byteBufferWithInfo.buf[i2 + n2]) ? (int)byteBufferWithInfo.buf[i2 + n2] : 46;
                }
                System.out.println(new String(cArray, 0, n2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("------------------------");
    }

    public CDRInputStreamBase dup() {
        CDRInputStreamBase cDRInputStreamBase;
        try {
            cDRInputStreamBase = (CDRInputStreamBase)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.debugPrintThrowable(instantiationException);
            throw new INTERNAL();
        }
        catch (IllegalAccessException illegalAccessException) {
            this.debugPrintThrowable(illegalAccessException);
            throw new INTERNAL();
        }
        cDRInputStreamBase.init(this.orb, this.bbwi.buf, this.bbwi.buflen, this.littleEndian, this.bufferManagerRead);
        ((CDRInputStream_1_0)cDRInputStreamBase).bbwi.index = this.bbwi.index;
        return cDRInputStreamBase;
    }

    static int access$000(CDRInputStream_1_0 cDRInputStream_1_0) {
        return cDRInputStream_1_0.chunkedValueNestingLevel;
    }

    private boolean isCustomType(ValueHelper valueHelper) {
        try {
            TypeCode typeCode = valueHelper.get_type();
            int n2 = typeCode.kind().value();
            if (n2 == 29) {
                return typeCode.type_modifier() == 1;
            }
        }
        catch (BadKind badKind) {
            throw new MARSHAL(1398079700, CompletionStatus.COMPLETED_MAYBE);
        }
        return false;
    }

    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public Serializable read_value() {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n3)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n3);
                return serializable;
            }
            throw new IndirectionException(n3);
        }
        int n4 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        java.lang.Object object = null;
        String string = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string = this.read_codebase_URL();
        }
        String string2 = null;
        switch (this.repIdUtil.getTypeInfo(n2)) {
            case 0: {
                throw new MARSHAL("read_value() with no repository ID info", 1398079708, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                string2 = this.read_repositoryId();
                break;
            }
            case 6: {
                string2 = this.read_repositoryIds();
            }
        }
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (string2.equals(this.repIdStrs.getWStringValueRepId())) {
            object = this.read_wstring();
        } else if (string2.equals(this.repIdStrs.getClassDescValueRepId())) {
            object = this.readClass();
        } else {
            Class clazz = this.getClassFromString(string2, string);
            if (clazz != null && (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = CDRInputStream_1_0.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz)) {
                object = this.readIDLValue(n4, string2, clazz, string);
            } else {
                try {
                    if (this.valueHandler == null) {
                        this.valueHandler = ORBUtility.createValueHandler(this.orb);
                    }
                    object = this.valueHandler.readValue(this.parent, n4, clazz, string2, this.getCodeBase());
                }
                catch (Exception exception) {
                    this.debugPrintThrowable(exception);
                    throw new MARSHAL("Unable to read value from underlying bridge : " + exception.getMessage(), 1398079699, CompletionStatus.COMPLETED_MAYBE);
                }
                catch (Error error) {
                    this.debugPrintThrowable(error);
                    throw new MARSHAL("Unable to read value from underlying bridge : " + error.getMessage(), 1398079698, CompletionStatus.COMPLETED_MAYBE);
                }
            }
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(false);
        }
        this.valueCache.put(object, n4);
        this.isChunked = bl2;
        this.start_block();
        return (Serializable)object;
    }

    private Class readClass() {
        String string = null;
        String string2 = null;
        if (this.orb == null || ORBVersionImpl.FOREIGN.equals(this.orb.getORBVersion()) || ORBVersionImpl.NEWER.compareTo(this.orb.getORBVersion()) <= 0) {
            string = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? (class$java$lang$String = CDRInputStream_1_0.class$("java.lang.String")) : class$java$lang$String));
            string2 = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? (class$java$lang$String = CDRInputStream_1_0.class$("java.lang.String")) : class$java$lang$String));
        } else {
            string2 = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? (class$java$lang$String = CDRInputStream_1_0.class$("java.lang.String")) : class$java$lang$String));
            string = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? (class$java$lang$String = CDRInputStream_1_0.class$("java.lang.String")) : class$java$lang$String));
        }
        if (this.debug) {
            this.debugPrintMessage("readClass codebases: " + string + " rep Id: " + string2);
        }
        Class clazz = null;
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string2);
        try {
            clazz = repositoryIdInterface.getClassFromType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debugPrintThrowable(classNotFoundException);
            throw new MARSHAL("Unable to load Class " + repositoryIdInterface.getClassName() + " : " + classNotFoundException.getMessage(), 1398079701, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (MalformedURLException malformedURLException) {
            this.debugPrintThrowable(malformedURLException);
            throw new MARSHAL("Unable to load Class " + repositoryIdInterface.getClassName() + " : " + malformedURLException.getMessage(), 1398079697, CompletionStatus.COMPLETED_MAYBE);
        }
        return clazz;
    }

    public java.lang.Object createStreamMemento() {
        return new StreamMemento(this);
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public void restoreInternalState(java.lang.Object object) {
        StreamMemento streamMemento = (StreamMemento)object;
        this.blockLength = StreamMemento.access$100(streamMemento);
        this.end_flag = StreamMemento.access$200(streamMemento);
        this.chunkedValueNestingLevel = StreamMemento.access$300(streamMemento);
        this.valueIndirection = StreamMemento.access$400(streamMemento);
        this.stringIndirection = StreamMemento.access$500(streamMemento);
        this.isChunked = StreamMemento.access$600(streamMemento);
        this.valueHandler = StreamMemento.access$700(streamMemento);
        this.bbwi = StreamMemento.access$800(streamMemento);
    }

    private final String read_codebase_URL() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.codebaseCache != null && this.codebaseCache.containsVal(n2)) {
                return (String)this.codebaseCache.getKey(n2);
            }
            throw new MARSHAL("Codebase indirection @ " + this.bbwi.index, 1398079703, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.codebaseCache == null) {
            this.codebaseCache = new CacheTable(false);
        }
        this.codebaseCache.put(string, this.stringIndirection);
        return string;
    }

    private final String read_repositoryId() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n2)) {
                return (String)this.repositoryIdCache.getKey(n2);
            }
            throw new MARSHAL("Repid indirection @ " + this.bbwi.index, 1398079702, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(false);
        }
        this.repositoryIdCache.put(string, this.stringIndirection);
        return string;
    }

    private String read_repositoryIds() {
        int n2 = this.read_long();
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n3)) {
                return (String)this.repositoryIdCache.getKey(n3);
            }
            throw new MARSHAL("Unable to locate array of repository IDs from indirection " + n3);
        }
        int n4 = this.get_offset() - 4;
        String string = this.read_repositoryId();
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(false);
        }
        this.repositoryIdCache.put(string, n4);
        for (int i2 = 1; i2 < n2; ++i2) {
            this.read_repositoryId();
        }
        return string;
    }

    public final String read_string() {
        return this.readStringOrIndirection(false);
    }

    public String read_wstring() {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw new MARSHAL(1398079705, CompletionStatus.COMPLETED_MAYBE);
        }
        int n2 = this.read_long();
        if (n2 == 0) {
            return new String("");
        }
        this.checkForNegativeLength(n2);
        char[] cArray = new char[--n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = this.read_wchar();
        }
        this.read_wchar();
        return new String(cArray);
    }

    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    private final String internalReadString(int n2) {
        if (n2 == 0) {
            return new String("");
        }
        char[] cArray = this.getConvertedChars(n2 - 1, this.getCharConverter());
        this.read_octet();
        return new String(cArray, 0, this.getCharConverter().getNumChars());
    }

    private final String legacyReadString(int n2) {
        int n3;
        if (n2 == 0) {
            return new String("");
        }
        char[] cArray = new char[--n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            int n4;
            int n5 = this.bbwi.buflen - this.bbwi.index;
            if (n5 <= 0) {
                this.grow(1, 1);
                n5 = this.bbwi.buflen - this.bbwi.index;
            }
            n3 = (n4 = n2 - i2) < n5 ? n4 : n5;
            for (int i3 = 0; i3 < n3; ++i3) {
                cArray[i2 + i3] = (char)(this.bbwi.buf[this.bbwi.index + i3] & 0xFF);
            }
            this.bbwi.index += n3;
        }
        if (this.bbwi.index + 1 > this.bbwi.buflen) {
            this.alignAndCheck(1, 1);
        }
        ++this.bbwi.index;
        return new String(cArray);
    }

    protected void debugPrintMessage(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    protected final String readStringOrIndirection(boolean bl2) {
        int n2 = this.read_long();
        if (bl2) {
            if (n2 == -1) {
                return null;
            }
            this.stringIndirection = this.get_offset() - 4;
        }
        this.checkForNegativeLength(n2);
        if (this.orb != null && ORBUtility.isLegacyORB(this.orb)) {
            return this.legacyReadString(n2);
        }
        return this.internalReadString(n2);
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3) {
            byte by = this.read_octet();
            int n2 = (by & 0xF0) >> 4;
            int n3 = by & 0xF;
            if (bl2 || n2 != 0) {
                stringBuffer.append(Character.forDigit(n2, 10));
                bl2 = true;
            }
            if (n3 == 12) {
                if (!bl2) {
                    return new StringBuffer("0.0");
                }
                bl3 = false;
                continue;
            }
            if (n3 == 13) {
                stringBuffer.insert(0, '-');
                bl3 = false;
                continue;
            }
            stringBuffer.append(Character.forDigit(n3, 10));
            bl2 = true;
        }
        return stringBuffer;
    }

    protected void debugPrintThrowable(Throwable throwable) {
        if (this.debug && throwable != null) {
            throwable.printStackTrace();
        }
    }

    public BigDecimal read_fixed() {
        return new BigDecimal(this.read_fixed_buffer().toString());
    }

    public BigDecimal read_fixed(short s2, short s3) {
        StringBuffer stringBuffer = this.read_fixed_buffer();
        if (s2 != stringBuffer.length()) {
            throw new MARSHAL();
        }
        stringBuffer.insert(s2 - s3, '.');
        return new BigDecimal(stringBuffer.toString());
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        try {
            typeCodeImpl.read_value(this.parent);
        }
        catch (MARSHAL mARSHAL) {
            if (typeCodeImpl.kind().value() != 29) {
                throw mARSHAL;
            }
            this.debugPrintThrowable(mARSHAL);
        }
        any.read_value(this.parent, typeCodeImpl);
        return any;
    }

    public final void read_any_array(Any[] anyArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            anyArray[i2 + n2] = this.read_any();
        }
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n2, int n3) {
        this.read_any_array(anySeqHolder.value, n2, n3);
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n2, int n3) {
        this.read_boolean_array(booleanSeqHolder.value, n2, n3);
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n2, int n3) {
        this.read_char_array(charSeqHolder.value, n2, n3);
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n2, int n3) {
        this.read_double_array(doubleSeqHolder.value, n2, n3);
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n2, int n3) {
        this.read_float_array(floatSeqHolder.value, n2, n3);
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n2, int n3) {
        this.read_longlong_array(longLongSeqHolder.value, n2, n3);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n2, int n3) {
        this.read_long_array(longSeqHolder.value, n2, n3);
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public void orb(org.omg.CORBA.ORB oRB) {
        this.orb = (ORB)oRB;
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n2, int n3) {
        this.read_octet_array(octetSeqHolder.value, n2, n3);
    }

    public Principal read_Principal() {
        int n2 = this.read_long();
        byte[] byArray = new byte[n2];
        this.read_octet_array(byArray, 0, n2);
        PrincipalImpl principalImpl = new PrincipalImpl();
        ((Principal)principalImpl).name(byArray);
        return principalImpl;
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n2, int n3) {
        this.read_short_array(shortSeqHolder.value, n2, n3);
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this.parent);
        return typeCodeImpl;
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n2, int n3) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n2, n3);
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n2, int n3) {
        this.read_ulong_array(uLongSeqHolder.value, n2, n3);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n2, int n3) {
        this.read_ushort_array(uShortSeqHolder.value, n2, n3);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n2, int n3) {
        this.read_wchar_array(wCharSeqHolder.value, n2, n3);
    }

    public void init(org.omg.CORBA.ORB oRB, byte[] byArray, int n2, boolean bl2, BufferManagerRead bufferManagerRead) {
        this.orb = (ORB)oRB;
        this.littleEndian = bl2;
        this.bufferManagerRead = bufferManagerRead;
        this.bbwi = new ByteBufferWithInfo(byArray, 0);
        this.bbwi.buflen = n2;
        this.markAndResetHandler = this.bufferManagerRead.getMarkAndResetHandler();
        if (oRB != null) {
            this.debug = ((ORB)oRB).transportDebugFlag;
        }
    }

    public Serializable read_value(Serializable serializable) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(false);
        }
        this.valueCache.put(serializable, this.valueIndirection);
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal(this.parent);
        }
        return serializable;
    }

    public Serializable read_value(Class clazz) {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n3)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n3);
                return serializable;
            }
            throw new IndirectionException(n3);
        }
        int n4 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        java.lang.Object object = null;
        String string = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string = this.read_codebase_URL();
        }
        String string2 = null;
        switch (this.repIdUtil.getTypeInfo(n2)) {
            case 0: {
                if (clazz == null) {
                    throw new MARSHAL("Expected type null and no repository ID info", 1398079707, CompletionStatus.COMPLETED_MAYBE);
                }
                string2 = this.repIdStrs.createForAnyType(clazz);
                break;
            }
            case 2: {
                string2 = this.read_repositoryId();
                break;
            }
            case 6: {
                string2 = this.read_repositoryIds();
            }
        }
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (string2.equals(this.repIdStrs.getWStringValueRepId())) {
            object = this.read_wstring();
        } else if (string2.equals(this.repIdStrs.getClassDescValueRepId())) {
            object = this.readClass();
        } else {
            Class clazz2 = clazz;
            if (clazz == null || !string2.equals(this.repIdStrs.createForAnyType(clazz))) {
                clazz2 = this.getClassFromString(string2, string, clazz);
            }
            if (clazz2 != null && (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = CDRInputStream_1_0.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz2)) {
                object = this.readIDLValue(n4, string2, clazz2, string);
            } else {
                try {
                    if (this.valueHandler == null) {
                        this.valueHandler = ORBUtility.createValueHandler(this.orb);
                    }
                    object = this.valueHandler.readValue(this.parent, n4, clazz2, string2, this.getCodeBase());
                }
                catch (Exception exception) {
                    this.debugPrintThrowable(exception);
                    throw new MARSHAL("Unable to read value from underlying bridge : " + exception.getMessage(), 1398079699, CompletionStatus.COMPLETED_MAYBE);
                }
                catch (Error error) {
                    this.debugPrintThrowable(error);
                    throw new MARSHAL("Unable to read value from underlying bridge : " + error.getMessage(), 1398079698, CompletionStatus.COMPLETED_MAYBE);
                }
            }
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(false);
        }
        this.valueCache.put(object, n4);
        this.isChunked = bl2;
        this.start_block();
        return (Serializable)object;
    }

    public Serializable read_value(String string) {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n3)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n3);
                return serializable;
            }
            throw new IndirectionException(n3);
        }
        int n4 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        Serializable serializable = null;
        String string2 = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string2 = this.read_codebase_URL();
        }
        String string3 = null;
        switch (this.repIdUtil.getTypeInfo(n2)) {
            case 0: {
                string3 = string;
                break;
            }
            case 2: {
                string3 = this.read_repositoryId();
                break;
            }
            case 6: {
                string3 = this.read_repositoryIds();
            }
        }
        ValueFactory valueFactory = Utility.getFactory(null, string2, this.orb, string3);
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        this.valueIndirection = n4;
        serializable = valueFactory.read_value(this.parent);
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(false);
        }
        this.valueCache.put(serializable, n4);
        this.isChunked = bl2;
        this.start_block();
        return serializable;
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n3)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n3);
                return serializable;
            }
            throw new IndirectionException(n3);
        }
        int n4 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        java.lang.Object object = null;
        String string = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string = this.read_codebase_URL();
        }
        String string2 = null;
        switch (this.repIdUtil.getTypeInfo(n2)) {
            case 0: {
                throw new MARSHAL("No class description available (value_tag indicates no type information present)");
            }
            case 2: {
                string2 = this.read_repositoryId();
                break;
            }
            case 6: {
                string2 = this.read_repositoryIds();
            }
        }
        if (!string2.equals(boxedValueHelper.get_id())) {
            boxedValueHelper = Utility.getHelper(null, string, string2);
        }
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (boxedValueHelper instanceof ValueHelper) {
            object = this.readIDLValueWithHelper((ValueHelper)boxedValueHelper, n4);
        } else {
            this.valueIndirection = n4;
            object = boxedValueHelper.read_value(this.parent);
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(false);
        }
        this.valueCache.put(object, n4);
        this.isChunked = bl2;
        this.start_block();
        return (Serializable)object;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private java.lang.Object readIDLValueWithHelper(ValueHelper valueHelper, int n2) {
        Method method;
        java.lang.Object object;
        try {
            object = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = CDRInputStream_1_0.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream, valueHelper.get_class()};
            method = valueHelper.getClass().getDeclaredMethod(kReadMethod, (Class[])object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Serializable serializable = valueHelper.read_value(this.parent);
            return serializable;
        }
        object = null;
        try {
            object = valueHelper.get_class().newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.debugPrintThrowable(instantiationException);
            throw new MARSHAL(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            return valueHelper.read_value(this.parent);
        }
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(false);
        }
        this.valueCache.put(object, n2);
        if (object instanceof CustomMarshal && this.isCustomType(valueHelper)) {
            ((CustomMarshal)object).unmarshal(this.parent);
            return object;
        }
        try {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, object};
            method.invoke(valueHelper, objectArray);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.debugPrintThrowable(illegalAccessException);
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            this.debugPrintThrowable(invocationTargetException);
            throw new MARSHAL(invocationTargetException.getMessage());
        }
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl2 = this.read_boolean();
        if (bl2) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    public Object read_Object(Class clazz) {
        IOR iOR = new IOR(this.parent);
        if (clazz == null || (class$org$omg$CORBA$portable$ObjectImpl == null ? (class$org$omg$CORBA$portable$ObjectImpl = CDRInputStream_1_0.class$("org.omg.CORBA.portable.ObjectImpl")) : class$org$omg$CORBA$portable$ObjectImpl).isAssignableFrom(clazz)) {
            return CDRInputStream_1_0.internalIORToObject(iOR, clazz, this.orb);
        }
        try {
            Class clazz2 = Utility.loadStubClass(iOR.getTypeId(), iOR.getCodebase(), clazz);
            return CDRInputStream_1_0.internalIORToObject(iOR, clazz2, this.orb);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MARSHAL("Failed to load stub for " + iOR.getTypeId() + " with Class " + (clazz == null ? "null" : clazz.getName()), 1398079691, CompletionStatus.COMPLETED_NO);
        }
    }

    private Class getClassFromString(String string, String string2) {
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string);
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                switch (i2) {
                    case 0: {
                        return repositoryIdInterface.getClassFromType();
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        string2 = this.getCodeBase().implementation(string);
                    }
                }
                if (string2 == null) continue;
                return repositoryIdInterface.getClassFromType(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                this.debugPrintThrowable(malformedURLException);
                throw new MARSHAL("Unable to locate value class for rep. id : " + string + " because of malformed URL " + string2, 1398079697, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        this.debugPrintMessage("getClassFromString failed with rep id " + string + " and codebase " + string2);
        return null;
    }

    private java.lang.Object readBoxedIDLEntity(Class clazz, String string) {
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string, classLoader, clazz, classLoader);
            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = CDRInputStream_1_0.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(this, clazz2, classArray){
                    private final Class val$helperClass;
                    private final Class[] val$argTypes;
                    private final CDRInputStream_1_0 this$0;

                    public java.lang.Object run() throws NoSuchMethodException {
                        return this.val$helperClass.getDeclaredMethod(CDRInputStream_1_0.kReadMethod, this.val$argTypes);
                    }
                    {
                        this.this$0 = cDRInputStream_1_0;
                        this.val$helperClass = clazz;
                        this.val$argTypes = classArray;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent};
            return method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debugPrintThrowable(classNotFoundException);
            throw new MARSHAL(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.debugPrintThrowable(noSuchMethodException);
            throw new MARSHAL(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.debugPrintThrowable(illegalAccessException);
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            this.debugPrintThrowable(invocationTargetException);
            throw new MARSHAL(invocationTargetException.getMessage());
        }
    }

    protected static org.omg.CORBA.portable.ObjectImpl newStub(Class clazz, Delegate delegate) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = CDRInputStream_1_0.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
            org.omg.CORBA.portable.ObjectImpl objectImpl = (org.omg.CORBA.portable.ObjectImpl)clazz.newInstance();
            objectImpl._set_delegate(delegate);
            return objectImpl;
        }
        try {
            org.omg.CORBA.portable.ObjectImpl objectImpl = (org.omg.CORBA.portable.ObjectImpl)clazz.newInstance();
            objectImpl._set_delegate(delegate);
            return objectImpl;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Class[] classArray = new Class[]{class$org$omg$CORBA$portable$Delegate == null ? (class$org$omg$CORBA$portable$Delegate = CDRInputStream_1_0.class$("org.omg.CORBA.portable.Delegate")) : class$org$omg$CORBA$portable$Delegate};
            java.lang.Object[] objectArray = new java.lang.Object[]{delegate};
            Constructor constructor = clazz.getConstructor(classArray);
            return (org.omg.CORBA.portable.ObjectImpl)constructor.newInstance(objectArray);
        }
    }

    private Class getClassFromString(String string, String string2, Class clazz) {
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string);
        try {
            try {
                return repositoryIdInterface.getClassFromType(clazz, string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    string2 = this.getCodeBase().implementation(string);
                    if (string2 == null) {
                        return null;
                    }
                    return repositoryIdInterface.getClassFromType(clazz, string2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    this.debugPrintThrowable(classNotFoundException2);
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.debugPrintThrowable(malformedURLException);
            throw new MARSHAL("Unable to locate value class for rep. id : " + string + " because of malformed URL " + string2, 1398079697, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    private java.lang.Object readIDLValue(int n2, String string, Class clazz, String string2) {
        if ((class$org$omg$CORBA$portable$StreamableValue == null ? (class$org$omg$CORBA$portable$StreamableValue = CDRInputStream_1_0.class$("org.omg.CORBA.portable.StreamableValue")) : class$org$omg$CORBA$portable$StreamableValue).isAssignableFrom(clazz) || (class$org$omg$CORBA$portable$CustomValue == null ? (class$org$omg$CORBA$portable$CustomValue = CDRInputStream_1_0.class$("org.omg.CORBA.portable.CustomValue")) : class$org$omg$CORBA$portable$CustomValue).isAssignableFrom(clazz)) {
            ValueFactory valueFactory = Utility.getFactory(clazz, string2, this.orb, string);
            this.valueIndirection = n2;
            return valueFactory.read_value(this.parent);
        }
        if ((class$org$omg$CORBA$portable$ValueBase == null ? (class$org$omg$CORBA$portable$ValueBase = CDRInputStream_1_0.class$("org.omg.CORBA.portable.ValueBase")) : class$org$omg$CORBA$portable$ValueBase).isAssignableFrom(clazz)) {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(clazz, string2, string);
            if (boxedValueHelper instanceof ValueHelper) {
                return this.readIDLValueWithHelper((ValueHelper)boxedValueHelper, n2);
            }
            return boxedValueHelper.read_value(this.parent);
        }
        return this.readBoxedIDLEntity(clazz, string2);
    }

    protected static Object createDelegate(IOR iOR, Class clazz, com.sun.corba.se.internal.core.ORB oRB) {
        SubcontractRegistry subcontractRegistry = oRB.getSubcontractRegistry();
        ObjectKeyTemplate objectKeyTemplate = iOR.getProfile().getTemplate().getObjectKeyTemplate();
        ClientSubcontract clientSubcontract = subcontractRegistry.getClientSubcontract(objectKeyTemplate);
        clientSubcontract.unmarshal(iOR);
        clientSubcontract.setOrb(oRB);
        return CDRInputStream_1_0.loadStub(iOR, clazz, (Delegate)((java.lang.Object)clientSubcontract));
    }

    public static Object internalIORToObject(IOR iOR, Class clazz, com.sun.corba.se.internal.core.ORB oRB) {
        java.lang.Object object;
        ServerSubcontract serverSubcontract;
        if (iOR.is_nil()) {
            return null;
        }
        if (iOR.isLocal() && (serverSubcontract = iOR.getServerSubcontract()) != null && serverSubcontract.isServantSupported() && (object = serverSubcontract.getServant(iOR)) != null) {
            if (object instanceof Tie) {
                String string = iOR.getCodebase();
                Object object2 = (Object)((java.lang.Object)Utility.loadStub((Tie)object, clazz, string, false));
                if (object2 != null) {
                    return object2;
                }
                throw new MARSHAL(1398079691, CompletionStatus.COMPLETED_NO);
            }
            if (object instanceof Object) {
                if (object instanceof InvokeHandler) {
                    return CDRInputStream_1_0.createDelegate(iOR, clazz, oRB);
                }
                return (Object)object;
            }
            throw new INTERNAL(1398079705, CompletionStatus.COMPLETED_NO);
        }
        return CDRInputStream_1_0.createDelegate(iOR, clazz, oRB);
    }

    protected static org.omg.CORBA.portable.ObjectImpl loadStub(IOR iOR, Class clazz, Delegate delegate) {
        block7: {
            java.lang.Object object;
            block8: {
                if (clazz != null) {
                    try {
                        return CDRInputStream_1_0.newStub(clazz, delegate);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        break block7;
                    }
                }
                try {
                    object = iOR.getTypeId();
                    if (((String)object).length() > 0) {
                        String string = iOR.getCodebase();
                        Class clazz2 = Utility.loadStubClass((String)object, string, null);
                        return CDRInputStream_1_0.newStub(clazz2, delegate);
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block8;
                    throw (ThreadDeath)throwable;
                }
            }
            object = new ObjectImpl(){

                public String[] _ids() {
                    String[] stringArray = new String[]{"IDL:omg.org/CORBA/Object:1.0"};
                    return stringArray;
                }
            };
            ((org.omg.CORBA.portable.ObjectImpl)object)._set_delegate(delegate);
            return object;
        }
        throw new MARSHAL(1398079691, CompletionStatus.COMPLETED_NO);
    }

    protected class StreamMemento {
        private int blockLength_;
        private int end_flag_;
        private int chunkedValueNestingLevel_;
        private int valueIndirection_;
        private int stringIndirection_;
        private boolean isChunked_;
        private ValueHandler valueHandler_;
        private ByteBufferWithInfo bbwi_;
        private final CDRInputStream_1_0 this$0;

        public StreamMemento(CDRInputStream_1_0 cDRInputStream_1_0) {
            this.this$0 = cDRInputStream_1_0;
            this.blockLength_ = cDRInputStream_1_0.blockLength;
            this.end_flag_ = cDRInputStream_1_0.end_flag;
            this.chunkedValueNestingLevel_ = CDRInputStream_1_0.access$000(cDRInputStream_1_0);
            this.valueIndirection_ = cDRInputStream_1_0.valueIndirection;
            this.stringIndirection_ = cDRInputStream_1_0.stringIndirection;
            this.isChunked_ = cDRInputStream_1_0.isChunked;
            this.valueHandler_ = cDRInputStream_1_0.valueHandler;
            this.bbwi_ = new ByteBufferWithInfo(cDRInputStream_1_0.bbwi);
        }

        static int access$100(StreamMemento streamMemento) {
            return streamMemento.blockLength_;
        }

        static int access$200(StreamMemento streamMemento) {
            return streamMemento.end_flag_;
        }

        static int access$300(StreamMemento streamMemento) {
            return streamMemento.chunkedValueNestingLevel_;
        }

        static int access$400(StreamMemento streamMemento) {
            return streamMemento.valueIndirection_;
        }

        static int access$500(StreamMemento streamMemento) {
            return streamMemento.stringIndirection_;
        }

        static boolean access$600(StreamMemento streamMemento) {
            return streamMemento.isChunked_;
        }

        static ByteBufferWithInfo access$800(StreamMemento streamMemento) {
            return streamMemento.bbwi_;
        }

        static ValueHandler access$700(StreamMemento streamMemento) {
            return streamMemento.valueHandler_;
        }
    }
}

