/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.iiop.BufferManagerRead;
import com.sun.corba.se.internal.iiop.BufferQueue;
import com.sun.corba.se.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.se.internal.iiop.MarkAndResetHandler;
import com.sun.corba.se.internal.iiop.RequestCanceledException;
import com.sun.corba.se.internal.iiop.RestorableInputStream;
import com.sun.corba.se.internal.iiop.messages.FragmentMessage;
import com.sun.corba.se.internal.iiop.messages.Message;
import java.util.LinkedList;
import java.util.ListIterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class BufferManagerReadStream
implements BufferManagerRead,
MarkAndResetHandler {
    private boolean receivedCancel = false;
    private int cancelReqId = 0;
    private boolean endOfStream = true;
    private BufferQueue fragmentQueue = new BufferQueue();
    private boolean markEngaged = false;
    private LinkedList fragmentStack = null;
    private RestorableInputStream inputStream = null;
    private Object streamMemento = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (!this.markEngaged) {
            return;
        }
        this.markEngaged = false;
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            ListIterator listIterator = this.fragmentStack.listIterator();
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                while (listIterator.hasNext()) {
                    this.fragmentQueue.push((ByteBufferWithInfo)listIterator.next());
                }
            }
            this.fragmentStack.clear();
        }
        this.inputStream.restoreInternalState(this.streamMemento);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelProcessing(int n2) {
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            this.receivedCancel = true;
            this.cancelReqId = n2;
            this.fragmentQueue.notify();
        }
    }

    public void fragmentationOccured(ByteBufferWithInfo byteBufferWithInfo) {
        if (!this.markEngaged) {
            return;
        }
        if (this.fragmentStack == null) {
            this.fragmentStack = new LinkedList();
        }
        this.fragmentStack.addFirst(new ByteBufferWithInfo(byteBufferWithInfo));
    }

    public MarkAndResetHandler getMarkAndResetHandler() {
        return this;
    }

    public void mark(RestorableInputStream restorableInputStream) {
        this.inputStream = restorableInputStream;
        this.markEngaged = true;
        this.streamMemento = restorableInputStream.createStreamMemento();
        if (this.fragmentStack != null) {
            this.fragmentStack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFragment(byte[] byArray, FragmentMessage fragmentMessage) {
        ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo(byArray, fragmentMessage.getHeaderLength());
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            this.fragmentQueue.enqueue(byteBufferWithInfo);
            this.endOfStream = !fragmentMessage.moreFragmentsToFollow();
            this.fragmentQueue.notify();
        }
    }

    public void init(Message message) {
        if (message != null) {
            this.endOfStream = !message.moreFragmentsToFollow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBufferWithInfo underflow(ByteBufferWithInfo byteBufferWithInfo) {
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            if (this.receivedCancel) {
                throw new RequestCanceledException(this.cancelReqId);
            }
            while (this.fragmentQueue.size() == 0) {
                if (this.endOfStream) {
                    throw new MARSHAL("Unmarshaller requested more data after end of stream", 1398079695, CompletionStatus.COMPLETED_NO);
                }
                try {
                    this.fragmentQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.receivedCancel) continue;
                throw new RequestCanceledException(this.cancelReqId);
            }
            ByteBufferWithInfo byteBufferWithInfo2 = this.fragmentQueue.dequeue();
            byteBufferWithInfo2.fragmented = true;
            return byteBufferWithInfo2;
        }
    }
}

