/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.debug.Debug;
import java.awt.Color;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class Resources {
    private static ResourceBundle _resources = null;
    private static NumberFormat _numberFormat = null;
    static Class _keyEventClazz = null;
    static Class class$com$sun$javaws$Resources;

    public static synchronized String formatDouble(double d, int n) {
        _numberFormat.setGroupingUsed(true);
        _numberFormat.setMaximumFractionDigits(n);
        _numberFormat.setMinimumFractionDigits(n);
        return _numberFormat.format(d);
    }

    public static int getInteger(String string) {
        try {
            return Integer.parseInt(Resources.getString(string), 16);
        }
        catch (MissingResourceException missingResourceException) {
            Debug.fatal("Missing resource: " + string);
            return -1;
        }
    }

    public static int getVKCode(String string) {
        String string2 = Resources.getString(string);
        if (string2 != null && string2.startsWith("VK_")) {
            try {
                if (_keyEventClazz == null) {
                    _keyEventClazz = Class.forName("java.awt.event.KeyEvent");
                }
                Field field = _keyEventClazz.getDeclaredField(string2);
                int n = field.getInt(null);
                return n;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.ignoredException(classNotFoundException);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Debug.ignoredException(noSuchFieldException);
            }
            catch (SecurityException securityException) {
                Debug.ignoredException(securityException);
            }
            catch (Exception exception) {
                Debug.ignoredException(exception);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getResources() {
        if (_resources == null) {
            Class clazz = class$com$sun$javaws$Resources == null ? (class$com$sun$javaws$Resources = Resources.class$("com.sun.javaws.Resources")) : class$com$sun$javaws$Resources;
            synchronized (clazz) {
                _resources = ResourceBundle.getBundle("com/sun/javaws/resources/strings");
            }
            _numberFormat = NumberFormat.getInstance();
        }
        return _resources;
    }

    public static Color getColor(String string) {
        int n = Resources.getInteger(string);
        return new Color(n);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String getString(String string) {
        try {
            return Resources.getResources().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Debug.fatal("Missing resource: " + string);
            return null;
        }
    }

    public static String getString(String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return Resources.applyPattern(string, objectArray);
    }

    public static String getString(String string, int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        return Resources.applyPattern(string, objectArray);
    }

    public static ImageIcon getIcon(String string) {
        String string2 = Resources.getString(string);
        return new ImageIcon((class$com$sun$javaws$Resources == null ? (class$com$sun$javaws$Resources = Resources.class$("com.sun.javaws.Resources")) : class$com$sun$javaws$Resources).getResource(string2));
    }

    private static String applyPattern(String string, Object[] objectArray) {
        String string2 = Resources.getString(string);
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = MessageFormat.format(string2, objectArray);
        return string3;
    }

    public static String getString(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return Resources.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, int n) {
        Object[] objectArray = new Object[]{string2, new Integer(n)};
        return Resources.applyPattern(string, objectArray);
    }

    public static String getString(String string, Long l, Long l2) {
        Object[] objectArray = new Object[]{l, l2};
        return Resources.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, int n, String string3) {
        Object[] objectArray = new Object[]{string2, new Integer(n), string3};
        return Resources.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        return Resources.applyPattern(string, objectArray);
    }

    public static String getString(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string2, string3, string4};
        return Resources.applyPattern(string, objectArray);
    }
}

