/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.Main;
import com.sun.javaws.Resources;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.console.Console;
import com.sun.javaws.ui.general.GeneralUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class LaunchErrorDialog
extends JDialog {
    private static String getLaunchDescTitle() {
        LaunchDesc launchDesc = JNLPException.getDefaultLaunchDesc();
        return launchDesc == null ? null : launchDesc.getInformation().getTitle();
    }

    private static String getLaunchDescVendor() {
        LaunchDesc launchDesc = JNLPException.getDefaultLaunchDesc();
        return launchDesc == null ? null : launchDesc.getInformation().getVendor();
    }

    private static String getErrorCategory(Throwable throwable) {
        String string = Resources.getString("launch.error.category.unexpected");
        if (throwable instanceof JNLPException) {
            JNLPException jNLPException = (JNLPException)throwable;
            string = jNLPException.getCategory();
        } else if (throwable instanceof SecurityException || throwable instanceof GeneralSecurityException) {
            string = Resources.getString("launch.error.category.security");
        } else if (throwable instanceof OutOfMemoryError) {
            string = Resources.getString("launch.error.category.memory");
        }
        return string;
    }

    private static String getErrorDescription(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = Resources.getString("launcherrordialog.genericerror", throwable.getClass().getName());
        }
        return string;
    }

    private LaunchErrorDialog(Frame frame, Throwable throwable) {
        super(frame, true);
        Object object;
        Object object2;
        Object object3;
        JNLPException jNLPException = null;
        if (throwable instanceof JNLPException) {
            jNLPException = (JNLPException)throwable;
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jTabbedPane);
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        String string = LaunchErrorDialog.getErrorCategory(throwable);
        this.setTitle(Resources.getString("launcherrordialog.title", string));
        String string2 = LaunchErrorDialog.getLaunchDescTitle();
        String string3 = LaunchErrorDialog.getLaunchDescVendor();
        String string4 = Resources.getString("launcherrordialog.errorintro");
        if (string2 != null) {
            string4 = string4 + Resources.getString("launcherrordialog.errortitle", string2);
        }
        if (string3 != null) {
            string4 = string4 + Resources.getString("launcherrordialog.errorvendor", string3);
        }
        string4 = string4 + Resources.getString("launcherrordialog.errorcategory", string);
        string4 = string4 + LaunchErrorDialog.getErrorDescription(throwable);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string4);
        jTabbedPane.add(Resources.getString("launcherrordialog.generalTab"), new JScrollPane(jTextArea));
        String string5 = null;
        String string6 = null;
        if (jNLPException != null) {
            string5 = jNLPException.getLaunchDescSource();
            if (string5 == null) {
                object3 = jNLPException.getDefaultLaunchDesc();
                if (object3 != null) {
                    string5 = ((LaunchDesc)object3).getSource();
                }
            }
        } else if (JNLPException.getDefaultLaunchDesc() != null) {
            string5 = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (JNLPException.getDefaultLaunchDesc() != null) {
            string6 = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (string6 != null && string6.equals(string5)) {
            string6 = null;
        }
        if (string5 != null) {
            object3 = new JTextArea();
            ((JTextComponent)object3).setEditable(false);
            ((JTextArea)object3).setLineWrap(true);
            ((JTextComponent)object3).setText(string5);
            jTabbedPane.add(Resources.getString("launcherrordialog.jnlpTab"), new JScrollPane((Component)object3));
        }
        if (string6 != null) {
            object3 = new JTextArea();
            ((JTextComponent)object3).setEditable(false);
            ((JTextArea)object3).setLineWrap(true);
            ((JTextComponent)object3).setText(string6);
            jTabbedPane.add(Resources.getString("launcherrordialog.jnlpMainTab"), new JScrollPane((Component)object3));
        }
        if (throwable != null) {
            object3 = new JTextArea();
            ((JTextComponent)object3).setEditable(false);
            ((JTextArea)object3).setLineWrap(true);
            ((JTextArea)object3).setWrapStyleWord(false);
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            throwable.printStackTrace((PrintWriter)object);
            ((JTextComponent)object3).setText(((StringWriter)object2).toString());
            jTabbedPane.add(Resources.getString("launcherrordialog.exceptionTab"), new JScrollPane((Component)object3));
        }
        if (jNLPException != null && jNLPException.getWrappedException() != null) {
            object3 = new JTextArea();
            ((JTextComponent)object3).setEditable(false);
            ((JTextArea)object3).setLineWrap(true);
            ((JTextArea)object3).setWrapStyleWord(false);
            object2 = new StringWriter();
            object = new PrintWriter((Writer)object2);
            jNLPException.getWrappedException().printStackTrace((PrintWriter)object);
            ((JTextComponent)object3).setText(((StringWriter)object2).toString());
            jTabbedPane.add(Resources.getString("launcherrordialog.wrappedExceptionTab"), new JScrollPane((Component)object3));
        }
        if ((object3 = Console.consoleErrorExit()) != null) {
            jTabbedPane.add(Resources.getString("launcherrordialog.consoleTab"), new JScrollPane(new JTextArea((Document)object3)));
        }
        object2 = new JButton(Resources.getString("launcherrordialog.abort"));
        ((AbstractButton)object2).setMnemonic(Resources.getVKCode("launcherrordialog.abortMnemonic"));
        object = new Box(0);
        ((Container)object).add(Box.createHorizontalGlue());
        ((Container)object).add((Component)object2);
        ((Container)object).add(Box.createHorizontalGlue());
        this.getContentPane().add("South", (Component)object);
        this.getRootPane().setDefaultButton((JButton)object2);
        ((AbstractButton)object2).addActionListener(new ActionListener(this){
            private final LaunchErrorDialog this$0;
            {
                this.this$0 = launchErrorDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Main.systemExit(-1);
            }
        });
        this.addWindowListener(new WindowAdapter(this){
            private final LaunchErrorDialog this$0;
            {
                this.this$0 = launchErrorDialog;
            }

            public void windowClosing(WindowEvent windowEvent) {
                Main.systemExit(-1);
            }
        });
        this.pack();
        this.setSize(450, 300);
        Rectangle rectangle = this.getBounds();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        rectangle.width = Math.min(dimension.width, rectangle.width);
        rectangle.height = Math.min(dimension.height, rectangle.height);
        this.setBounds((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2, rectangle.width, rectangle.height);
    }

    public static void show(Frame frame, Throwable throwable) {
        LaunchErrorDialog.showWarning(frame, throwable);
        Main.systemExit(-1);
    }

    public static void showWarning(Frame frame, Throwable throwable) {
        SplashScreen.hide();
        if (Globals.RedirectErrors) {
            System.err.println("#### Java Web Start Error:");
            System.err.println("#### " + throwable.getMessage());
        } else if (LaunchErrorDialog.wantsDetails(frame, throwable)) {
            LaunchErrorDialog launchErrorDialog = new LaunchErrorDialog(frame, throwable);
            launchErrorDialog.show();
        }
    }

    private static boolean wantsDetails(Frame frame, Throwable throwable) {
        String string = null;
        String string2 = LaunchErrorDialog.getErrorCategory(throwable);
        if (throwable instanceof JNLPException) {
            string = ((JNLPException)throwable).getBriefMessage();
        }
        if (string == null) {
            string = LaunchErrorDialog.getLaunchDescTitle() == null ? Resources.getString("launcherrordialog.brief.message") : Resources.getString("launcherrordialog.brief.messageKnown", LaunchErrorDialog.getLaunchDescTitle());
        }
        Object[] objectArray = new String[]{Resources.getString("launcherrordialog.brief.ok"), Resources.getString("launcherrordialog.brief.details")};
        int n = GeneralUtilities.showOptionDialog(frame, string, Resources.getString("launcherrordialog.brief.title", string2), -1, 0, objectArray, objectArray[0]);
        return n == 1;
    }
}

