/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.util.GeneralUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JnlpxArgs {
    private static final String ARG_JVM = "jnlpx.jvm";
    private static final String ARG_SPLASHPORT = "jnlpx.splashport";
    private static final String ARG_HOME = "jnlpx.home";
    private static final String ARG_REMOVE = "jnlpx.remove";
    private static final String ARG_OFFLINE = "jnlpx.offline";
    private static final String ARG_HEAPSIZE = "jnlpx.heapsize";
    private static final String ARG_VMARGS = "jnlpx.vmargs";
    private static final String ARG_D_S_HOME = "jnlpx.deployment.system.home";
    private static final String ARG_D_U_HOME = "jnlpx.deployment.user.home";
    private static File _currentJVMCommand = null;

    public static int getSplashPort() {
        try {
            return Integer.parseInt(System.getProperty(ARG_SPLASHPORT, "-1"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static long getInitialHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(0, string2.lastIndexOf(44));
        return GeneralUtil.heapValToLong(string3);
    }

    public static long getMaxHeapSize() {
        String string = JnlpxArgs.getHeapSize();
        if (string == null) {
            return -1L;
        }
        String string2 = string.substring(string.lastIndexOf(61) + 1);
        String string3 = string2.substring(string2.lastIndexOf(44) + 1, string2.length());
        return GeneralUtil.heapValToLong(string3);
    }

    public static void SetIsOffline() {
        System.setProperty(ARG_OFFLINE, "true");
    }

    static void verify() {
        if (Globals.TraceStartup) {
            Debug.println("Java part started");
            Debug.println("jnlpx.jvm: " + JnlpxArgs.getJVMCommand());
            Debug.println("jnlpx.splashport: " + JnlpxArgs.getSplashPort());
            Debug.println("jnlpx.home: " + JnlpxArgs.getHome());
            Debug.println("jnlpx.remove: " + JnlpxArgs.shouldRemoveArgumentFile());
            Debug.println("jnlpx.heapsize: " + JnlpxArgs.getHeapSize());
        }
        Debug.jawsAssert(JnlpxArgs.getJVMCommand() != null, "jvm propety not set");
        Debug.jawsAssert(JnlpxArgs.getHome() != null, "home property not set");
    }

    public static boolean isOffline() {
        return JnlpxArgs.getBooleanProperty(ARG_OFFLINE);
    }

    public static boolean shouldRemoveArgumentFile() {
        return JnlpxArgs.getBooleanProperty(ARG_REMOVE);
    }

    private static boolean heapSizesValid(long l, long l2) {
        return l != -1L || l2 != -1L;
    }

    public static boolean isCurrentRunningJREHeap(long l, long l2) {
        long l3 = JnlpxArgs.getInitialHeapSize();
        long l4 = JnlpxArgs.getMaxHeapSize();
        if (Globals.TraceStartup && (l != -1L || l2 != -1L)) {
            Debug.println("isCurrentRunningJREHeap: passed args: " + l + ", " + l2);
            Debug.println("JnlpxArgs is " + l3 + ", " + l4);
        }
        return l3 == l && l4 == l2;
    }

    static File getJVMCommand() {
        if (_currentJVMCommand == null) {
            String string = System.getProperty(ARG_JVM, "").trim();
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            _currentJVMCommand = new File(string);
        }
        return _currentJVMCommand;
    }

    public static String getDeploymentSystemHome() {
        return System.getProperty(ARG_D_S_HOME);
    }

    public static String getDeploymentUserHome() {
        return System.getProperty(ARG_D_U_HOME);
    }

    public static String getHeapSize() {
        return System.getProperty(ARG_HEAPSIZE);
    }

    public static String getHome() {
        return System.getProperty(ARG_HOME);
    }

    public static String getVMArgs() {
        return System.getProperty(ARG_VMARGS);
    }

    public static String setTCKHarnessOption() {
        if (Globals.TCKHarnessRun) {
            return "-XX:TCKHarnessRun=true";
        }
        return "";
    }

    public static String useBootClassPath() {
        if (Globals.BootClassPath.equals("NONE")) {
            return "";
        }
        return "-Xbootclasspath" + Globals.BootClassPath;
    }

    public static String useJCOV() {
        if (Globals.JCOV.equals("NONE")) {
            return "";
        }
        return "-Xrunjcov:file=" + Globals.JCOV;
    }

    public static String useLogToHost() {
        if (Globals.LogToHost != null) {
            return "-XX:LogToHost=" + Globals.LogToHost;
        }
        return "";
    }

    public static void setShouldRemoveArgumentFile(String string) {
        System.setProperty(ARG_REMOVE, string);
    }

    private static boolean getBooleanProperty(String string) {
        String string2 = System.getProperty(string, "false");
        return string2 != null && string2.equals("true");
    }

    public static void removeArgumentFile(String[] stringArray) {
        if (JnlpxArgs.shouldRemoveArgumentFile() && stringArray != null && stringArray.length > 0) {
            new File(stringArray[0]).delete();
        }
    }

    public static boolean isSecurePropsMatch(Properties properties) {
        Iterator iterator = ConfigProperties.getInstance().getSecurePropertyKeys();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            if (!properties.containsKey(string) || (object = properties.get(string)) == null || object.equals(System.getProperty(string))) continue;
            return false;
        }
        return true;
    }

    private static String[] getVMArgList(int n, Properties properties) {
        String[] stringArray;
        Object object;
        Vector<String> vector = new Vector<String>();
        String string = null;
        int n2 = 0;
        string = JnlpxArgs.getVMArgs();
        if (string != null) {
            object = new StringTokenizer(string, " \t\n\r\f\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                vector.add(((StringTokenizer)object).nextToken());
                ++n2;
            }
        }
        object = ConfigProperties.getInstance().getSecurePropertyKeys();
        while (object.hasNext()) {
            String string2;
            stringArray = (String[])object.next();
            if (!properties.containsKey(stringArray) || vector.contains(string2 = "-D" + (String)stringArray + "=" + properties.get(stringArray))) continue;
            vector.add(string2);
            ++n2;
        }
        stringArray = new String[n + n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = new String((String)vector.elementAt(n3));
            ++n3;
        }
        return stringArray;
    }

    public static String[] getArgumentList(String string, long l, long l2, Properties properties) {
        String string2 = "-Djnlpx.heapsize=NULL,NULL";
        String string3 = "";
        String string4 = "";
        if (JnlpxArgs.heapSizesValid(l, l2)) {
            string2 = "-Djnlpx.heapsize=" + l + "," + l2;
            if (l > 0L) {
                string3 = "-Xms" + l;
            }
            if (l2 > 0L) {
                string4 = "-Xmx" + l2;
            }
        }
        String[] stringArray = new String[]{string3, string4, JnlpxArgs.getVMArgs() != null ? "-Djnlpx.vmargs=" + JnlpxArgs.getVMArgs() : "", "-Djnlpx.jvm=" + string, "-Djnlpx.splashport=" + JnlpxArgs.getSplashPort(), "-Djnlpx.home=" + JnlpxArgs.getHome(), "-Djnlpx.remove=" + (JnlpxArgs.shouldRemoveArgumentFile() ? "true" : "false"), "-Djnlpx.offline=" + (JnlpxArgs.isOffline() ? "true" : "false"), string2, "-Djava.security.policy=file:" + JnlpxArgs.getHome() + File.separator + "javaws.policy", "-DtrustProxy=true", "-Djnlpx.deployment.user.home=" + JnlpxArgs.getDeploymentUserHome(), "-Djnlpx.deployment.system.home=" + JnlpxArgs.getDeploymentSystemHome(), "-Xbootclasspath/a:" + JnlpxArgs.getHome() + File.separator + "javaws.jar", "-classpath", File.pathSeparator + JnlpxArgs.getHome() + File.separator + "javaws-l10n.jar", JnlpxArgs.useJCOV(), JnlpxArgs.useBootClassPath(), "com.sun.javaws.Main", JnlpxArgs.setTCKHarnessOption(), JnlpxArgs.useLogToHost()};
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("")) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray2 = JnlpxArgs.getVMArgList(n, properties);
        n = stringArray2.length - n;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!stringArray[n3].equals("")) {
                stringArray2[n++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }
}

