/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHParameterGenerator;
import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a = null;
    private BigInteger b = null;
    private BigInteger c = null;
    private BigInteger d = null;
    private int e = 1024;
    private int f = 0;
    private SecureRandom g = null;
    static /* synthetic */ Class h;

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.e = n;
        this.f = 0;
        this.g = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.c = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.e = this.c.bitLength();
        if (this.e < 512 || this.e > 1024 || this.e % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Prime size must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.d = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.f = ((DHParameterSpec)algorithmParameterSpec).getL();
        this.g = secureRandom;
        if (this.f != 0 && this.f > this.e) {
            throw new InvalidAlgorithmParameterException("Exponent value must be less than (modulus value -1)");
        }
    }

    public KeyPair generateKeyPair() {
        Object object;
        KeyPair keyPair = null;
        if (this.g == null) {
            this.g = SunJCE.c;
        }
        if (this.f <= 0) {
            this.b = new BigInteger(this.e - 1, this.g).add(BigInteger.ONE);
            this.f = this.b.bitLength();
        } else {
            this.b = new BigInteger(this.f, this.g).setBit(this.f - 1);
        }
        if (this.f == this.e) {
            object = this.c.subtract(BigInteger.ONE);
            while (this.b.compareTo((BigInteger)object) != -1) {
                this.b = new BigInteger(this.f, this.g).setBit(this.f - 1);
            }
        }
        try {
            Object object2;
            if (this.c == null || this.d == null) {
                object = new DHGenParameterSpec(this.e, this.f);
                DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
                dHParameterGenerator.engineInit((AlgorithmParameterSpec)object, null);
                AlgorithmParameters algorithmParameters = dHParameterGenerator.engineGenerateParameters();
                object2 = (DHParameterSpec)algorithmParameters.getParameterSpec(h == null ? (h = DHKeyPairGenerator.class$("javax.crypto.spec.DHParameterSpec")) : h);
                this.c = ((DHParameterSpec)object2).getP();
                this.d = ((DHParameterSpec)object2).getG();
            }
            this.a = this.d.modPow(this.b, this.c);
            object = new DHPublicKey(this.a, this.c, this.d, this.f);
            object2 = new DHPrivateKey(this.b, this.c, this.d, this.f);
            keyPair = new KeyPair((PublicKey)object, (PrivateKey)object2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
        return keyPair;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

