/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_ab;
import COM.rsa.jsafe.SunJSSE_b7;
import COM.rsa.jsafe.SunJSSE_bi;
import COM.rsa.jsafe.SunJSSE_j;
import com.sun.net.ssl.internal.ssl.SunJSSE_bs;
import com.sun.net.ssl.internal.ssl.SunJSSE_bt;
import com.sun.net.ssl.internal.ssl.SunJSSE_bu;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final int a = 20;
    private static final int[] b = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] c = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] d = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] e = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static ObjectIdentifier f;
    private static ObjectIdentifier g;
    private static ObjectIdentifier h;
    private static ObjectIdentifier i;
    private static volatile int j;
    private Hashtable k = new Hashtable();
    private ArrayList l = new ArrayList();
    private HashMap m = new HashMap();
    private int n = 1;

    public int engineSize() {
        return this.k.size();
    }

    static {
        j = 0;
        try {
            f = new ObjectIdentifier(b);
            g = new ObjectIdentifier(c);
            h = new ObjectIdentifier(d);
            i = new ObjectIdentifier(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static int a(int n, int n2) {
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static void a(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / byArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(byArray, 0, byArray2, n5 + n, byArray.length);
            ++n4;
            n5 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n5 + n, n2 - n5);
    }

    static byte[] a(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 1);
    }

    static byte[] b(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 2);
    }

    static byte[] c(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 3);
    }

    private static byte[] a(char[] cArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = cArray.length;
        if ((n4 *= 2) > 0) {
            n4 += 2;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < cArray.length) {
            byArray2[n6] = (byte)(cArray[n5] >>> 8 & 0xFF);
            byArray2[n6 + 1] = (byte)(cArray[n5] & 0xFF);
            ++n5;
            n6 += 2;
        }
        n5 = 64;
        n6 = 20;
        int n7 = PKCS12KeyStore.a(n2, n6) / n6;
        byte[] byArray3 = new byte[n5];
        int n8 = PKCS12KeyStore.a(byArray.length, n5);
        int n9 = PKCS12KeyStore.a(byArray2.length, n5);
        byte[] byArray4 = new byte[n8 + n9];
        byte[] byArray5 = new byte[n2];
        Arrays.fill(byArray3, (byte)n3);
        PKCS12KeyStore.a(byArray, byArray4, 0, n8);
        PKCS12KeyStore.a(byArray2, byArray4, n8, n9);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray6 = new byte[n5];
            byte[] byArray7 = new byte[n5];
            int n10 = 0;
            while (true) {
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                byte[] byArray8 = messageDigest.digest();
                for (int i = 1; i < n; ++i) {
                    byArray8 = messageDigest.digest(byArray8);
                }
                System.arraycopy(byArray8, 0, byArray5, n6 * n10, Math.min(n2, n6));
                if (n10 + 1 != n7) {
                    PKCS12KeyStore.a(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    for (int i = 0; i < byArray4.length; i += n5) {
                        if (byArray7.length != n5) {
                            byArray7 = new byte[n5];
                        }
                        System.arraycopy(byArray4, i, byArray7, 0, n5);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n11 = byArray7.length - n5;
                        if (n11 >= 0) {
                            System.arraycopy(byArray7, n11, byArray4, i, n5);
                            continue;
                        }
                        if (n11 >= 0) continue;
                        Arrays.fill(byArray4, i, i + -n11, (byte)0);
                        System.arraycopy(byArray7, 0, byArray4, i + -n11, byArray7.length);
                    }
                    ++n10;
                    n2 -= n6;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("internal error: " + exception);
        }
        return byArray5;
    }

    private static byte[] a(SunJSSE_ab sunJSSE_ab, byte[] byArray) throws Exception {
        byte[] byArray2;
        int n = sunJSSE_ab.a(byArray.length);
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        n2 = sunJSSE_ab.a(byArray, 0, byArray.length, byArray3, 0);
        if ((n2 += sunJSSE_ab.a(byArray3, n2)) < byArray3.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray3;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object var5_4 = null;
            Object var6_5 = null;
            Hashtable hashtable2 = null;
            Object var8_7 = null;
            Object var9_8 = null;
            if (inputStream == null) {
                return;
            }
            DerValue derValue = new DerValue(inputStream);
            DerInputStream derInputStream = derValue.toDerInputStream();
            int n = derInputStream.getInteger();
            if (n != 3) {
                throw new IOException("PKCS12 keystore not in version 3 format");
            }
            hashtable2 = new Hashtable(3);
            this.k.clear();
            ContentInfo contentInfo = new ContentInfo(derInputStream);
            ObjectIdentifier objectIdentifier = contentInfo.getContentType();
            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
                throw new IOException("public key protected PKCS12 not supported");
            }
            byte[] byArray = contentInfo.getData();
            DerInputStream derInputStream2 = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream2.getSequence(2);
            int n2 = derValueArray.length;
            for (int i = 0; i < n2; ++i) {
                object5 = null;
                object4 = new DerInputStream(derValueArray[i].toByteArray());
                object3 = new ContentInfo((DerInputStream)object4);
                objectIdentifier = ((ContentInfo)object3).getContentType();
                object2 = null;
                if (objectIdentifier.equals(ContentInfo.DATA_OID)) {
                    object2 = ((ContentInfo)object3).getData();
                } else if (objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                    if (cArray == null) continue;
                    object = ((ContentInfo)object3).getContent().toDerInputStream();
                    int n3 = ((DerInputStream)object).getInteger();
                    DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                    ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                    object5 = derValueArray2[1].toByteArray();
                    if (!derValueArray2[2].isContextSpecific((byte)0)) {
                        throw new IOException("encrypted content not present!");
                    }
                    byte by = 4;
                    if (derValueArray2[2].isConstructed()) {
                        by = (byte)(by | 0x20);
                    }
                    derValueArray2[2].resetTag(by);
                    object2 = derValueArray2[2].getOctetString();
                    try {
                        SunJSSE_ab sunJSSE_ab = SunJSSE_ab.a((byte[])object5, 0, "Java");
                        SunJSSE_j sunJSSE_j = sunJSSE_ab.g();
                        sunJSSE_j.a(cArray, 0, cArray.length);
                        sunJSSE_ab.a(sunJSSE_j);
                        if (!"RC2".equals(sunJSSE_ab.m())) {
                            throw new NoSuchAlgorithmException("RC2 Only for safeContents");
                        }
                        byte[] byArray2 = sunJSSE_j.l();
                        byte[] byArray3 = sunJSSE_ab.p();
                        int[] nArray = sunJSSE_ab.q();
                        String string = "RC2-" + nArray[1] + "/CBC/PKCS5Padding";
                        sunJSSE_ab = SunJSSE_ab.a(string, "Java");
                        sunJSSE_ab.c(byArray3, 0, byArray3.length);
                        sunJSSE_j = sunJSSE_ab.g();
                        sunJSSE_j.a(byArray2, 0, byArray2.length);
                        sunJSSE_ab.a(sunJSSE_j);
                        object2 = PKCS12KeyStore.a(sunJSSE_ab, (byte[])object2);
                    }
                    catch (Exception exception) {
                        throw new IOException("failed to decrypt safe contents entry");
                    }
                } else {
                    throw new IOException("public key protected PKCS12 not supported");
                }
                object = new DerInputStream((byte[])object2);
                this.a((DerInputStream)object, cArray);
            }
            if (cArray != null && derInputStream.available() > 0) {
                SunJSSE_bs sunJSSE_bs = new SunJSSE_bs(derInputStream);
                try {
                    object2 = sunJSSE_bs.a().toUpperCase();
                    if (((String)object2).equals("SHA") || ((String)object2).equals("SHA1") || ((String)object2).equals("SHA-1")) {
                        object2 = "SHA1";
                    }
                    object3 = SunJSSE_b7.a("HMAC/" + (String)object2, "Java");
                    object4 = PKCS12KeyStore.c(cArray, sunJSSE_bs.b(), sunJSSE_bs.c(), 20);
                    object5 = ((SunJSSE_b7)object3).c();
                    ((SunJSSE_j)object5).a((byte[])object4, 0, ((Object)object4).length);
                    ((SunJSSE_b7)object3).a((SunJSSE_j)object5, new SecureRandom());
                    ((SunJSSE_b7)object3).a(byArray, 0, byArray.length);
                    object = ((SunJSSE_b7)object3).i();
                    if (!Arrays.equals(sunJSSE_bs.d(), (byte[])object)) {
                        throw new SecurityException("Failed PKCS12 integrity checking");
                    }
                }
                catch (Exception exception) {
                    throw new IOException("integrity check: " + exception);
                }
            }
            Object[] objectArray = this.l.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object3 = (SunJSSE_bt)objectArray[i];
                if (((SunJSSE_bt)object3).d == null) continue;
                object4 = new ArrayList();
                object5 = (X509Certificate)this.m.get(new KeyId(this, ((SunJSSE_bt)object3).d));
                while (object5 != null) {
                    ((ArrayList)object4).add(object5);
                    object = ((X509Certificate)object5).getIssuerX500Principal();
                    if (((X500Principal)object).equals(((X509Certificate)object5).getSubjectX500Principal())) break;
                    object5 = (X509Certificate)this.m.get(object);
                }
                if (((ArrayList)object4).size() <= 0) continue;
                ((SunJSSE_bt)object3).c = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
            }
            this.m.clear();
            this.l.clear();
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            throw new IOException("PKCS 12 storing not implemented");
        }
    }

    private String a() {
        return String.valueOf(++j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            this.k.remove(string.toLowerCase());
        }
    }

    public boolean engineContainsAlias(String string) {
        return this.k.containsKey(string.toLowerCase());
    }

    public boolean engineIsCertificateEntry(String string) {
        Object v = this.k.get(string.toLowerCase());
        return v != null && v instanceof SunJSSE_bu;
    }

    public boolean engineIsKeyEntry(String string) {
        Object v = this.k.get(string.toLowerCase());
        return v != null && v instanceof SunJSSE_bt;
    }

    public Enumeration engineAliases() {
        return this.k.keys();
    }

    private void a(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DerValue[] derValueArray2;
            DerValue[] derValueArray3 = null;
            DerInputStream derInputStream2 = derValueArray[i].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(f)) {
                derValueArray2 = new SunJSSE_bt(this);
                derValueArray2.b = derValue.toByteArray();
                derValueArray2.a = new Date();
                derValueArray3 = derValueArray2;
            } else if (objectIdentifier.equals(g)) {
                derValueArray2 = new DerInputStream(derValue.toByteArray());
                object4 = derValueArray2.getSequence(2);
                object3 = object4[0].getOID();
                if (!object4[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object4[1].tag);
                }
                DerValue derValue2 = object4[1].data.getDerValue();
                object2 = CertificateFactory.getInstance("X509");
                object = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
                derValueArray3 = object;
            } else {
                throw new IOException("unsupported PKCS12 bag type " + objectIdentifier);
            }
            derValueArray2 = derInputStream2.getSet(2);
            object4 = null;
            object3 = null;
            for (int j = 0; j < derValueArray2.length; ++j) {
                object2 = new DerInputStream(derValueArray2[j].toByteArray());
                object = ((DerInputStream)object2).getSequence(2);
                ObjectIdentifier objectIdentifier2 = object[0].getOID();
                DerInputStream derInputStream3 = new DerInputStream(object[1].toByteArray());
                DerValue[] derValueArray4 = derInputStream3.getSet(2);
                if (objectIdentifier2.equals(h)) {
                    object4 = derValueArray4[0].getBMPString();
                    continue;
                }
                if (objectIdentifier2.equals(PKCS12KeyStore.i)) {
                    object3 = derValueArray4[0].getOctetString();
                    continue;
                }
                System.out.println("unknown attr" + objectIdentifier2);
            }
            if (derValueArray3 instanceof SunJSSE_bt) {
                SunJSSE_bt sunJSSE_bt = (SunJSSE_bt)derValueArray3;
                if (object3 == null) continue;
                sunJSSE_bt.d = (byte[])object3;
                this.l.add(sunJSSE_bt);
                if (object4 == null) {
                    object4 = this.a();
                }
                this.k.put(((String)object4).toLowerCase(), sunJSSE_bt);
                continue;
            }
            if (!(derValueArray3 instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)derValueArray3;
            if (object3 != null) {
                this.m.put(new KeyId(this, (byte[])object3), derValueArray3);
            }
            if (object4 != null) {
                this.m.put(object4, derValueArray3);
            }
            if ((object2 = x509Certificate.getSubjectX500Principal()) == null) continue;
            this.m.put(object2, derValueArray3);
        }
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.k.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.k.get(string);
            if (v instanceof SunJSSE_bu) {
                certificate2 = ((SunJSSE_bu)v).b;
            } else {
                if (((SunJSSE_bt)v).c == null) continue;
                certificate2 = ((SunJSSE_bt)v).c[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v = this.k.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v == null || !(v instanceof SunJSSE_bt)) {
            return null;
        }
        byte[] byArray = ((SunJSSE_bt)v).b;
        try {
            DerValue derValue = new DerValue(byArray);
            DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
            if (derValue.data.available() != 0) {
                throw new IOException("overrun, bytes = " + derValue.data.available());
            }
            byte[] byArray2 = derValueArray[1].getOctetString();
            SunJSSE_ab sunJSSE_ab = SunJSSE_ab.a(byArray, 0, "Java");
            SunJSSE_j sunJSSE_j = sunJSSE_ab.g();
            sunJSSE_j.a(cArray, 0, cArray.length);
            sunJSSE_ab.a(sunJSSE_j);
            if (!"3DES_EDE".equals(sunJSSE_ab.m())) {
                throw new NoSuchAlgorithmException("3DES_EDE only for shrouded keys");
            }
            byte[] byArray3 = PKCS12KeyStore.a(cArray, sunJSSE_ab.u(), sunJSSE_ab.q()[0], sunJSSE_ab.q()[1] * sunJSSE_ab.h());
            byte[] byArray4 = PKCS12KeyStore.b(cArray, sunJSSE_ab.u(), sunJSSE_ab.q()[0], sunJSSE_ab.h());
            String string2 = sunJSSE_ab.m() + "/" + sunJSSE_ab.n() + "/" + sunJSSE_ab.s();
            sunJSSE_ab = SunJSSE_ab.a(string2, "Java");
            sunJSSE_ab.c(byArray4, 0, byArray4.length);
            sunJSSE_j = sunJSSE_ab.g();
            sunJSSE_j.a(byArray3, 0, byArray3.length);
            sunJSSE_ab.a(sunJSSE_j);
            byte[] byArray5 = PKCS12KeyStore.a(sunJSSE_ab, byArray2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray5);
            SunJSSE_bi sunJSSE_bi = SunJSSE_bi.a(byArray5, 0, "Java");
            KeyFactory keyFactory = KeyFactory.getInstance(sunJSSE_bi.d());
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
        return privateKey;
    }

    public Certificate engineGetCertificate(String string) {
        Object v = this.k.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof SunJSSE_bu) {
                return ((SunJSSE_bu)v).b;
            }
            if (((SunJSSE_bt)v).c == null) {
                return null;
            }
            return ((SunJSSE_bt)v).c[0];
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.k.get(string.toLowerCase());
        if (v != null && v instanceof SunJSSE_bt) {
            if (((SunJSSE_bt)v).c == null) {
                return null;
            }
            return (Certificate[])((SunJSSE_bt)v).c.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            Object v = this.k.get(string.toLowerCase());
            if (v != null && v instanceof SunJSSE_bt) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            SunJSSE_bu sunJSSE_bu = new SunJSSE_bu(this);
            sunJSSE_bu.b = certificate;
            sunJSSE_bu.a = new Date();
            this.k.put(string.toLowerCase(), sunJSSE_bu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            SunJSSE_bt sunJSSE_bt = new SunJSSE_bt(this);
            sunJSSE_bt.a = new Date();
            sunJSSE_bt.b = (byte[])byArray.clone();
            if (certificateArray != null) {
                sunJSSE_bt.c = (Certificate[])certificateArray.clone();
            }
            this.k.put(string.toLowerCase(), sunJSSE_bt);
        }
    }

    public Date engineGetCreationDate(String string) {
        Object v = this.k.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof SunJSSE_bu) {
                return new Date(((SunJSSE_bu)v).a.getTime());
            }
            return new Date(((SunJSSE_bt)v).a.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            Hashtable hashtable = this.k;
            synchronized (hashtable) {
                SunJSSE_bt sunJSSE_bt = new SunJSSE_bt(this);
                sunJSSE_bt.a = new Date();
                if (certificateArray != null) {
                    sunJSSE_bt.c = (Certificate[])certificateArray.clone();
                }
                this.k.put(string.toLowerCase(), sunJSSE_bt);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
    }

    class KeyId {
        byte[] a;
        private final PKCS12KeyStore b;

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.a.length; ++i) {
                n += this.a[i];
            }
            return n;
        }

        KeyId(PKCS12KeyStore pKCS12KeyStore, byte[] byArray) {
            this.b = pKCS12KeyStore;
            this.a = byArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            if (this.a == keyId.a) {
                return true;
            }
            if (this.a.length != keyId.a.length) {
                return false;
            }
            for (int i = 0; i < this.a.length; ++i) {
                if (this.a[i] == keyId.a[i]) continue;
                return false;
            }
            return true;
        }
    }
}

