#!/bin/sh
#
# /etc/rc.d/rc.S:  System initialization script.
#
# Mostly written by:  Patrick J. Volkerding, <volkerdi@ftp.cdrom.com>
#
# Adapted for BsV by Jonathan B. Araujo Neto jones@brfree.com.br
#

PATH=/sbin:/usr/sbin:/bin:/usr/bin
dmesg -n 1

#Set YES if you want a "rainbow-technicolor" initialization
export  RCINITCOLORS="YES" # {YES|NO}

echoc "==> rc.S  Setting up the base system configuration....." blue
sleep 2

# enable swapping
/sbin/swapon -a

# Start update.
/sbin/update &

# Test to see if the root partition is read-only, like it ought to be.
READWRITE=no
if echo -n >> "Testing filesystem status"; then
 rm -f "Testing filesystem status"
 READWRITE=yes
fi

# Check the integrity of all filesystems
if [ ! $READWRITE = yes ]; then
 /sbin/fsck -A -C -a
 # If there was a failure, drop into single-user mode.
 if [ $? -gt 1 ] ; then
  echo
  echo
  echo "*******************************************************"
  echo "*** An error occurred during the file system check. ***"
  echo "*** You will now be given a chance to log into the  ***"
  echo "*** system in single-user mode to fix the problem.  ***"
  echo "*** Running 'e2fsck -v -y <partition>' might help.  ***"
  echo "*******************************************************"
  echo
  echo "Once you exit the single-user shell, the system will reboot."
  echo

  PS1="(Repair filesystem) \#"; export PS1
  sulogin

  echo "Unmounting file systems..."
  umount -a
  mount -n -o remount,ro /
  echo "Rebooting system..."
  sleep 2
  reboot
 fi



 
 # Remount the root filesystem in read-write mode
 echo "Remounting root device with read-write enabled."
 /bin/mount -w -v -n -o remount /
 if [ $? -gt 0 ] ; then
  echo
  echo "Attempt to remount root device as read-write failed!  This is going to"
  echo "cause serious problems...  "
  echo 
  echo "If you're using the UMSDOS filesystem, you **MUST** mount the root partition"
  echo "read-write!  You can make sure the root filesystem is getting mounted "
  echo "read-write with the 'rw' flag to Loadlin:"
  echo
  echo "loadlin vmlinuz root=/dev/hda1 rw   (replace /dev/hda1 with your root device)"
  echo
  echo "Normal bootdisks can be made to mount a system read-write with the rdev command:"
  echo
  echo "rdev -R /dev/fd0 0"
  echo
  echo "You can also get into your system by using a bootkernel disk with a command"
  echo "like this on the LILO prompt line:  (change the root partition name as needed)"
  echo 
  echo "LILO: mount root=/dev/hda1 rw"
  echo
  echo "Please press ENTER to continue, then reboot and use one of the above methods to"
  echo -n "get into your machine and start looking for the problem. " 
  read junk; 
 fi
else
 echo "Testing filesystem status: read-write filesystem"
 if cat /etc/fstab | grep ' / ' | grep umsdos 1> /dev/null 2> /dev/null ; then
  ROOTTYPE="umsdos"
 fi
 if [ ! "$ROOTTYPE" = "umsdos" ]; then # no warn for UMSDOS
  cat << EOF

*** ERROR: Root partition has already been mounted read-write. Cannot check!

For filesystem checking to work properly, your system must initially mount
the root partition as read only. Please modify your kernel with 'rdev' so that
it does this. If you're booting with LILO, add a line:

   read-only

to the Linux section in your /etc/lilo.conf and type 'lilo' to reinstall it.

If you boot from a kernel on a floppy disk, put it in the drive and type:
  rdev -R /dev/fd0 1

If you boot from a bootkernel disk, or with Loadlin, you can add the 'ro' flag.

This will fix the problem *AND* eliminate this annoying message. :^)

EOF
  echo -n "Press ENTER to continue. "
  read junk;
 fi
fi


# Force creation of a new mtab deleting old one
/bin/rm -f /etc/mtab* 

# mount file systems in fstab (and create an entry for /)
# but not NFS because TCP/IP is not yet configured
/bin/mount -a -v -t nonfs

if [ "$ROOTTYPE" = "umsdos" ]; then # we need to update any files added in DOS:
 echo "Synchronizing UMSDOS directory structure"
 echo "  umssync -r99 -v- / "
 umssync -r99 -v- /
fi


# Screen blanks after 15 minutes idle time.
/bin/setterm -blank 0


# Set the system time from the hardware clock using hwclock
if [ -x /sbin/hwclock ]; then
  echo "Setting system time from hardware clock..."
  if [ -e /etc/hardwareclock ]; then
    HC=`cat /etc/hardwareclock | while read LINE ; do
      if [ "$LINE" = "UTC" -o "$LINE" = "utc" ]; then
        echo utc
        break;
      elif [ "$LINE" = "localtime" ]; then
        echo localtime
        break;
      fi
    done`
  else
    # Default to localtime if there is no /etc/hardwareclock:
    HC=localtime
  fi
  # /sbin/hwclock --$HC --hctosys
  # The line above *should* work with --localtime, but doesn't.  Omitting
  # the argument defaults it to localtime, so use that.
  if [ "$HC" = "utc" ]; then
    /sbin/hwclock --utc --hctosys
  else
    /sbin/hwclock --hctosys
  fi
fi

# Carry an entropy pool between reboots to improve randomness.
# Load and then save 512 bytes, which is the size of the entropy pool.
if [ -f /etc/random-seed ]; then
  echo "Using /etc/random-seed to initialize /dev/urandom..."
  cat /etc/random-seed >/dev/urandom
fi
dd if=/dev/urandom of=/etc/random-seed count=1 bs=512 2> /dev/null


# If there's no /etc/HOSTNAME, fall back on this default:
if [ ! -r /etc/HOSTNAME ]; then
 echo "msx.myhome.net" > /etc/HOSTNAME
fi

# Setup the /etc/issue and /etc/motd to reflect the current kernel level:
# THESE WIPE ANY CHANGES YOU MAKE TO /ETC/ISSUE AND /ETC/MOTD WITH EACH
# BOOT. COMMENT THEM OUT IF YOU WANT TO MAKE CUSTOM VERSIONS.
#echo > /etc/issue
#echo Welcome to Linux `/bin/uname -a | /bin/cut -d\  -f3`. >> /etc/issue
#echo "Powered by VectorLinux and BsV" >> /etc/issue
#echo >> /etc/issue
echo "`/bin/uname -a | /bin/cut -d\  -f1,3`. Type vasm to enter setup menu." > /etc/motd
/sbin/linux_logo -c -t "Brought to you by Vector-Linux 4.0" > /etc/issue
/sbin/linux_logo -c > /etc/issue.net

# Set the hostname.  This might not work correctly if TCP/IP is not 
# compiled in the kernel.
/bin/hostname `cat /etc/HOSTNAME | cut -f1 -d .`




# Remove undesired things
echo "Removing stale lock, temporary and junk files so the game can start "
# remove /etc/mtab* so that mount will create it with a root entry
/bin/rm -f  /etc/nologin /etc/shutdownpid /etc/dhcpc/*.pid 

# Clean up temporary files on the /var volume:
/bin/rm -f /var/run/utmp /var/run/*.pid /var/log/setup/tmp/*

# Remove stale locks and junk files (must be done after mount -a!)
/bin/rm -f /var/lock/* /var/spool/uucp/LCK..* /tmp/.X*lock /tmp/core /core 1> /dev/null 2> /dev/null

# Remove stale hunt sockets so the game can start.
if [ -r /tmp/hunt -o -r /tmp/hunt.stats ]; then
  /bin/rm -f /tmp/hunt*
fi



# Ensure basic filesystem permissions sanity.
echo "Ensuring basic filesystem permissions sanity" 
chmod 755 /
chmod 1777 /tmp /var/tmp


# Looks like we have to create this.
cat /dev/null > /var/run/utmp


# Update all the shared library links automatically
echo "Updating shared libraries links"

/sbin/ldconfig


#Now Run "multiuser" script
/etc/rc.d/rc.M


