
try {
  var chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService();
  if (chromeRegistry)
    chromeRegistry = chromeRegistry.QueryInterface(Components.interfaces.nsIXULChromeRegistry);
}
catch(e) {}

function Startup()
{
  var extList = document.getElementById("extList");
  for (var i = 0; i < extList.childNodes.length; ++i) {
    if (extList.childNodes[i].getAttribute("name")) {
      extList.selectItem(extList.childNodes[i]);
      break;
    }
  }
}

function extensionSelect()
{
  var list = document.getElementById("extList");

  if (!list)
    return;

  var selectedItem = list.selectedItems.length ? list.selectedItems[0] : null;
  if (selectedItem) {
    var extName = selectedItem.getAttribute("displayName");
    var nameField = document.getElementById("extDisplayName");
    var author = document.getElementById("extAuthor");
    var descText = document.createTextNode(selectedItem.getAttribute("description"));
    var description = document.getElementById("extDescription");
    var uninstallButton = document.getElementById("uninstallExtension");
    var settingsButton = document.getElementById("extensionSettings");
    
    while (description.hasChildNodes())
      description.removeChild(description.firstChild);

    nameField.setAttribute("value", extName);
    
    author.setAttribute("value", selectedItem.getAttribute("author"));
    var authorURL = selectedItem.getAttribute("authorURL");
    if (authorURL != "") {
      author.setAttribute("link", selectedItem.getAttribute("authorURL"));
      author.className = "themesLink";
    }
    else {
      author.removeAttribute("link");
      author.className = "";
    }
    
    settingsButton.disabled = selectedItem.getAttribute("settingsURL") == "";
    
    description.appendChild(descText);

    updateDisableExtButton(selectedItem);
  }
}

function toggleExtension()
{
  var list = document.getElementById("extList");

  if (!list)
    return;

  var selectedItem = list.selectedItems.length ? list.selectedItems[0] : null;
  if (selectedItem) {
    var disabled = (selectedItem.getAttribute("disabledState") == "true");
    chromeRegistry.setAllowOverlaysForPackage(selectedItem.getAttribute("name"), disabled);
    updateDisableExtButton(selectedItem);
  }   
}

function updateDisableExtButton(item)
{
  var disableButton = document.getElementById("disableExtension");
  if (disableButton.disabled)
    disableButton.disabled = false;

  if (item.getAttribute("disabledState") == "true")
    disableButton.setAttribute("label", "Enable Extension"); // XXXdwh localize
  else
    disableButton.setAttribute("label", "Disable Extension"); // XXXdwh localize
}

function showSettings()
{
  var list = document.getElementById("extList");
  var selectedItem = list.selectedItems.length ? list.selectedItems[0] : null;
  if (selectedItem)
    window.openDialog(selectedItem.getAttribute("settingsURL"), "", "chrome,dialog,modal");
}

