/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletContext;
import org.kde.kjas.server.Main;

public class KJASProtocolHandler {
    private static final int CreateContextCode = 1;
    private static final int DestroyContextCode = 2;
    private static final int CreateAppletCode = 3;
    private static final int DestroyAppletCode = 4;
    private static final int StartAppletCode = 5;
    private static final int StopAppletCode = 6;
    private static final int InitAppletCode = 7;
    private static final int ShowDocumentCode = 8;
    private static final int ShowURLInFrameCode = 9;
    private static final int ShowStatusCode = 10;
    private static final int ResizeAppletCode = 11;
    private static final int GetURLDataCode = 12;
    private static final int URLDataCode = 13;
    private static final int ShutdownServerCode = 14;
    private static final int JavaScriptEvent = 15;
    private static final int GetMember = 16;
    private static final int CallMember = 17;
    private static final int PutMember = 18;
    private static final int DerefObject = 19;
    private static final int AudioClipPlayCode = 20;
    private static final int AudioClipLoopCode = 21;
    private static final int AudioClipStopCode = 22;
    private static final int AppletStateNotificationCode = 23;
    private static final int AppletFailedCode = 24;
    private Hashtable contexts;
    private PushbackInputStream commands;
    private PrintStream signals;
    private int cmd_index;
    private static final char sep = '\u0000';

    public KJASProtocolHandler(InputStream inputStream, OutputStream outputStream) {
        this.commands = new PushbackInputStream(inputStream);
        this.signals = new PrintStream(outputStream);
        this.contexts = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    public void commandLoop() {
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        var1_1 = this.readPaddedLength(8);
                        Main.debug("PH: cmd_length = " + var1_1);
                        var2_4 = new byte[var1_1];
                        var3_6 = 0;
                        while (var3_6 < var1_1) {
                            var4_7 = this.commands.read(var2_4, var3_6, var1_1 - var3_6);
                            Main.debug("PH: read in " + var4_7 + " bytes for command");
                            var3_6 += var4_7;
                        }
                        this.processCommand(var2_4);
                    }
                }
                catch (NumberFormatException var1_2) {
                    Main.kjas_err("Could not parse out message length", var1_2);
                    System.exit(1);
                }
                catch (Throwable var2_5) {
                    Main.debug("commandLoop caught a throwable, still going");
                    var2_5.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception var1_3) {
            Main.kjas_err("commandLoop exited on exception: ", var1_3);
            System.exit(1);
            return;
        }
        ** GOTO lbl-1000
    }

    public void processCommand(byte[] byArray) {
        byte by;
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        this.cmd_index = 0;
        if ((by = byArray[this.cmd_index++]) == 1) {
            String string = this.getArg(byArray);
            Main.debug("createContext, id = " + string);
            KJASAppletContext kJASAppletContext = new KJASAppletContext(string);
            this.contexts.put(string, kJASAppletContext);
        } else if (by == 2) {
            String string = this.getArg(byArray);
            Main.debug("destroyContext, id = " + string);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (this.contexts != null) {
                kJASAppletContext.destroy();
                this.contexts.remove(string);
            }
        } else if (by == 3) {
            Object object;
            String string = this.getArg(byArray);
            String string2 = this.getArg(byArray);
            String string3 = this.getArg(byArray);
            String string4 = this.getArg(byArray);
            String string5 = this.getArg(byArray);
            String string6 = this.getArg(byArray);
            String string7 = this.getArg(byArray);
            String string8 = this.getArg(byArray);
            String string9 = this.getArg(byArray);
            String string10 = this.getArg(byArray);
            String string11 = this.getArg(byArray);
            String string12 = this.getArg(byArray);
            String string13 = this.getArg(byArray);
            String string14 = this.getArg(byArray);
            int n2 = Integer.parseInt(string14.trim());
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n3 = 0;
            while (n3 < n2) {
                String string15;
                object = this.getArg(byArray);
                if (object == null) {
                    object = new String();
                }
                if ((string15 = this.getArg(byArray)) == null) {
                    string15 = new String();
                }
                hashtable.put(((String)object).toUpperCase(), string15);
                ++n3;
            }
            Main.debug("createApplet, context = " + string + ", applet = " + string2);
            Main.debug("              name = " + string3 + ", classname = " + string4);
            Main.debug("              baseURL = " + string5 + ", codeBase = " + string9);
            Main.debug("              archives = " + string10 + ", width = " + string11 + ", height = " + string12);
            object = (KJASAppletContext)this.contexts.get(string);
            if (object != null) {
                ((KJASAppletContext)object).createApplet(string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, hashtable);
            }
        } else if (by == 4) {
            String string = this.getArg(byArray);
            String string16 = this.getArg(byArray);
            Main.debug("destroyApplet, context = " + string + ", applet = " + string16);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.destroyApplet(string16);
            }
        } else if (by == 5) {
            String string = this.getArg(byArray);
            String string17 = this.getArg(byArray);
            Main.debug("startApplet, context = " + string + ", applet = " + string17);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.startApplet(string17);
            }
        } else if (by == 6) {
            String string = this.getArg(byArray);
            String string18 = this.getArg(byArray);
            Main.debug("stopApplet, context = " + string + ", applet = " + string18);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.stopApplet(string18);
            }
        } else if (by == 14) {
            Main.debug("shutDownServer recieved");
            System.exit(1);
        } else if (by == 13) {
            Main.debug("URLData recieved");
            String string = this.getArg(byArray);
            String string19 = this.getArg(byArray);
            Main.debug("data is for loader: " + string);
            Main.debug("URL is " + string19);
            byte[] byArray2 = new byte[n - this.cmd_index];
            System.arraycopy(byArray, this.cmd_index, byArray2, 0, byArray2.length);
            KJASAppletClassLoader kJASAppletClassLoader = KJASAppletClassLoader.getLoader(string);
            if (kJASAppletClassLoader != null) {
                Main.info("this is a class loader request and should not happen!");
            } else {
                KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
                if (kJASAppletContext != null) {
                    Main.debug("this is  a context request for an image");
                    kJASAppletContext.addImage(string19, byArray2);
                }
            }
        } else if (by == 16) {
            String string = this.getArg(byArray);
            String string20 = this.getArg(byArray);
            int n4 = Integer.parseInt(this.getArg(byArray));
            int n5 = Integer.parseInt(this.getArg(byArray));
            String string21 = this.getArg(byArray);
            int[] nArray = new int[]{-1, 0};
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                nArray = kJASAppletContext.getMember(string20, n5, string21, stringBuffer);
            }
            Main.debug("GetMember " + string21 + "=" + stringBuffer.toString());
            this.sendMemberValue(string, 16, n4, nArray[0], nArray[1], stringBuffer.toString());
        } else if (by == 18) {
            String string = this.getArg(byArray);
            String string22 = this.getArg(byArray);
            int n6 = Integer.parseInt(this.getArg(byArray));
            int n7 = Integer.parseInt(this.getArg(byArray));
            String string23 = this.getArg(byArray);
            String string24 = this.getArg(byArray);
            boolean bl = false;
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                bl = kJASAppletContext.putMember(string22, n7, string23, string24);
            }
            Main.debug("PutMember " + string23 + "=" + string24);
            this.sendPutMember(string, n6, bl);
        } else if (by == 17) {
            new Thread("CallMember"){
                byte[] command;

                public void run() {
                    String string = KJASProtocolHandler.this.getArg(this.command);
                    String string2 = KJASProtocolHandler.this.getArg(this.command);
                    int n = Integer.parseInt(KJASProtocolHandler.this.getArg(this.command));
                    int n2 = Integer.parseInt(KJASProtocolHandler.this.getArg(this.command));
                    String string3 = KJASProtocolHandler.this.getArg(this.command);
                    int[] nArray = new int[]{-1, 0};
                    StringBuffer stringBuffer = new StringBuffer();
                    Vector<String> vector = new Vector<String>();
                    try {
                        String string4 = KJASProtocolHandler.this.getArg(this.command);
                        while (string4 != null) {
                            vector.add(string4);
                            string4 = KJASProtocolHandler.this.getArg(this.command);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean bl = false;
                    KJASAppletContext kJASAppletContext = (KJASAppletContext)KJASProtocolHandler.this.contexts.get(string);
                    if (kJASAppletContext != null) {
                        nArray = kJASAppletContext.callMember(string2, n2, string3, stringBuffer, vector);
                    }
                    Main.debug("CallMember " + string3 + "=" + stringBuffer.toString());
                    KJASProtocolHandler.this.sendMemberValue(string, 17, n, nArray[0], nArray[1], stringBuffer.toString());
                }

                void startIt(byte[] byArray) {
                    this.command = byArray;
                    this.start();
                }
            }.startIt(byArray);
        } else if (by == 19) {
            String string = this.getArg(byArray);
            String string25 = this.getArg(byArray);
            String string26 = this.getArg(byArray);
            KJASAppletContext kJASAppletContext = (KJASAppletContext)this.contexts.get(string);
            if (kJASAppletContext != null) {
                kJASAppletContext.derefObject(Integer.parseInt(string26));
            }
            Main.debug("DerefObject " + string26);
        } else {
            throw new IllegalArgumentException("Unknown command code");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGetURLDataCmd(String string, String string2) {
        int n;
        Main.info("sendGetURLCmd from loader: " + string + " url = " + string2);
        String string3 = null;
        String string4 = null;
        try {
            string3 = string;
            string4 = new URL(new URL(string), string2).toString();
            n = string3.length() + string4.length() + 4;
        }
        catch (MalformedURLException malformedURLException) {
            int n2;
            try {
                string3 = string;
                string4 = string2;
                n2 = string3.length() + string4.length() + 4;
            }
            catch (Throwable throwable) {
                int n3 = string3.length() + string4.length() + 4;
                char[] cArray = new char[n3 + 8];
                char[] cArray2 = this.getPaddedLength(n3);
                int n4 = 0;
                System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
                n4 += cArray2.length;
                cArray[n4++] = 12;
                cArray[n4++] = '\u0000';
                cArray2 = string3.toCharArray();
                System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
                n4 += cArray2.length;
                cArray[n4++] = '\u0000';
                cArray2 = string4.toCharArray();
                System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
                n4 += cArray2.length;
                cArray[n4++] = '\u0000';
                this.signals.print(cArray);
                throw throwable;
            }
            char[] cArray = new char[n2 + 8];
            char[] cArray3 = this.getPaddedLength(n2);
            int n5 = 0;
            System.arraycopy(cArray3, 0, cArray, n5, cArray3.length);
            n5 += cArray3.length;
            cArray[n5++] = 12;
            cArray[n5++] = '\u0000';
            cArray3 = string3.toCharArray();
            System.arraycopy(cArray3, 0, cArray, n5, cArray3.length);
            n5 += cArray3.length;
            cArray[n5++] = '\u0000';
            cArray3 = string4.toCharArray();
            System.arraycopy(cArray3, 0, cArray, n5, cArray3.length);
            n5 += cArray3.length;
            cArray[n5++] = '\u0000';
            this.signals.print(cArray);
        }
        char[] cArray = new char[n + 8];
        char[] cArray4 = this.getPaddedLength(n);
        int n6 = 0;
        System.arraycopy(cArray4, 0, cArray, n6, cArray4.length);
        n6 += cArray4.length;
        cArray[n6++] = 12;
        cArray[n6++] = '\u0000';
        cArray4 = string3.toCharArray();
        System.arraycopy(cArray4, 0, cArray, n6, cArray4.length);
        n6 += cArray4.length;
        cArray[n6++] = '\u0000';
        cArray4 = string4.toCharArray();
        System.arraycopy(cArray4, 0, cArray, n6, cArray4.length);
        n6 += cArray4.length;
        cArray[n6++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendAppletStateNotification(String string, String string2, int n) {
        Main.debug("sendAppletStateNotification, contextID = " + string + ", appletID = " + string2 + ", state=" + n);
        String string3 = String.valueOf(n);
        int n2 = string.length() + string2.length() + string3.length() + 5;
        char[] cArray = new char[n2 + 8];
        char[] cArray2 = this.getPaddedLength(n2);
        int n3 = 0;
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = 23;
        cArray[n3++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendAppletFailed(String string, String string2, String string3) {
        Main.debug("sendAppletFailed, contextID = " + string + ", appletID = " + string2 + ", errorMessage=" + string3);
        int n = string.length() + string2.length() + string3.length() + 5;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 24;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendShowDocumentCmd(String string, String string2) {
        Main.debug("sendShowDocumentCmd from context#" + string + " url = " + string2);
        int n = string.length() + string2.length() + 4;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 8;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendShowDocumentCmd(String string, String string2, String string3) {
        Main.debug("sendShowDocumentCmd from context#" + string + " url = " + string2 + ", frame = " + string3);
        int n = string.length() + string2.length() + string3.length() + 5;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 9;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendShowStatusCmd(String string, String string2) {
        Main.debug("sendShowStatusCmd, contextID = " + string + " msg = " + string2);
        int n = string.length() + string2.length() + 4;
        char[] cArray = new char[n + 8];
        char[] cArray2 = this.getPaddedLength(n);
        int n2 = 0;
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = 10;
        cArray[n2++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
        n2 += cArray2.length;
        cArray[n2++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendResizeAppletCmd(String string, String string2, int n, int n2) {
        Main.debug("sendResizeAppletCmd, contextID = " + string + ", appletID = " + string2 + ", width = " + n + ", height = " + n2);
        String string3 = String.valueOf(n);
        String string4 = String.valueOf(n2);
        int n3 = string.length() + string2.length() + string3.length() + string4.length() + 6;
        char[] cArray = new char[n3 + 8];
        char[] cArray2 = this.getPaddedLength(n3);
        int n4 = 0;
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = 10;
        cArray[n4++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string4.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendJavaScriptEventCmd(String string, String string2, int n, String string3, int[] nArray, String[] stringArray) {
        Main.debug("sendJavaScriptEventCmd, contextID = " + string + " event = " + string3);
        String string4 = new String("" + n);
        int n2 = string.length() + string2.length() + string3.length() + string4.length() + 6;
        String[] stringArray2 = null;
        if (nArray != null) {
            stringArray2 = new String[stringArray.length];
            int n3 = 0;
            while (n3 < nArray.length) {
                stringArray2[n3] = new String("" + nArray[n3]);
                Main.debug("sendJavaScriptEventCmd, length = " + (n2 += 2 + stringArray2[n3].length() + stringArray[n3].length()));
                ++n3;
            }
        }
        char[] cArray = new char[n2 + 8];
        char[] cArray2 = this.getPaddedLength(n2);
        int n4 = 0;
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = 15;
        cArray[n4++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string4.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
        n4 += cArray2.length;
        cArray[n4++] = '\u0000';
        if (nArray != null) {
            int n5 = 0;
            while (n5 < nArray.length) {
                cArray2 = stringArray2[n5].toCharArray();
                System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
                n4 += cArray2.length;
                cArray[n4++] = '\u0000';
                cArray2 = stringArray[n5].toCharArray();
                System.arraycopy(cArray2, 0, cArray, n4, cArray2.length);
                Main.debug("sendJavaScriptEventCmd, index = " + (n4 += cArray2.length));
                cArray[n4++] = '\u0000';
                ++n5;
            }
        }
        this.signals.print(cArray);
    }

    public void sendMemberValue(String string, int n, int n2, int n3, int n4, String string2) {
        Main.debug("sendMemberValue, contextID = " + string + " value = " + string2 + " type=" + n3 + " rid=" + n4);
        String string3 = new String("" + n2);
        String string4 = new String("" + n3);
        String string5 = new String("" + n4);
        int n5 = string.length() + string2.length() + string4.length() + string5.length() + string3.length() + 7;
        char[] cArray = new char[n5 + 8];
        char[] cArray2 = this.getPaddedLength(n5);
        int n6 = 0;
        System.arraycopy(cArray2, 0, cArray, n6, cArray2.length);
        n6 += cArray2.length;
        cArray[n6++] = (char)n;
        cArray[n6++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n6, cArray2.length);
        n6 += cArray2.length;
        cArray[n6++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n6, cArray2.length);
        n6 += cArray2.length;
        cArray[n6++] = '\u0000';
        cArray2 = string4.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n6, cArray2.length);
        n6 += cArray2.length;
        cArray[n6++] = '\u0000';
        cArray2 = string5.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n6, cArray2.length);
        n6 += cArray2.length;
        cArray[n6++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n6, cArray2.length);
        n6 += cArray2.length;
        cArray[n6++] = '\u0000';
        this.signals.print(cArray);
    }

    private void sendAudioClipCommand(String string, String string2, int n) {
        int n2 = string.length() + string2.length() + 4;
        char[] cArray = new char[n2 + 8];
        char[] cArray2 = this.getPaddedLength(n2);
        int n3 = 0;
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = (char)n;
        cArray[n3++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        this.signals.print(cArray);
    }

    public void sendAudioClipPlayCommand(String string, String string2) {
        this.sendAudioClipCommand(string, string2, 20);
    }

    public void sendAudioClipLoopCommand(String string, String string2) {
        this.sendAudioClipCommand(string, string2, 21);
    }

    public void sendAudioClipStopCommand(String string, String string2) {
        this.sendAudioClipCommand(string, string2, 22);
    }

    public void sendPutMember(String string, int n, boolean bl) {
        Main.debug("sendPutMember, contextID = " + string + " success = " + bl);
        String string2 = new String(bl ? "1" : "0");
        String string3 = new String("" + n);
        int n2 = string.length() + string2.length() + string3.length() + 5;
        char[] cArray = new char[n2 + 8];
        char[] cArray2 = this.getPaddedLength(n2);
        int n3 = 0;
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = 18;
        cArray[n3++] = '\u0000';
        cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        cArray2 = string3.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        cArray2 = string2.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n3, cArray2.length);
        n3 += cArray2.length;
        cArray[n3++] = '\u0000';
        this.signals.print(cArray);
    }

    private String getArg(byte[] byArray) {
        int n = this.cmd_index;
        while (0 != byArray[this.cmd_index++]) {
        }
        if (this.cmd_index > n + 1) {
            String string = new String(byArray, n, this.cmd_index - n - 1);
            return string;
        }
        return null;
    }

    private char[] getPaddedLength(int n) {
        String string = String.valueOf(n);
        int n2 = 8 - string.length();
        String string2 = new String(" ");
        String string3 = string;
        int n3 = 0;
        while (n3 < n2) {
            string3 = string2.concat(string3);
            ++n3;
        }
        if (string3.length() != 8) {
            throw new IllegalArgumentException("can't create string number of length = 8");
        }
        return string3.toCharArray();
    }

    private int readPaddedLength(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.commands.read(byArray, 0, n);
        String string = new String(byArray);
        return Integer.parseInt(string.trim());
    }
}

