#!/bin/sh
#
# rc.M		This file is executed by init(8) when the system is being
#		initialized for one of the "multi user" run levels (i.e.
#		levels 1 through 6).  It usually does mounting of file
#		systems et al.
#
# Version:	@(#)/etc/rc.d/rc.M	2.02	02/26/93
#
# Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#		Heavily modified by Patrick Volkerding <volkerdi@ftp.cdrom.com>
#
# Adapted for BsV by Jonathan B. Araujo Neto <jones@brfree.com.br>
#
PATH=/sbin:/usr/sbin:/bin:/usr/bin
export RCINITCOLORS="YES"


# Tell the viewers what's going to happen...
echoc "==> rc.M Entering multiuser mode...." blue
sleep 2


# Configure ISA plug'n'pray
if [ -x /etc/rc.d/rc.pnp ] ; then
  	echoc "Configuring ISA Plug and Pray" yellow
	. /etc/rc.d/rc.pnp
fi


# This loads any kernel modules that are needed.  These might be required to
if [ -x /etc/rc.d/rc.modules ]; then
  echoc "Loading modules" yellow
  . /etc/rc.d/rc.modules
fi

# Initialize PCMCIA devices:
if [ -x /etc/rc.d/rc.pcmcia ] ; then
	echoc "Setting up PCMCIA" yellow
	. /etc/rc.d/rc.pcmcia start
fi

# Run serial port setup script:
# (CAREFUL! This can make some systems hang if the rc.serial script isn't
# set up correctly. If this happens, you may have to edit the file from a
# boot disk)
#
if [ -x /etc/rc.d/rc.serial ] ; then 
	echoc "Setting up serial devices" yellow
	. /etc/rc.d/rc.serial
fi



if [ -x /etc/rc.d/rc.inet1 ] ;  then
	echoc "Setting up the NET subsystem...." yellow
	. /etc/rc.d/rc.inet1
fi

if [ -x /etc/rc.d/rc.inet2 ]; then
	echoc "Setting up internal network........" yellow
	. /etc/rc.d/rc.inet2
fi

# Check quotas and then turn quota system on:
if [ -x /etc/rc.d/rc.quota ] ; then
	echoc "Setting up quota" yellow
	. /etc/rc.d/rc.quota
fi

# Check for a cdrom and mount it
if [ -x /etc/rc.d/rc.cdrom ] ; then
	echoc "Setting up CDROM" yellow
	. /etc/rc.d/rc.cdrom
fi



# Load a custom keymap and console font.

if [ -x /etc/rc.d/rc.keymap ] ; then
	echoc "Setting up characters devices: keyboard" yellow
	. /etc/rc.d/rc.keymap
fi
# Start the Cups printer daemon for printing
if [ -x /etc/rc.d/rc.printer ]; then
	echoc "Starting the printer driver..." yellow
	. /etc/rc.d/rc.printer
fi
# Start the local setup procedure.
if [ -x /etc/rc.d/rc.local ] ; then
	echoc "Starting local setup" yellow
	. /etc/rc.d/rc.local
fi

# All done.
