#!/bin/sh
#
# Installer for foomatic-filters-ppds package
#
# (C) 2003 Till Kamppeter, GPL (see COPYING file)
#

# Read command line options

echo 
cat /install/slack-desc

prefix=/usr


  
# Link for CUPS (do only if we have a CUPS daemon, PPD link to
# /usr/share/cups/model not needed on pure CUPS clients)
cups=0

if ( which cupsd > /dev/null 2>&1 ); then
  echo "Setting link for CUPS ..."
  if ( which cups-config > /dev/null 2>&1 ); then
    # CUPS installed from source or "devel" package installed
    ppddir=`cups-config --datadir`/model
  else
    # CUPS installed from distro, no "devel" package installed,
    # distros usually install with prefix "/usr"
    ppddir=/usr/share/cups/model
  fi
  mkdir -p $destdir$ppddir
  rm -f $destdir$ppddir/foomatic-ppds
  ln -s $prefix/share/ppd $destdir$ppddir/foomatic-ppds
  cups=1
fi

# Do we have PPR installed
if ( which ppad > /dev/null 2>&1 ); then
  echo "Setting link for PPR ..."
  if [ -d $destdir/usr/share/ppr/PPDFiles/ ]; then
    rm -f $destdir/usr/share/ppr/PPDFiles/foomatic-ppds
    ln -s  $prefix/share/ppd $destdir/usr/share/ppr/PPDFiles/foomatic-ppds
  elif [ -d $destdir/usr/local/share/ppr/PPDFiles/ ]; then
    rm -f $destdir/usr/local/share/ppr/PPDFiles/foomatic-ppds
    ln -s  $prefix/share/ppd \
 $destdir/usr/local/share/ppr/PPDFiles/foomatic-ppds
  elif [ -d $destdir/opt/ppr/PPDFiles/ ]; then
    rm -f $destdir/opt/ppr/PPDFiles/foomatic-ppds
    ln -s  $prefix/share/ppd $destdir/opt/ppr/PPDFiles/foomatic-ppds
  fi
fi

# Final remarks
echo "Installation finished"
echo ""

if [ $cups == 1 ]; then
    echo "Please restart the CUPS daemon. Note that the CUPS daemon"
    echo "needs some minutes to register all PPD files."
    echo
fi
