.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XFillRect.man,v 1.4 2003/04/28 22:17:54 herrb Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XFillRectangle 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XFillRectangle, XFillRectangles, XFillPolygon, XFillArc, XFillArcs \- fill rectangles, polygons, or arcs
.SH SYNTAX
.HP
int XFillRectangle\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned
int \fIheight\fP\^); 
.HP
int XFillRectangles\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, XRectangle *\fIrectangles\fP\^, int \fInrectangles\fP\^); 
.HP
int XFillPolygon\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, XPoint *\fIpoints\fP\^, int \fInpoints\fP\^, int \fIshape\fP\^,
int \fImode\fP\^);
.HP
int XFillArc\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^, 
int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, int \fIangle1\fP\^, int \fIangle2\fP\^); 
.HP
int XFillArcs\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
XArc *\fIarcs\fP\^, int \fInarcs\fP\^); 
.SH ARGUMENTS
.IP \fIangle1\fP 1i
Specifies the start of the arc relative to the three-o'clock position
from the center, in units of degrees * 64.
.IP \fIangle2\fP 1i
Specifies the path and extent of the arc relative to the start of the
arc, in units of degrees * 64.
.IP \fIarcs\fP 1i
Specifies an array of arcs.
.IP \fId\fP 1i
Specifies the drawable. 
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fImode\fP 1i
Specifies the coordinate mode. 
You can pass
.ZN CoordModeOrigin
or
.ZN CoordModePrevious .
.IP \fInarcs\fP 1i
Specifies the number of arcs in the array.
.IP \fInpoints\fP 1i
Specifies the number of points in the array.
.IP \fInrectangles\fP 1i
Specifies the number of rectangles in the array.
.IP \fIpoints\fP 1i
Specifies an array of points.
.IP \fIrectangles\fP 1i
Specifies an array of rectangles.
.IP \fIshape\fP 1i
Specifies a shape that helps the server to improve performance.
You can pass 
.ZN Complex , 
.ZN Convex , 
or 
.ZN Nonconvex .
.ds Wh , which are the dimensions of the rectangle to be filled
or the major and minor axes of the arc
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height\*(Wh.
.ds Xy , which are relative to the origin of the drawable
and specify the upper-left corner of the rectangle
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
The
.ZN XFillRectangle
and
.ZN XFillRectangles
functions fill the specified rectangle or rectangles
as if a four-point 
.ZN FillPolygon
protocol request were specified for each rectangle:
.LP
.Ds
[x,y] [x+width,y] [x+width,y+height] [x,y+height]
.De
.LP
Each function uses the x and y coordinates,
width and height dimensions, and GC you specify.
.LP
.ZN XFillRectangles
fills the rectangles in the order listed in the array.  
For any given rectangle,
.ZN XFillRectangle
and
.ZN XFillRectangles
do not draw a pixel more than once.  
If rectangles intersect, the intersecting pixels are
drawn multiple times.
.LP
Both functions use these GC components: 
function, plane-mask, fill-style, subwindow-mode, 
clip-x-origin, clip-y-origin, and clip-mask.
They also use these GC mode-dependent components: 
foreground, background, tile, stipple, tile-stipple-x-origin, 
and tile-stipple-y-origin.
.LP
.ZN XFillRectangle
and
.ZN XFillRectangles
can generate
.ZN BadDrawable ,
.ZN BadGC ,
and
.ZN BadMatch 
errors.
.LP
.ZN XFillPolygon 
fills the region closed by the specified path.
The path is closed
automatically if the last point in the list does not coincide with the
first point.
.ZN XFillPolygon
does not draw a pixel of the region more than once.
.ZN CoordModeOrigin
treats all coordinates as relative to the origin,
and
.ZN CoordModePrevious
treats all coordinates after the first as relative to the previous point.
.LP
Depending on the specified shape, the following occurs: 
.IP \(bu 5
If shape is
.ZN Complex , 
the path may self-intersect. 
Note that contiguous coincident points in the path are not treated 
as self-intersection.
.IP \(bu 5
If shape is
.ZN Convex , 
for every pair of points inside the polygon,
the line segment connecting them does not intersect the path.
If known by the client,
specifying 
.ZN Convex 
can improve performance.  
If you specify
.ZN Convex 
for a path that is not convex, 
the graphics results are undefined.
.IP \(bu 5
If shape is
.ZN Nonconvex , 
the path does not self-intersect, but the shape is not
wholly convex. 
If known by the client, 
specifying 
.ZN Nonconvex 
instead of
.ZN Complex 
may improve performance.  
If you specify
.ZN Nonconvex 
for a self-intersecting path, the graphics results are undefined.
.LP
The fill-rule of the GC controls the filling behavior of 
self-intersecting polygons.
.LP
This function uses these GC components: 
function, plane-mask, fill-style, fill-rule, subwindow-mode, clip-x-origin, 
clip-y-origin, and clip-mask.
It also uses these GC mode-dependent components: 
foreground, background, tile, stipple, tile-stipple-x-origin, 
and tile-stipple-y-origin.
.LP
.ZN XFillPolygon
can generate
.ZN BadDrawable ,
.ZN BadGC ,
.ZN BadMatch ,
and
.ZN BadValue 
errors.
.LP
For each arc, 
.ZN XFillArc
or
.ZN XFillArcs
fills the region closed by the infinitely thin path
described by the specified arc and, depending on the 
arc-mode specified in the GC, one or two line segments. 
For 
.ZN ArcChord , 
the single line segment joining the endpoints of the arc is used.  
For 
.ZN ArcPieSlice ,
the two line segments joining the endpoints of the arc with the center
point are used.  
.ZN XFillArcs
fills the arcs in the order listed in the array.  
For any given arc,  
.ZN XFillArc
and
.ZN XFillArcs
do not draw a pixel more than once.  
If regions intersect, 
the intersecting pixels are drawn multiple times.
.LP
Both functions use these GC components: 
function, plane-mask, fill-style, arc-mode, subwindow-mode, clip-x-origin, 
clip-y-origin, and clip-mask.
They also use these GC mode-dependent components: 
foreground, background, tile, stipple, tile-stipple-x-origin, 
and tile-stipple-y-origin.
.LP
.ZN XFillArc
and
.ZN XFillArcs
can generate
.ZN BadDrawable ,
.ZN BadGC ,
and
.ZN BadMatch 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.ZN BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XDrawArc(3X11),
XDrawPoint(3X11),
XDrawRectangle(3X11)
.br
\fI\*(xL\fP
