# The contents of this file are subject to the Netscape Public License
# Version 1.1 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/NPL/
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code was released August, 1999.  The Initial Developer
# of the Original Code is Netscape Communications Corporation.  Portions
# created by Netscape are Copyright (C) 1999 Netscape Communications
# Corporation.  All Rights Reserved.
#
# Contributor(s): John M. Kristian <kristian@netscape.com>
# --------------------------------------------------------------------

use Cwd qw(cwd);
use File::Basename qw(basename dirname);
use File::Spec;

sub _fully_qualify # filename
{
    my ($p) = @_;
    return File::Spec->file_name_is_absolute ($p) ? $p
	 : File::Spec->catfile (cwd, $p);
}

my $pathsep = quotemeta ($MSWin32 ? '\\' : '/');

sub _same_path # p1 p2 ...
{
    my $p1 = shift;
    $p1 = lc $p1 if ($MSWin32);
    $p1 =~ s/$pathsep$//;
    my $p2;
    while (defined ($p2 = shift)) {
	$p2 = lc $p2 if ($MSWin32);
	$p2 =~ s/$pathsep$//;
	return "" unless $p1 eq $p2;
    }
    return 1;
}

sub _subpath
{
    my ($short, $long) = @_;
    my @result;
    while (((length $short) < (length $long))
	   and not _same_path ($short, $long)) {
	unshift @result, basename $long;
	$long = dirname $long;
    }
    return File::Spec->catdir (@result);
}

sub _common_prefix # p1 p2 ...
{
    my $p1 = File::Spec->canonpath (shift);
    my $p2;
    while (defined ($p2 = File::Spec->canonpath (shift))) {
	while (not _same_path ($p1, $p2)) {
	    if (length ($p1) > length ($p2)) {
		$p1 = dirname $p1;
	    } else {
		$p2 = dirname $p2;
	    }
	}
    }
    return $p1;
}

1; # module initialized successfully
