# The contents of this file are subject to the Netscape Public License
# Version 1.1 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/NPL/
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code was released August, 1999.  The Initial Developer
# of the Original Code is Netscape Communications Corporation.  Portions
# created by Netscape are Copyright (C) 1999 Netscape Communications
# Corporation.  All Rights Reserved.
#
# Contributor(s): John M. Kristian <kristian@netscape.com>
# --------------------------------------------------------------------

# This is a Perl script, but don't run it as a shell command; instead,
# run your `perl` program with the name of this script as a parameter.
# See README.txt (in this directory) for further instructions.

use Config;
use ExtUtils::Install;
use File::Basename qw(dirname);
use FileHandle;
BEGIN {
    # chdir to the directory that contains this script:
    my $src = dirname $0;
    chdir $src unless $src eq "";

    eval {require File::Spec;};
    if ($@) { # Install it:
	my $File = "$Config{installprivlib}\\File";
	my $packlist = "$File\\Spec\\.packlist";
	install ({'read'  => $packlist,
		  'write' => $packlist,
		  'File-Spec' => $File}, 1, 0, 0);
    }
}
use File::Spec;

sub _brother
{
    return File::Spec->catfile (File::Spec->curdir(), shift);
}

# Set $Config{prefixexp} correctly:
require (_brother 'util.pm');
require (_brother 'change_files.pm');
my $prefixexp = _common_prefix ($Config{perlpath},
				$Config{installscript},
				$Config{installarchlib});
unless (_same_path ($prefixexp, $Config{prefix}, $Config{prefixexp})) {
    my $Config_pm = File::Spec->catfile ($Config{installarchlib}, "Config.pm");
    print ("prefix=$prefixexp (from $Config{prefix})\n");
    print ("prefixexp=$prefixexp (from $Config{prefixexp})\n");
    chmod 0644, $Config_pm;
    foreach my $key ('prefix', 'prefixexp') {
	_change_files ("^$key='.*", "'\\s*\n", "$key='$prefixexp",
		       $Config_pm);
    }
}

delete $ENV{PERLLIB};
delete $ENV{PERL5LIB};
system ($Config{perlpath}, _brother 'Package2.pl')
     and die $! ? "system: $!" : "Package2.pl: $?";
