#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

static pid_t one;

static void die(int signo){
  (void)signo;
  _exit(0);
}

static void hang(void){
  for(;;) pause();
}

int main(int argc, char *argv[]){
  (void)argc;
  (void)argv;

  one = getpid();
  signal(SIGHUP,die);
  if(fork()) hang();    // parent later killed as readyness signal

  // second one exits, to enable setsid(), and the resulting
  // zombie will be reaped by init after 1st process killed
  if(fork()) _exit(0);

  if(setsid()==-1){
    kill(one,SIGKILL); // hopefully the shell will complain
    _exit(42); // kind of tough to report errors
  }

  kill(one,SIGHUP); // let the shell know we're ready

  hang();

  return 0;
}
