/*
 *  linux/fs/supermount/mediactl.c
 *
 *  Original version:
 *      Copyright (C) 1995, 1997
 *      Stephen Tweedie (sct@dcs.ed.ac.uk)
 *
 *  Rewriten for kernel 2.2, 2.4. (C) 1999, 2000 Alexis Mikhailov
 *                                    (alexis@abc.cap.ru)
 *  Rewritten for kernel 2.4.21 (C) 2003 Andrey Borzenkov
 *                                       (arvidjaar@mail.ru)
 *  Rewritten for kernel 2.5.70 (C) 2003 Andrey Borzenkov
 *                                       (arvidjaar@mail.ru)
 *
 *  $Id: mediactl.c,v 1.5.2.5 2003/07/13 19:15:20 bor Exp $
 */

#define S_DBG_TRACE_CURRENT S_DBG_TRACE_MEDIACTL
#include "supermount.h"

/* 
 * Try to lock the drive door.  This is not guaranteed to work on all
 * hardware, but we try any tricks we know of anyway.  
 */
void
supermount_mediactl(struct super_block *sb, int operation, int opt)
{
	struct block_device *bdev;
	struct super_block *subsb;
	struct block_device_operations *fops = 0;

	if (!subfs_is_mounted(sb))
		return;

	subsb = subfs_sb(sb);
	bdev = subsb->s_bdev;
	if (!bdev->bd_disk)
		return;

	/* FIXME is it enough to use bd_sem here? */
	switch (operation) {
		case SUPERMOUNT_INC_COUNT:
			lock_kernel();
			SUPERMOUNT_BUG_ON(bdev->bd_disk->scount < 0);
			bdev->bd_disk->scount++;
			unlock_kernel();
			return;
		case SUPERMOUNT_DEC_COUNT:
			lock_kernel();
			SUPERMOUNT_BUG_ON(bdev->bd_disk->scount <= 0);
			bdev->bd_disk->scount--;
			unlock_kernel();
			return;
	}

	fops = bdev->bd_disk->fops;
	if (!fops || !fops->mediactl)
		return;
	/*
	 * tray is (un-)locked in open (BKL for bdev), release (BKL for bdev)
	 * and ioctl (BKL). We are in good company.
	 * This must be changed if block devices ever stop using BKL
	 * for open/release. Unfortunately, using just bdev->bd_sem is not
	 * enough due to ioctl.
	 */
	lock_kernel();
	fops->mediactl(bdev, operation, opt);
	unlock_kernel();
}
