/* 
 * linux/fs/supermount/init.c
 *
 *  (C) Copyright 2001-2002 Juan Quintela <quintela@mandrakesoft.com>
 *      Released unde GPL v2.
 *  Rewritten for kernel 2.4.21 (C) 2003 Andrey Borzenkov
 *                                       (arvidjaar@mail.ru)
 *  Rewritten for kernel 2.5.70 (C) 2003 Andrey Borzenkov
 *                                       (arvidjaar@mail.ru)
 *
 *  $Id: init.c,v 1.6.4.4 2003/10/26 16:21:25 bor Exp $
 */

#include "supermount.h"

struct file_system_type supermount_fs_type = {
        .owner          = THIS_MODULE,
        .name           = "supermount",
        .get_sb         = supermount_get_sb,
        .kill_sb        = kill_anon_super,
        .fs_flags       = FS_NO_SUBMNT,
};

static int __init
init_supermount_fs(void)
{
	int rc = register_filesystem(&supermount_fs_type);
	
	if (!rc) {
		printk(KERN_INFO "Supermount version %s for kernel 2.6\n", SUPERMOUNT_VERSION);
		supermount_proc_register();
	}

	return rc;
}

static void __exit
exit_supermount_fs(void)
{
	supermount_proc_unregister();
	unregister_filesystem(&supermount_fs_type);
}

MODULE_AUTHOR("Stephen Tweedie, Alexis Mikhailov, Juan Quintela, Andrey Borzenkov and others");
MODULE_DESCRIPTION("Transparent removable media support");
MODULE_LICENSE("GPL");
module_init(init_supermount_fs);
module_exit(exit_supermount_fs);
