/*
 * AT&T Bell Laboratories
 * directory stream access definitions
 *
 *	#include <sys/types.h>
 *	#include <dirent.h>
 *
 * : : generated by mkhdr and  genhdr : :
 */

#ifndef __DIRENT_H__

#include <lcldirent.h>

#ifndef __DIRENT_H__
#define __DIRENT_H__
#endif

#define _dir_sys	1	/* #include <sys/dir.h> ok */

#ifndef d_fileno
#define d_fileno	d_ino
#endif

#ifndef _lcl_dirent

#ifdef _dir_sys

#include <sys/dir.h>

#else

#undef	_dir_rewinddir

#define DIRSIZ	14

struct direct
{
	short	d_ino;
	char	d_name[DIRSIZ];
};

#endif

#ifdef _dir_rewinddir

/*
 * variable length directory entry format
 */

#define _dir_variable

#ifndef dirent
#define dirent	direct
#endif

#else

/*
 * fixed length directory entry format
 */

#define _dir_fixed

#ifndef DIRSIZ
#define DIRSIZ		14		/* maximum entry link length	*/
#endif

#ifndef MAXNAMLEN
#define	MAXNAMLEN	DIRSIZ		/* maximum filename length	*/
#endif

#ifdef _dir_getdents

struct dirent				/* data from local getdents()	*/
{
	long		d_ino;		/* file number of entry		*/
	long		d_off;		/* entry seek offset		*/
	unsigned short	d_reclen;	/* length of this record	*/
	char		d_name[1];	/* link name			*/
};

#else

#ifndef _dir_namlen
#define _dir_namlen	1
#endif

struct dirent				/* data from readdir()		*/
{
	long		d_fileno;	/* file number of entry		*/
	unsigned short	d_reclen;	/* length of this record	*/
	unsigned short	d_namlen;	/* strlen(d_name)		*/
	char		d_name[1];	/* link name			*/
};

#endif

typedef struct
{
	int		dd_fd;		/* file descriptor		*/
	int		dd_loc;		/* offset in block		*/
	int		dd_size;	/* amount of valid data		*/
	char*		dd_buf;		/* directory block		*/
} DIR;					/* stream data from opendir()	*/

extern DIR*		opendir();
extern struct dirent*	readdir();
extern long		telldir();
extern void		seekdir();
extern void		closedir();

#if !_dir_local
#define rewinddir(dirp)	seekdir(dirp,0L)
#endif

#endif

#endif

#if _dir_namlen
#define DIRNAMLEN(d)	((d)->d_namlen)
#else
#define DIRNAMLEN(d)	strlen((d)->d_name)
#endif

#endif
