;[]-----------------------------------------------------------------[]
;|      H_LRSH.ASM -- long shift right                               |
;|                                                                   |
;|      C/C++ Run Time Library        Version 4.0                    |
;|                                                                   |
;|      Copyright (c) 1987, 1991 by Borland International Inc.       |
;|      All Rights Reserved.                                         |
;|      Modified by Szigeti Szabolcs				     |
;[]-----------------------------------------------------------------[]


_TEXT	segment	public byte 'CODE'
	assume	cs:_TEXT
	public	LXRSH@
        public  N_LXRSH@

N_LXRSH@:
LXRSH@:
	cmp	cl,16
	jae	lsh@small
	mov	bx,dx			; save the high bits
	shr	ax,cl			; now shift each half
	sar	dx,cl
;
;			We now have a hole in AX where the lower bits of
;			DX should have been shifted.  So we must take our
;			copy of DX and do a reverse shift to get the proper
;			bits to be or'ed into AX.
;
	neg	cl
	add	cl,16
	shl	bx,cl
	or	ax,bx
        ret
lsh@small:
	sub	cl,16			; for shifts more than 15, do this
					; short sequence.
        xchg    ax,dx                   ;
	cwd				; We have now done a shift by 16.
	sar	ax,cl			; Now shift the remainder.
        ret
_TEXT	ends
	end
