/*
 *	subr.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\buf.h"
#include "h\inode.h"
#include "h\systm.h"

/*
 * bmap convert from logical file block to device physical block
 *	allocate block if needed
 */

blk_t bmap(ip,bn)
struct inode *ip;
blk_t bn;
	{
	register struct buf *bp,*nbp;
	register int *bap;
	int d,i;
	blk_t nb;

	d=ip->i_dev;

	if (bn & ~077777)
		{
		u->u_error=EFBIG;
		return(0);
		}
	if ((ip->i_mode&ILARG)==0)		/* not indirect block	*/
		{
		if ((bn & ~7)!=0)          	/* but gonna be		*/
			{
			if ((bp=alloc(d))==NULL)/* alloc indirect blk	*/
				return (NULL);
			bap = (int*)bp->b_addr;
			for (i=0;i<8;i++)	/* cp blk nos from inode*/
				{
				*bap++=ip->i_addr[i];
				ip->i_addr[i]=0;
				}
			ip->i_addr[0]=bp->b_blkno;/* inode storse ind blk*/
			bdwrite(bp);
			ip->i_mode |=ILARG;	/* it is large now	*/
			goto LARGE;
			}
		nb=ip->i_addr[bn];
		if(nb==0 &&(bp=alloc(d))!=NULL)/* alloc new blk 	*/
			{
			bdwrite(bp);
			nb=bp->b_blkno;
			ip->i_addr[bn]=nb;	/* blk no still in inode*/
			ip->i_flag|=IUPD;
			}
		rablock = 0;			/* update readahead	*/
		if (bn<7)
			rablock=ip->i_addr[bn+1];
		return(nb);
		}
LARGE:						/* algorithm for large 	*/
	i=bn>>8;				/* indir blk number	*/
	if(bn&0174000)
		i=7;
	if((nb=ip->i_addr[i])==0)		/* if this blk isn't	*/
		{				/* alloc'd yet, then	*/
		ip->i_flag|=IUPD;		/* allocate it now	*/
		if ((bp=alloc(d))==NULL)
			return(NULL);
		ip->i_addr[i]=bp->b_blkno;
		}
	else
		bp=bread(d,nb);
	bap=(int*)bp->b_addr;

	if (i==7)              			/* doubly indir		*/
		{
		i=((bn>>8)&0377)-7;
		if ((nb=bap[i])==0)
			{
			if ((nbp=alloc(d))==NULL)
				{
				brelse(bp);
				return(NULL);
				}
			bap[i]=nbp->b_blkno;
			bdwrite(bp);
			}
		else
			{
			brelse(bp);
			nbp=bread(d,nb);
			}
		bp=nbp;
		bap=(int*)bp->b_addr;
		}

	i = bn &0377;
	if((nb=bap[i])==0 && (nbp=alloc(d))!=NULL)
		{
		nb=nbp->b_blkno;
		bap[i]=nb;
		bdwrite(nbp);
		bdwrite(bp);
		}
	else
		brelse(bp);
	rablock=0;
	if (i<255)
		rablock=bap[i+1];
	return(nb);
	}


/*
 * get one char from user memory from address at u_base
 * 	update u_base,u_count,u_offset
 */

int cpass(void)
	{
	register int c;
	register struct user *cu_us;

	cu_us=u;
	if (cu_us->u_count==0)
		{
		return(-1);
		}

	if (cu_us->u_segflg)
		c=*cu_us->u_base;
	else
		if ((c=fubyte((word)cu_us->u_base))<0)
			{
			cu_us->u_error=EFAULT;
			return (-1);
			}
	cu_us->u_count--;
	cu_us->u_offset++;
	cu_us->u_base++;
	return (c&0xff);
	}

/*
 *	opposite of cpass, put char to user mem
 */

int passc(c)
char c;
	{
	register struct user *cu_us;

	cu_us=u;
	if (cu_us->u_segflg)
		*cu_us->u_base=c;
	else
		if (subyte((word)cu_us->u_base,c)<0)
			{
			cu_us->u_error=EFAULT;
			return(-1);
			}
	cu_us->u_count--;
	cu_us->u_offset++;
	cu_us->u_base++;
	return(cu_us->u_count==0 ? -1:0);
	}
/*
 * nonexistent dev table entry
 */
void nodev(void)
	{
	u->u_error = ENODEV;
	}
/*
 * unsignificant dev table entry
 */
void nulldev(void)
	{
	}

#ifdef ONLY_C
/*
 * block move in kernel memory
 */
void bcopy(from,to,count)
register void *from,*to;
word count
	{
	while (count--)
		*(word*)to++=*(word*)from++;
	}
#endif /* ONLY_C */

/*
 * block move in kernel memory
 * should be in i286.asm
 */

void bcopy(from, to, count)
register void *from, *to;
word count;
	{

	asm	{	push si;
			push di;
			push es;
			mov ax,ds;
			mov es,ax;
			cld;
			mov cx,count;
			mov si,from;
			mov di,to;
		rep	movsw;
			pop es;
			pop di;
			pop si;
		}

	}
