COMMENT	@
	## STARTUP.ASM ##
	(c) Szigeti Szabolcs	1992 jan 28.
	stratup.asm - ez a file kapja meg a vezerlest a UNIX indulasakor.

		(1) - Inicializalja a globalis deszkriptor tabla kernel
		      indulasahoz szukseges reszet.
		(2) - Inicializalja az interrupt deszkriptor tablat.
		(3) - Inicializalja a kernel indulasahoz szukseges hardwaret
		(4) - Beallitja a real modba valo visszatereshez szukseges
		      ertekeket
		(5) - Atter protected modba, atadja a vezerlest a kernelnek



	Jelenlegi verzio teszt verzio, a kesobbiekben 2,5 nem lesz
	szukseges mivel az interrupt deszkriptor fixen be lesz forditva a
	kernel kodjaba, valamint nem lesz szukseges visszaterni DOS-ba.
									@

INCLUDE h\common.inc
INCLUDE h\hardware.inc
;************************************************

EXTRN	GDT_SIZ:WORD,IDT_SIZ:WORD

;************************************************
STACK_86	SEGMENT	PARA	STACK "STACK"

		DW 	100H	DUP(?)

STACK_86	ENDS
;************************************************

DATA_86	SEGMENT	PARA	PUBLIC	"DATA_86"

GDT_DES		GDT_DESC	<GDT_SIZ,,>  ;GDT deszkriptora
IDT_DES		GDT_DESC	<IDT_SIZ,,>  ;IDT deszkriptora
IT1_MASK	DB	?                    ;Az IT vezelo maszkokat
IT2_MASK	DB	?		     ;ide mentjuk

DATA_86	        ENDS
                         
;************************************************


CODE_86	SEGMENT	PARA	PUBLIC	"CODE_86"

ASSUME	SS:STACK_86,CS:CODE_86,DS:DATA_86,ES:NOTHING
EXTRN	FILL_DESCRIPT:NEAR
START		PROC	FAR
		MOV	AX,DATA_86
		MOV	DS,AX
		MOV	ES,AX	;A fill_... makronak ES kell.
		FILL_GLOB GDT_DES,K_DATA,GLOB_DESC_TAB	;GDT kitoltese
		FILL_GLOB IDT_DES,K_DATA,INT_DESC_TAB	;IDT kitoltese
		MOV	AX,K_DATA
		MOV	ES,AX
		FILL_DESC D_K_CODE, K_CODE, 0	;Kernel code deszkriptora
		FILL_DESC D_K_STACK,K_DATA, 0
		FILL_DESC D_K_DATA, K_DATA, 0
;		fILL_DESC D_GDT,    K_DATA, GLOB_DESC_TAB
		FILL_DESC d_sw_code,K_CODE, 0
		FILL_DESC DUMMY_TSK,K_DATA, DUMMY_TSS
		CALL	FILL_DESCRIPT
		mov	ax,k_data
		mov	es,ax
		mov	es:_kdata,ax
		mov	ax,k_code
		mov	es:_kcode,ax
		mov	ax,_BSS
		mov	es:_frem,ax
		mov	ax,offset glob_desc_tab
		mov	es:_gdt_beg,ax
		mov	ax,offset int_desc_tab
		mov	es:_idt_beg,ax
		mov	ax,offset hint0_beg
		mov	es:_hint0_tss,ax
		CALL	INIT_HV
		XOR	AX,AX
		MOV	ES,AX
		MOV	WORD PTR ES:[0469h],CODE_86
		MOV	WORD PTR ES:[0467h],OFFSET REREAL
		MOV	AL,0fH
		OUT	70H,AL	;CMOS cim
		NOP
		NOP
		NOP
		NOP
		MOV	AL,05H			;visszateresi kod
		OUT	71H,AL                  ; jmp[0459h]
		MOV	CS:AX_SAVE,AX
		MOV	CS:BX_SAVE,BX
		MOV	CS:CX_SAVE,CX
		MOV	CS:DX_SAVE,DX
		MOV	CS:SI_SAVE,SI
		MOV	CS:DI_SAVE,DI
		MOV	CS:BP_SAVE,BP
		MOV	CS:SP_SAVE,SP
		MOV	CS:ES_SAVE,ES
		MOV	CS:DS_SAVE,DS
		MOV	CS:SS_SAVE,SS
		SAHF	
		MOV	CS:FL_SAVE,AX
		CLI
	 
		MOV	BX,OFFSET IDT_DES
		LIDT	[BX]
		MOV	BX,OFFSET GDT_DES
		LGDT	[BX]
		
		SMSW	AX
		OR	AX,1
		LMSW	AX		;Protected mode
		FJM	018h,K_START
		
REREAL:		MOV	AX,CS:FL_SAVE
		LAHF
		MOV	SS,CS:SS_SAVE
		MOV	DS,CS:DS_SAVE
		MOV	ES,CS:ES_SAVE
		MOV	SP,CS:SP_SAVE
		MOV	BP,CS:BP_SAVE
		MOV	DI,CS:DI_SAVE
		MOV	SI,CS:SI_SAVE
		MOV	DX,CS:CX_SAVE
		MOV	CX,CS:CX_SAVE
		MOV	BX,CS:BX_SAVE
		MOV	AX,CS:AX_SAVE
		CALL	RESET_HV
		STI
		mov	ax,00h		;Reset mouse
		int	33h		;mouse fns.
		MOV	AX,4C00H	;EXIT TO DOS
		INT	21H	
START		ENDP
;************************************************
;***		HARDWARE INICIALIZALAS	     ****
;*** IT VEZERLOK ES TIMEREK FELPROGRAMOZASA  ****
;************************************************
INIT_HV		PROC	NEAR

		IN	AL,IO_IT_MAS2	;MASZKOK MENTESE
		MOV	IT1_MASK,AL
		IN	AL,IO_IT_SLAV2
		MOV	IT2_MASK,AL
		
		MOV	AL,ICW1_MAS	;ICW1 -EK KULDESE
		OUT	IO_IT_MAS1,AL
		MOV	AL,ICW1_SLAV
		OUT	IO_IT_SLAV1,AL
		
		MOV	AL,ICW2_MAS	;ICW2 -OK KULDESE
		OUT	IO_IT_MAS2,AL
		MOV	AL,ICW2_SLAV
		OUT	IO_IT_SLAV2,AL
		
		MOV	AL,ICW3_MAS	;ICW3 -AK KULDESE
		OUT	IO_IT_MAS2,AL
		MOV	AL,ICW3_SLAV
		OUT	IO_IT_SLAV2,AL		

		MOV	AL,ICW4_MAS	;ICW4 -EK KULDESE
		OUT	IO_IT_MAS2,AL
		MOV	AL,ICW4_SLAV
		OUT	IO_IT_SLAV2,AL
		
		MOV	AL,PROT_M_MAS	;UJ MASZKOK BEALLITASA
		OUT	IO_IT_MAS2,AL
		MOV	AL,PROT_M_SLAV
		OUT	IO_IT_SLAV2,AL
		RET
INIT_HV		ENDP
;************************************************
;***		HARDWARE VISSZAALLITASA	      ***
;************************************************
RESET_HV	PROC	NEAR
		MOV	AL,IT1_MASK
		OUT	IO_IT_MAS2,AL
		RET
RESET_HV	ENDP


; A regisztereket a code szegmensbe kell menteni mivel
; visszatereskor csak cs (es ip) tartalmaz ismert erteket

AX_SAVE		DW	?
BX_SAVE		DW	?
CX_SAVE		DW	?
DX_SAVE		DW	?
SI_SAVE		DW	?
DI_SAVE		DW	?
BP_SAVE		DW	?
SP_SAVE		DW	?
ES_SAVE		DW	?
DS_SAVE		DW	?
SS_SAVE		DW	?
FL_SAVE		DW	?

CODE_86		ENDS

;************************************************
;*						*
;* A K_CODE szegmens tartalmazza a kernel	*
;* teljes kodjat				*
;*						*
;************************************************

SEGMENT K_CODE	PARA	PUBLIC	'K_CODE'
ASSUME	CS:K_CODE,DS:K_DATA
EXTRN	_startk:NEAR,_reboot:NEAR
K_START:        cli
		MOV AX,028H			;Kernel data
		MOV DS,AX
		mov es,ax
		MOV AX,020H			;Kernel stack
		MOV SS,AX
		MOV AX,OFFSET ST_KERN_B		;Stack lefele no!
		MOV SP,AX
	      	MOV AX,038H             	;Dummy
		LTR AX
		cli
		CALL _startk			;Start KERNEL!
HINT0: 		CALL _reboot			;Ide nem juthat el.
		hlt
PUBLIC HINT0
K_CODE		ENDS

;************************************************
SEGMENT K_DATA	PARA	PUBLIC	'K_DATA'


EXTRN	GLOB_DESC_TAB:NEAR,INT_DESC_TAB:NEAR
EXTRN	d_sw_code:NEAR,D_K_CODE:NEAR,D_K_STACK:NEAR
EXTRN	D_K_DATA:NEAR,D_VIDEO:NEAR,DUMMY_TSS:NEAR
EXTRN	DUMMY_TSK:NEAR,_kcode:word,_kdata:word
EXTRN	_idt_beg:word,_gdt_beg:word,syscal_tss:near
EXTRN	hint0_beg:near,_hint0_tss:word,_systss:word
EXTRN	ST_KERN_B:NEAR
_frem	dw	?
public	_frem
K_DATA		ENDS

;************************************************

segment	_BSS	para	public	'BSS'
	db	1024*63	dup (?)
_BSS		ends
;************************************************
		END	START
