/*
 *	pipe.c
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\file.h"
#include "h\systm.h"


#define PIPSIZ 4096	/* size of a pipe 'block', don't define bigger	*/
			/* than 4096, 'cause it will be a LARGE file	*/
/*
 * create a pipe
 */
void pipe(f)
int *f;
	{
	struct inode *ip;
	register struct file *rf,*wf;
	int r;
	ip=ialloc(rootdev);		/* get an inode on rootdev	*/
	if (ip==NULL)			/* pipe i/o will go thru this	*/
		return ;
	rf=falloc();			/* reader's side		*/
	if(rf==NULL)
		{
		iput(ip);
		return ;
		}
	r=u->u_rv;
	wf=falloc();			/* writer's side		*/
	if(wf==NULL)
		{
		rf->f_count=0;
		u->u_ofile[r]=NULL;
		iput(ip);
		return ;
		}
	suword ((word)f++,r);
	suword ((word)f,u->u_rv);
	wf->f_flag = FWRITE|FPIPE;
	wf->f_inode = ip;
	rf->f_flag = FREAD|FPIPE;
	rf->f_inode = ip;
	ip->i_count = 2;
	ip->i_flag = IACC|IUPD;
	ip->i_mode = IALLOC;
	}

/*
 * read from a pipe
 */
void readp(rp)
register struct file *rp;
	{
	register struct inode *ip;

	ip=rp->f_inode;

LOOP:
	plock(ip);

	if((rp->f_offset&0xffff)==ip->i_size1)
		{
		if(rp->f_offset != 0)
			{
			rp->f_offset=0;
			ip->i_size1=0;
			if(ip->i_mode&IWRITE)
				{
				ip->i_mode &=~IWRITE;
				wakeup((int)ip+1);
				}
			}
		prele(ip);
		if(ip->i_count<2)	/* writer closed	*/
			return;
		ip->i_mode |= IREAD;
		sleep((int)ip+2,PPIPE);
		goto LOOP;
		}
	u->u_offset=(offs_t)rp->f_offset;
	readi(ip);
	rp->f_offset=u->u_offset;
	prele(ip);

	}

/*
 * write to a pipe
 */
void writep(rp)
register struct file *rp;
	{
	register struct inode *ip;
	int c;

	ip=rp->f_inode;
	c=u->u_count;

LOOP:
	plock(ip);
	if (c==0)
		{
		prele(ip);
		u->u_count =0;
		return;
		}

	if(ip->i_count<2)		/* write to a broken pipe	*/
		{
		prele(ip);
		u->u_error=EPIPE;
		psignal(cup,SIGPIPE);
		return;
		}
	if(ip->i_size1 == PIPSIZ)
		{
		ip->i_mode |=IWRITE;
		prele(ip);
		sleep((int)ip+1,PPIPE);
		goto LOOP;
		}
	u->u_offset=(dword)ip->i_size1;
	u->u_count=min(c,PIPSIZ-(int)(u->u_offset&0xffff));
	c-=u->u_count;
	writei(ip);
	prele(ip);
	if(ip->i_mode&IREAD)
		{
		ip->i_mode&=~IREAD;
		wakeup((int)ip+2);
		}
	goto LOOP;
	}
/*
 * lock inode
 */
void plock(rp)
register struct inode *rp;
	{
	while(rp->i_flag&ILOCK)
		{
		rp->i_flag|=IWANT;
		sleep((int)rp,PPIPE);
		}
	rp->i_flag|=ILOCK;
	}

/*
 * release lock on inode, wakeup if inode wanted
 */

void prele(rp)
register struct inode *rp;
	{
	rp->i_flag &= ~ILOCK;
	if (rp->i_flag&IWANT)
		{
		rp->i_flag&= ~IWANT;
		wakeup((int)rp);
		}
	}
