/*
 *	nami.c
 *	translate a pathname to inode
 */
#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\buf.h"
#include "h\systm.h"

/*
 * namei - translate a pathname to an inode
 *
 * func= uchar or schar : get pathname from user or kernel mem
 *
 * flag= 0 if looking for an existing name
 *	 1 if wanting to create a name
 *	 2 if wanting to delete a name
 */

struct inode *namei(func,flag)
int (*func)(void);
int flag;
	{
	register struct inode *dp;
	register char *cp;
	int c;
	word eo;
	struct buf *bp;

	dp = u->u_cdir;
	if ((c=(*func)())=='/')	/* if name begins with / => start	*/
		{		/* from root, otherwise from cwd	*/
		dp=rootdir;
		}
	iget(dp->i_dev,dp->i_number);
	while(c=='/')
		c=(*func)();

	if(c=='\0' && flag !=0)
		{
		u->u_error=ENOENT;
		goto OUT;
		}
CLOOP:				/* loop until error, or found	*/
	if(u->u_error)
		goto OUT;

	if (c=='\0')
		return(dp);


	if((dp->i_mode&IFMT)!=IFDIR)
		{
		u->u_error=ENOTDIR;
		printf ("notdir\n");
		goto OUT;
		}
	if (access(dp,IEXEC))
		goto OUT;

	cp = &u->u_dbuf[0];

	while (c!='/' && c!='\0' && u->u_error==0)
		{
		if(cp<&u->u_dbuf[DIRSIZ])
			*cp++=c;
		c=(*func)();	/* get dirname to buffer	*/
		}
	while (cp<&u->u_dbuf[DIRSIZ])
		*cp++='\0';
	while (c=='/')
		c=(*func)();
	if (u->u_error)
		goto OUT;

	u->u_offset =0;
	u->u_segflg=1;
	eo=0;
	u->u_count=//(word)(I_SIZE(dp)/(DIRSIZ+2));
	(((dword)dp->i_size0<<16)+dp->i_size1)/(DIRSIZ+2);
	bp=NULL;

ELOOP:
	if(u->u_count==0)
		{
		if (bp!=NULL)
			brelse(bp);
		if(flag==1&&c=='\0')
			{
			if(access(dp,IWRITE))
				goto OUT;
			u->u_pdir=dp;
			if (eo)
				u->u_offset=eo-DIRSIZ-2;
			else
				dp->i_flag|=IUPD;
			return(NULL);
			}

		u->u_error=ENOENT;
		goto OUT;
		}
	if ((u->u_offset&0777)==0)
		{
		if (bp!=NULL)
			brelse(bp);
		bp=bread(dp->i_dev,bmap(dp,(blk_t)(u->u_offset/512)));
		}

	bcopy (bp->b_addr+(word)(u->u_offset&0777),&u->u_dent,(DIRSIZ+2)/2);
	u->u_offset+=DIRSIZ+2;
	u->u_count--;
	if (u->u_dent.u_ino==0)
		{
		if(eo==0)
			eo=(word)u->u_offset;
		goto ELOOP;
		}
	for(cp=u->u_dbuf;cp<&u->u_dbuf[DIRSIZ];cp++)
		if(*cp!=cp[u->u_dent.u_name-u->u_dbuf])
			goto ELOOP;

	if (bp!=NULL)
		brelse(bp);
	if(flag==2 && c=='\0')
		{
		if(access(dp,IWRITE))
			goto OUT;
		return(dp);
		}
	bp=(struct buf*)dp->i_dev;
	iput(dp);
	dp=iget((dev_t)bp,u->u_dent.u_ino);
printf ("OLD inode:%x %X\n",u->u_dent.u_ino,dp);
printf ("NEW mode:%x,%u,%u\n",dp->i_mode,dp->i_number,dp->i_dev);

	if(dp==NULL)
		return(NULL);
	goto CLOOP;

OUT:
	iput(dp);
	return(NULL);
	}

/*
 * get one char from kernel mem
 */
schar(void)
	{
	return(*(u->u_dirp++)&0377);
	}
/*
 * get one char from user mem
 */
uchar(void)
	{
	register int c;

	c=fubyte((word)u->u_dirp++);
	if (c==-1)
		{
		u->u_error=EFAULT;
		}
	return(c);
	}
