/*
 * putinfo.c
 * This file is generated by MKinfo.awk.
 * Do not make any changes directly to this file
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define	bool	char
#define	TRUE	1
#define	FALSE	0

#define	MAXINDEX(array) (sizeof(array)/sizeof(array[0]))

/*
 * bools and boolcaps;
 * lookup translate table for boolean fields.
 */

struct bools {
	char	*capname;	/* termcap name */
	char	*infoname;	/* terminfo name */
};

struct bools	boolcaps[] = {
		{ "bw", "bw" },
		{ "am", "am" },
		{ "xb", "xsb" },
		{ "xs", "xhp" },
		{ "xn", "xenl" },
		{ "eo", "eo" },
		{ "gn", "gn" },
		{ "hc", "hc" },
		{ "km", "km" },
		{ "hs", "hs" },
		{ "in", "in" },
		{ "da", "da" },
		{ "db", "db" },
		{ "mi", "mir" },
		{ "ms", "msgr" },
		{ "os", "os" },
		{ "es", "eslok" },
		{ "xt", "xt" },
		{ "hz", "hz" },
		{ "ul", "ul" },
		{ "xo", "xon" },
		{ "nx", "nxon" },
		{ "5i", "mc5i" },
		{ "HC", "chts" },
		{ "NR", "nrrmc" },
		{ "NP", "npc" },
		{ "ND", "ndscr" },
		{ "cc", "ccc" },
		{ "be", "bce" },
		{ "hl", "hls" },
		{ "YA", "xhpa" },
		{ "YB", "crxm" },
		{ "YC", "daisy" },
		{ "YD", "xvpa" },
		{ "YE", "sam" },
		{ "YF", "cpix" },
		{ "YG", "lpix" },
};

#define	MAXBOOLS	MAXINDEX(boolcaps)

/*
 * nums and numcaps;
 * lookuptranslate table for numeric capabilities.
 */
struct nums {
	char	*capname;	/* termcap name */
	char	*infoname;	/* terminfo name */
};

struct nums	numcaps[] = {
		{ "co", "cols" },
		{ "it", "it" },
		{ "li", "lines" },
		{ "lm", "lm" },
		{ "sg", "xmc" },
		{ "pb", "pb" },
		{ "vt", "vt" },
		{ "ws", "wsl" },
		{ "Nl", "nlab" },
		{ "lh", "lh" },
		{ "lw", "lw" },
		{ "ma", "ma" },
		{ "MW", "wnum" },
		{ "Co", "colors" },
		{ "pa", "pairs" },
		{ "NC", "ncv" },
		{ "Ya", "bufsz" },
		{ "Yb", "spinv" },
		{ "Yc", "spinh" },
		{ "Yd", "maddr" },
		{ "Ye", "mjump" },
		{ "Yf", "mcs" },
		{ "Yg", "mls" },
		{ "Yh", "npins" },
		{ "Yi", "orc" },
		{ "Yj", "orl" },
		{ "Yk", "orhi" },
		{ "Yl", "orvi" },
		{ "Ym", "cps" },
		{ "Yn", "widcs" },
};

#define	MAXNUMS	MAXINDEX(numcaps)

/*
 * sts and strcaps;
 * lookuptranslate table for string capabilities.
 */
struct strs {
	char	*capname;	/* termcap name */
	char	*infoname;	/* terminfo name */
	char	*dflt;		/* default value */
};

struct strs	strcaps[] = {
		{ "bt", "cbt", ((char *)0) },
		{ "bl", "bel", "^G" },
		{ "cr", "cr", "\r" },
		{ "cs", "csr", ((char *)0) },
		{ "ct", "tbc", ((char *)0) },
		{ "cl", "clear", ((char *)0) },
		{ "ce", "el", ((char *)0) },
		{ "cd", "ed", ((char *)0) },
		{ "ch", "hpa", ((char *)0) },
		{ "CC", "cmdch", ((char *)0) },
		{ "cm", "cup", ((char *)0) },
		{ "do", "cud1", "\n" },
		{ "ho", "home", ((char *)0) },
		{ "vi", "civis", ((char *)0) },
		{ "le", "cub1", "\b" },
		{ "CM", "mrcup", ((char *)0) },
		{ "ve", "cnorm", ((char *)0) },
		{ "nd", "cuf1", ((char *)0) },
		{ "ll", "ll", ((char *)0) },
		{ "up", "cuu1", ((char *)0) },
		{ "vs", "cvvis", ((char *)0) },
		{ "dc", "dch1", ((char *)0) },
		{ "dl", "dl1", ((char *)0) },
		{ "ds", "dsl", ((char *)0) },
		{ "hd", "hd", ((char *)0) },
		{ "as", "smacs", ((char *)0) },
		{ "mb", "blink", ((char *)0) },
		{ "md", "bold", ((char *)0) },
		{ "ti", "smcup", ((char *)0) },
		{ "dm", "smdc", ((char *)0) },
		{ "mh", "dim", ((char *)0) },
		{ "im", "smir", ((char *)0) },
		{ "mk", "invis", ((char *)0) },
		{ "mp", "prot", ((char *)0) },
		{ "mr", "rev", ((char *)0) },
		{ "so", "smso", ((char *)0) },
		{ "us", "smul", ((char *)0) },
		{ "ec", "ech", ((char *)0) },
		{ "ae", "rmacs", ((char *)0) },
		{ "me", "sgr0", ((char *)0) },
		{ "te", "rmcup", ((char *)0) },
		{ "ed", "rmdc", ((char *)0) },
		{ "ei", "rmir", ((char *)0) },
		{ "se", "rmso", ((char *)0) },
		{ "ue", "rmul", ((char *)0) },
		{ "vb", "flash", ((char *)0) },
		{ "ff", "ff", ((char *)0) },
		{ "fs", "fsl", ((char *)0) },
		{ "i1", "is1", ((char *)0) },
		{ "is", "is2", ((char *)0) },
		{ "i3", "is3", ((char *)0) },
		{ "if", "if", ((char *)0) },
		{ "ic", "ich1", ((char *)0) },
		{ "il", "il1", ((char *)0) },
		{ "ip", "ip", ((char *)0) },
		{ "kb", "kbs", ((char *)0) },
		{ "ka", "ktbc", ((char *)0) },
		{ "kC", "kclr", ((char *)0) },
		{ "kt", "kctab", ((char *)0) },
		{ "kD", "kdch1", ((char *)0) },
		{ "kL", "kdl1", ((char *)0) },
		{ "kd", "kcud1", ((char *)0) },
		{ "kM", "krmir", ((char *)0) },
		{ "kE", "kel", ((char *)0) },
		{ "kS", "ked", ((char *)0) },
		{ "k0", "kf0", ((char *)0) },
		{ "k1", "kf1", ((char *)0) },
		{ "k;", "kf10", ((char *)0) },
		{ "k2", "kf2", ((char *)0) },
		{ "k3", "kf3", ((char *)0) },
		{ "k4", "kf4", ((char *)0) },
		{ "k5", "kf5", ((char *)0) },
		{ "k6", "kf6", ((char *)0) },
		{ "k7", "kf7", ((char *)0) },
		{ "k8", "kf8", ((char *)0) },
		{ "k9", "kf9", ((char *)0) },
		{ "kh", "khome", ((char *)0) },
		{ "kI", "kich1", ((char *)0) },
		{ "kA", "kil1", ((char *)0) },
		{ "kl", "kcub1", ((char *)0) },
		{ "kH", "kll", ((char *)0) },
		{ "kN", "knp", ((char *)0) },
		{ "kP", "kpp", ((char *)0) },
		{ "kr", "kcuf1", ((char *)0) },
		{ "kF", "kind", ((char *)0) },
		{ "kR", "kri", ((char *)0) },
		{ "kT", "khts", ((char *)0) },
		{ "ku", "kcuu1", ((char *)0) },
		{ "ke", "rmkx", ((char *)0) },
		{ "ks", "smkx", ((char *)0) },
		{ "l0", "lf0", ((char *)0) },
		{ "l1", "lf1", ((char *)0) },
		{ "la", "lf10", ((char *)0) },
		{ "l2", "lf2", ((char *)0) },
		{ "l3", "lf3", ((char *)0) },
		{ "l4", "lf4", ((char *)0) },
		{ "l5", "lf5", ((char *)0) },
		{ "l6", "lf6", ((char *)0) },
		{ "l7", "lf7", ((char *)0) },
		{ "l8", "lf8", ((char *)0) },
		{ "l9", "lf9", ((char *)0) },
		{ "mo", "rmm", ((char *)0) },
		{ "mm", "smm", ((char *)0) },
		{ "nw", "nel", ((char *)0) },
		{ "pc", "pad", ((char *)0) },
		{ "DC", "dch", ((char *)0) },
		{ "DL", "dl", ((char *)0) },
		{ "DO", "cud", ((char *)0) },
		{ "IC", "ich", ((char *)0) },
		{ "SF", "indn", ((char *)0) },
		{ "AL", "il", ((char *)0) },
		{ "LE", "cub", ((char *)0) },
		{ "RI", "cuf", ((char *)0) },
		{ "SR", "rin", ((char *)0) },
		{ "UP", "cuu", ((char *)0) },
		{ "pk", "pfkey", ((char *)0) },
		{ "pl", "pfloc", ((char *)0) },
		{ "px", "pfx", ((char *)0) },
		{ "ps", "mc0", ((char *)0) },
		{ "pf", "mc4", ((char *)0) },
		{ "po", "mc5", ((char *)0) },
		{ "rp", "rep", ((char *)0) },
		{ "r1", "rs1", ((char *)0) },
		{ "r2", "rs2", ((char *)0) },
		{ "r3", "rs3", ((char *)0) },
		{ "rf", "rf", ((char *)0) },
		{ "rc", "rc", ((char *)0) },
		{ "cv", "vpa", ((char *)0) },
		{ "sc", "sc", ((char *)0) },
		{ "sf", "ind", "\n" },
		{ "sr", "ri", ((char *)0) },
		{ "sa", "sgr", ((char *)0) },
		{ "st", "hts", ((char *)0) },
		{ "wi", "wind", ((char *)0) },
		{ "ta", "ht", ((char *)0) },
		{ "ts", "tsl", ((char *)0) },
		{ "uc", "uc", ((char *)0) },
		{ "hu", "hu", ((char *)0) },
		{ "iP", "iprog", ((char *)0) },
		{ "K1", "ka1", ((char *)0) },
		{ "K3", "ka3", ((char *)0) },
		{ "k2", "kb2", ((char *)0) },
		{ "K4", "kc1", ((char *)0) },
		{ "K5", "kc3", ((char *)0) },
		{ "pO", "mc5p", ((char *)0) },
		{ "rP", "rmp", ((char *)0) },
		{ "ac", "acsc", ((char *)0) },
		{ "pn", "pln", ((char *)0) },
		{ "kB", "kcbt", ((char *)0) },
		{ "SX", "smxon", ((char *)0) },
		{ "RX", "rmxon", ((char *)0) },
		{ "SA", "smam", ((char *)0) },
		{ "RA", "rmam", ((char *)0) },
		{ "XN", "xonc", ((char *)0) },
		{ "XF", "xoffc", ((char *)0) },
		{ "eA", "enacs", ((char *)0) },
		{ "LO", "smln", ((char *)0) },
		{ "LF", "rmln", ((char *)0) },
		{ "@1", "kbeg", ((char *)0) },
		{ "@2", "kcan", ((char *)0) },
		{ "@3", "kclo", ((char *)0) },
		{ "@4", "kcmd", ((char *)0) },
		{ "@5", "kcpy", ((char *)0) },
		{ "@6", "kcrt", ((char *)0) },
		{ "@7", "kend", ((char *)0) },
		{ "@8", "kent", ((char *)0) },
		{ "@9", "kext", ((char *)0) },
		{ "@0", "kfnd", ((char *)0) },
		{ "%1", "khlp", ((char *)0) },
		{ "%2", "kmrk", ((char *)0) },
		{ "%3", "kmsg", ((char *)0) },
		{ "%4", "kmov", ((char *)0) },
		{ "%5", "knxt", ((char *)0) },
		{ "%6", "kopn", ((char *)0) },
		{ "%7", "kopt", ((char *)0) },
		{ "%8", "kprv", ((char *)0) },
		{ "%9", "kprt", ((char *)0) },
		{ "0", "krdo", ((char *)0) },
		{ "&1", "kref", ((char *)0) },
		{ "&2", "krfr", ((char *)0) },
		{ "&3", "krpl", ((char *)0) },
		{ "&4", "krst", ((char *)0) },
		{ "&5", "kres", ((char *)0) },
		{ "&6", "ksav", ((char *)0) },
		{ "&7", "kspd", ((char *)0) },
		{ "&8", "kund", ((char *)0) },
		{ "&9", "kBEG", ((char *)0) },
		{ "&0", "kCAN", ((char *)0) },
		{ "*1", "kCMD", ((char *)0) },
		{ "*2", "kCPY", ((char *)0) },
		{ "*3", "kCRT", ((char *)0) },
		{ "*4", "kDC", ((char *)0) },
		{ "*5", "kDL", ((char *)0) },
		{ "*6", "kslt", ((char *)0) },
		{ "*7", "kEND", ((char *)0) },
		{ "*8", "kEOL", ((char *)0) },
		{ "*9", "kEXT", ((char *)0) },
		{ "*0", "kFND", ((char *)0) },
		{ "#1", "kHLP", ((char *)0) },
		{ "#2", "kHOM", ((char *)0) },
		{ "#3", "kIC", ((char *)0) },
		{ "#4", "kLFT", ((char *)0) },
		{ "%a", "kMSG", ((char *)0) },
		{ "%b", "kMOV", ((char *)0) },
		{ "%c", "kNXT", ((char *)0) },
		{ "%d", "kOPT", ((char *)0) },
		{ "%e", "kPRV", ((char *)0) },
		{ "%f", "kPRT", ((char *)0) },
		{ "%g", "kRDO", ((char *)0) },
		{ "%h", "kRPL", ((char *)0) },
		{ "%i", "kRIT", ((char *)0) },
		{ "%j", "kRES", ((char *)0) },
		{ "!1", "kSAV", ((char *)0) },
		{ "!2", "kSPD", ((char *)0) },
		{ "!3", "kUND", ((char *)0) },
		{ "RF", "rfi", ((char *)0) },
		{ "F1", "kf11", ((char *)0) },
		{ "F2", "kf12", ((char *)0) },
		{ "F3", "kf13", ((char *)0) },
		{ "F4", "kf14", ((char *)0) },
		{ "F5", "kf15", ((char *)0) },
		{ "F6", "kf16", ((char *)0) },
		{ "F7", "kf17", ((char *)0) },
		{ "F8", "kf18", ((char *)0) },
		{ "F9", "kf19", ((char *)0) },
		{ "FA", "kf20", ((char *)0) },
		{ "FB", "kf21", ((char *)0) },
		{ "FC", "kf22", ((char *)0) },
		{ "FD", "kf23", ((char *)0) },
		{ "FE", "kf24", ((char *)0) },
		{ "FF", "kf25", ((char *)0) },
		{ "FG", "kf26", ((char *)0) },
		{ "FH", "kf27", ((char *)0) },
		{ "FI", "kf28", ((char *)0) },
		{ "FJ", "kf29", ((char *)0) },
		{ "FK", "kf30", ((char *)0) },
		{ "FL", "kf31", ((char *)0) },
		{ "FM", "kf32", ((char *)0) },
		{ "FN", "kf33", ((char *)0) },
		{ "FO", "kf34", ((char *)0) },
		{ "FP", "kf35", ((char *)0) },
		{ "FQ", "kf36", ((char *)0) },
		{ "FR", "kf37", ((char *)0) },
		{ "FS", "kf38", ((char *)0) },
		{ "FT", "kf39", ((char *)0) },
		{ "FU", "kf40", ((char *)0) },
		{ "FV", "kf41", ((char *)0) },
		{ "FW", "kf42", ((char *)0) },
		{ "FX", "kf43", ((char *)0) },
		{ "FY", "kf44", ((char *)0) },
		{ "FZ", "kf45", ((char *)0) },
		{ "Fa", "kf46", ((char *)0) },
		{ "Fb", "kf47", ((char *)0) },
		{ "Fc", "kf48", ((char *)0) },
		{ "Fd", "kf49", ((char *)0) },
		{ "Fe", "kf50", ((char *)0) },
		{ "Ff", "kf51", ((char *)0) },
		{ "Fg", "kf52", ((char *)0) },
		{ "Fh", "kf53", ((char *)0) },
		{ "Fi", "kf54", ((char *)0) },
		{ "Fj", "kf55", ((char *)0) },
		{ "Fk", "kf56", ((char *)0) },
		{ "Fl", "kf57", ((char *)0) },
		{ "Fm", "kf58", ((char *)0) },
		{ "Fn", "kf59", ((char *)0) },
		{ "Fo", "kf60", ((char *)0) },
		{ "Fp", "kf61", ((char *)0) },
		{ "Fq", "kf62", ((char *)0) },
		{ "Fr", "kf63", ((char *)0) },
		{ "cb", "el1", ((char *)0) },
		{ "MC", "mgc", ((char *)0) },
		{ "ML", "smgl", ((char *)0) },
		{ "MR", "smgr", ((char *)0) },
		{ "Lf", "fln", ((char *)0) },
		{ "SC", "sclk", ((char *)0) },
		{ "DK", "dclk", ((char *)0) },
		{ "RC", "rmclk", ((char *)0) },
		{ "CW", "cwin", ((char *)0) },
		{ "GW", "wingo", ((char *)0) },
		{ "HU", "hup", ((char *)0) },
		{ "DI", "dial", ((char *)0) },
		{ "QD", "qdial", ((char *)0) },
		{ "TO", "tone", ((char *)0) },
		{ "PU", "pulse", ((char *)0) },
		{ "fh", "hook", ((char *)0) },
		{ "PA", "pause", ((char *)0) },
		{ "WA", "wait", ((char *)0) },
		{ "u0", "u0", ((char *)0) },
		{ "u1", "u1", ((char *)0) },
		{ "u2", "u2", ((char *)0) },
		{ "u3", "u3", ((char *)0) },
		{ "u4", "u4", ((char *)0) },
		{ "u5", "u5", ((char *)0) },
		{ "u6", "u6", ((char *)0) },
		{ "u7", "u7", ((char *)0) },
		{ "u8", "u8", ((char *)0) },
		{ "u9", "u9", ((char *)0) },
		{ "op", "op", ((char *)0) },
		{ "oc", "oc", ((char *)0) },
		{ "Ic", "initc", ((char *)0) },
		{ "Ip", "initp", ((char *)0) },
		{ "sp", "scp", ((char *)0) },
		{ "Sf", "setf", ((char *)0) },
		{ "Sb", "setb", ((char *)0) },
		{ "ZA", "cpi", ((char *)0) },
		{ "ZB", "lpi", ((char *)0) },
		{ "ZC", "chr", ((char *)0) },
		{ "ZD", "cvr", ((char *)0) },
		{ "dc", "defc", ((char *)0) },
		{ "ZF", "swidm", ((char *)0) },
		{ "ZG", "sdrfq", ((char *)0) },
		{ "ZH", "sitm", ((char *)0) },
		{ "ZI", "slm", ((char *)0) },
		{ "ZJ", "smicm", ((char *)0) },
		{ "ZK", "snlq", ((char *)0) },
		{ "ZL", "snrmq", ((char *)0) },
		{ "ZM", "sshm", ((char *)0) },
		{ "ZN", "ssubm", ((char *)0) },
		{ "ZO", "ssupm", ((char *)0) },
		{ "ZP", "sum", ((char *)0) },
		{ "ZQ", "rwidm", ((char *)0) },
		{ "ZR", "ritm", ((char *)0) },
		{ "ZS", "rlm", ((char *)0) },
		{ "ZT", "rmicm", ((char *)0) },
		{ "ZU", "rshm", ((char *)0) },
		{ "ZV", "rsubm", ((char *)0) },
		{ "ZW", "rsupm", ((char *)0) },
		{ "ZX", "rum", ((char *)0) },
		{ "ZY", "mhpa", ((char *)0) },
		{ "ZZ", "mcud1", ((char *)0) },
		{ "Za", "mcub1", ((char *)0) },
		{ "Zb", "mcuf1", ((char *)0) },
		{ "Zc", "mvpa", ((char *)0) },
		{ "Zd", "mcuu1", ((char *)0) },
		{ "Ze", "porder", ((char *)0) },
		{ "Zf", "mcud", ((char *)0) },
		{ "Zg", "mcub", ((char *)0) },
		{ "Zh", "mcuf", ((char *)0) },
		{ "Zi", "mcuu", ((char *)0) },
		{ "Zj", "scs", ((char *)0) },
		{ "Zk", "smgb", ((char *)0) },
		{ "Zl", "smgbp", ((char *)0) },
		{ "Zm", "smglp", ((char *)0) },
		{ "Zn", "smgrp", ((char *)0) },
		{ "Zo", "smgt", ((char *)0) },
		{ "Zp", "smgtp", ((char *)0) },
		{ "Zq", "sbim", ((char *)0) },
		{ "Zr", "scsd", ((char *)0) },
		{ "Zs", "rbim", ((char *)0) },
		{ "Zt", "rcsd", ((char *)0) },
		{ "Zu", "subcs", ((char *)0) },
		{ "Zv", "supcs", ((char *)0) },
		{ "Zw", "docr", ((char *)0) },
		{ "Zx", "zerom", ((char *)0) },
		{ "Zy", "csnm", ((char *)0) },
};

#define	MAXSTRS	MAXINDEX(strcaps)

/*
 * print_name:
 *	print name and aliases of current termcap entry.
 */
print_name ()
{
    char	name[100];

    tgetname (name);
    printf ("%s,\n", name);
}

/*
 * print_bools:
 *	print all boolean fields of current termcap entry.
 */
print_bools ()
{
    int		i, val;
    bool	stuffprinted = FALSE;

    for (i = 0; i < MAXBOOLS; i++)
	if (val = tgetflag (boolcaps[i].capname)) {
	    if (val == 1)
		printf ("\t%s,", boolcaps[i].infoname);
	    else
		printf ("\t%s@,", boolcaps[i].infoname);
	    stuffprinted = TRUE;
	}
    if (stuffprinted)
	(void) putchar ('\n');
}

/*
 * print_nums:
 *	print all numeric fields of current termcap entry.
 */
print_nums ()
{
    int		i, capval;
    bool	stuffprinted = FALSE;

    for (i = 0; i < MAXNUMS; i++)
	if ((capval = tgetnum (numcaps[i].capname)) >= 0) {
	    printf ("\t%s#%d,", numcaps[i].infoname, capval);
	    stuffprinted = TRUE;
	}
	else if (capval == -2) {
	    printf ("\t%s@,", numcaps[i].infoname);
	    stuffprinted = TRUE;
	}
    if (stuffprinted)
	(void) putchar ('\n');
}

/*
 * print_strs:
 *	print all string fields of current termcap entry.
 */
print_strs ()
{
    int		i, count = 0;
    char	capval[100];

    for (i = 0; i < MAXSTRS; i++) {
	tgetstr (strcaps[i].capname, capval);
	if (!capval[0]) {
	    if (strcmp (strcaps[i].capname, "le") == 0) {
		tgetstr ("bc", capval);
	    }
	    else if (strcmp (strcaps[i].capname, "ta") == 0) { 
		if (tgetflag ("pt")) {
		    capval[0] = '\t';
		    capval[1] = '\0';
		}
	    }
	}
	if ((!capval[0]) && (strcaps[i].dflt))
	    (void) strcpy (capval, strcaps[i].dflt);
	if (capval[0]) {
	    if (strcmp (capval, "@") != 0) {
		printf ("\t%s=", strcaps[i].infoname);
		if (strcmp(strcaps[i].infoname,"use") != 0) {
		    put_str (capval);
		    printf (",");
		}
		else
		    printf ("%s,", capval);
	    }
	    else
		printf ("\t%s@,", strcaps[i].infoname);
	    count++;
	    if (!(count %= 3))
		putchar ('\n');
	}
    }
    if (count)
	(void) putchar ('\n');
}

/*
 * put_str:
 *	translate strings to printable format and print them.
 */
put_str (s)
char	*s;
{
    bool	rflag = FALSE;	/* % codes */
    char	*c;
    int		parm;

    if ((isdigit (*s)) || (*s == '.')) {	/* handle padding */
	printf ("$<");
	while ((isdigit (*s)) || (*s == '.')) {
	    (void) putchar (*s);
	    s++;
	}
	if (*s == '*') {
	    (void) putchar (*s);
	    s++;
	}
	(void) putchar ('>');
    }
    for (c = s; *c; c++) {	/* scan for % codes (needs work) */
	if (*c == '%') {
	    c++;
	    switch (*c) {
		case 'r':
		    rflag = TRUE;
		    break;
		default:
		    break;	/* ignore */
	    }
	}
    }
    parm = 0;
    while (*s) {		/* print the string */
	switch (*s) {
	    case '%':
		s++;
		switch (*s) {
		    case '%':
			printf ("%%%%");
			break;
		    case 'i':
			printf ("%%i");
			break;
		    case 'd':
			parm++;
			if ((rflag) && (parm <= 2)) {
			    if (parm == 1)
				printf ("%%p2%%d");
			    else
				printf ("%%p1%%d");
			}
			else
			    printf ("%%p%d%%d", parm);
			break;
		    case '2':
			parm++;
			if ((rflag) && (parm <= 2)) {
			    if (parm == 1)
				printf ("%%p2%%02d");
			    else
				printf ("%%p1%%02d");
			}
			else
			    printf ("%%p%d%%02d", parm);
			break;
		    case '3':
			parm++;
			if ((rflag) && (parm <= 2)) {
			    if (parm == 1)
				printf ("%%p2%%03d");
			    else
				printf ("%%p1%%03d");
			}
			else
			    printf ("%%p%d%%03d", parm);
			break;
		    case '.':
			parm++;
			if ((rflag) && (parm <= 2)) {
			    if (parm == 1)
				printf ("%%p2%%c");
			    else
				printf ("%%p1%%c");
			}
			else
			    printf ("%%p%d%%c", parm);
			break;
		    case '+':
			s++;
			parm++;
			if ((rflag) && (parm <= 2)) {
			    if (parm == 1)
				printf ("%%p2%%'%c'%%+%%c", *s);
			    else
				printf ("%%p1%%'%c'%%+%%c", *s);
			}
			else
			    printf ("%%p%d%%'%c'%%+%%c", parm, *s);
			break;
		    default:
			break;	/* ignore */
		}
		break;
	    case '\200':
		printf ("\\0");
		break;
	    case '\177':
		printf ("^?");
		break;
	    case ',':
		printf ("\\,");
		break;
	    case '\\':
		printf ("\\\\");
		break;
	    case '^':
		printf ("\^");
		break;
	    case ':':
		printf ("\\:");
		break;
	    case '\033':
		printf ("\\E");
		break;
	    case '\n':
		printf ("\\n");
		break;
	    case '\r':
		printf ("\\r");
		break;
	    case '\t':
		printf ("\\t");
		break;
	    case '\b':
		printf ("\\b");
		break;
	    case '\f':
		printf ("\\f");
		break;
	    case ' ':
		printf ("\\s");
		break;
	    default:
		if (*s < ' ')
		    printf ("^%c", *s + 'A' - 1);
		else
		    (void) putchar (*s);
		break;
	}
	s++;
    }
}
