////////
/ MSDOS MWC86 runtime.
/ Read and write from port.
////////

#include <larges.h>

////////
/ int
/ in(port);
/ int port;
/
/ Read a word from the specified port.
////////

port	=	RASIZE

	.globl	in_

in_:
	mov	bx, sp
	mov	dx, Pss port(bx)	/ dx = port address
	in	ax, dx			/ Read the port.
	Gret

////////
/ int
/ inb(port);
/ int port;
/
/ Read a byte from the specified port.
////////

port	=	RASIZE

	.globl	inb_

inb_:
	mov	bx, sp
	mov	dx, Pss port(bx)	/ dx = port address
	inb	al, dx			/ Read from the port and
	subb	ah, ah			/ convert to integer.
	Gret

////////
/ int
/ out(port, data);
/ int port;
/ int data;
/
/ Write the word "data" to port "port".
/ Return "data".
////////

port	=	RASIZE
data	=	port+2

	.globl	out_
out_:
	mov	bx, sp
	mov	dx, Pss port(bx)	/ dx = port address
	mov	ax, Pss data(bx)	/ ax = data
	out	dx, ax			/ Send data to the port.
	Gret

////////
/ int
/ outb(port, data);
/ int port;
/ int data;
/
/ Write the low byte of "data" to port "port".
/ Return "data".
////////

port	=	RASIZE
data	=	port+2

	.globl	outb_

outb_:
	mov	bx, sp
	mov	dx, Pss port(bx)	/ dx = port address
	movb	al, Pss data(bx)	/ al = data
	subb	ah, ah			/ Convert to integer.
	outb	dx, al			/ Send data to the port.
	Gret

/ end of inout.m
