/* $Header: /usr/src/sys/i8086/src/RCS/tab.c,v 1.1 88/03/24 17:39:50 src Exp $ */
/* (lgl-
 *	The information contained herein is a trade secret of Mark Williams
 *	Company, and  is confidential information.  It is provided  under a
 *	license agreement,  and may be  copied or disclosed  only under the
 *	terms of  that agreement.  Any  reproduction or disclosure  of this
 *	material without the express written authorization of Mark Williams
 *	Company or persuant to the license agreement is unlawful.
 *
 *	COHERENT Version 2.3.37
 *	Copyright (c) 1982, 1983, 1984.
 *	An unpublished work by Mark Williams Company, Chicago.
 *	All rights reserved.
 -lgl) */
/*
 * Coherent.
 * Tables for the Intel 8086.
 *
 * $Log:	/usr/src/sys/i8086/src/RCS/tab.c,v $
 * Revision 1.1	88/03/24  17:39:50	src
 * Initial revision
 * 
 * 87/08/14	Allan Cornish		/usr/src/sys/i8086/src/tab.c
 * Added tick() as system call 73.
 *
 * 87/07/08	Allan Cornish		/usr/src/sys/i8086/src/tab.c
 * Added alarm2() as system call 72.
 *
 * 86/11/21	Allan Cornish		/usr/src/sys/i8086/src/tab.c
 * Added msgctl(), msgget(), msgrcv(), msgsnd() as system calls 68 to 71.
 *
 * 86/11/19	Allan Cornish		/usr/src/sys/i8086/src/tab.c
 * Added fcntl() and poll() as system calls 66 and 67.
 *
 * 85/07/09	Allan Cornish
 * Added getpgrp() as system call 63.
 */
#include <sys/coherent.h>
#include <sys/i8086.h>
#include <sys/systab.h>

/*
 * System call functions.
 */
int	unone();
int	unull();
int	uexit();
int	ufork();
int	uread();
int	uwrite();
int	uopen();
int	uclose();
int	uwait();
int	ucreat();
int	ulink();
int	uunlink();
int	uexece();
int	uchdir();
int	umknod();
int	uchmod();
int	uchown();
char	*ubrk();
int	ustat();
long	ulseek();
int	ugetpid();
int	umount();
int	uumount();
int	usetuid();
int	ugetuid();
int	ustime();
int	uptrace();
int	ualarm();
int	ufstat();
int	upause();
int	uutime();
int	ustty();
int	ugtty();
int	uaccess();
int	unice();
int	uftime();
int	uftime();
int	usync();
int	ukill();
int	udup();
int	upipe();
int	utimes();
int	uprofil();
long	uunique();
int	usetgid();
int	ugetgid();
int	(*usignal())();
int	usload();
int	usuload();
int	uacct();
int	ulock();
int	uioctl();
int	ugetegid();
int	uumask();
int	uchroot();
int	usetpgrp();
int	ugetpgrp();
int	ugeteuid();
int	ufcntl();
int	upoll();
long	ualarm2();
long	utick();

/*
 * System call table.
 */
struct systab sysitab[NMICALL] ={
	0,  INT,	unone,			/*  0 = ??? */
	2,  INT,	uexit,			/*  1 = exit */
	0,  INT,	ufork,			/*  2 = fork */
	6,  INT,	uread,			/*  3 = read */
	6,  INT,	uwrite,			/*  4 = write */
	4,  INT,	uopen,			/*  5 = open */
	2,  INT,	uclose,			/*  6 = close */
	2,  INT,	uwait,			/*  7 = wait */
	4,  INT,	ucreat,			/*  8 = creat */
	4,  INT,	ulink,			/*  9 = link */
	2,  INT,	uunlink,		/* 10 = unlink */
	6,  INT,	uexece,			/* 11 = exec */
	2,  INT,	uchdir,			/* 12 = chdir */
	0,  INT,	unone,			/* 13 = ??? */
	6,  INT,	umknod,			/* 14 = mknod */
	4,  INT,	uchmod,			/* 15 = chmod */
	6,  INT,	uchown,			/* 16 = chown */
	2,  INT,	ubrk,			/* 17 = break */
	4,  INT,	ustat,			/* 18 = stat */
	8,  LONG,	ulseek,			/* 19 = lseek */
	0,  INT,	ugetpid,		/* 20 = getpid */
	6,  INT,	umount,			/* 21 = mount */
	2,  INT,	uumount,		/* 22 = umount */
	2,  INT,	usetuid,		/* 23 = setuid */
	0,  INT,	ugetuid,		/* 24 = getuid */
	2,  INT,	ustime,			/* 25 = stime */
	8,  INT,	uptrace,		/* 26 = ptrace */
	2,  INT,	ualarm,			/* 27 = alarm */
	4,  INT,	ufstat,			/* 28 = fstat */
	0,  INT,	upause,			/* 29 = pause */
	4,  INT,	uutime,			/* 30 = utime */
	0,  INT,	unone,			/* 31 = ??? */
	0,  INT,	unone,			/* 32 = ??? */
	4,  INT,	uaccess,		/* 33 = access */
	2,  INT,	unice,			/* 34 = nice */
	2,  INT,	uftime,			/* 35 = ftime */
	0,  INT,	usync,			/* 36 = sync */
	4,  INT,	ukill,			/* 37 = kill */
	0,  INT,	unone,			/* 38 = ??? */
	0,  INT,	unone,			/* 39 = ??? */
	0,  INT,	unone,			/* 40 = ??? */
	4,  INT,	udup,			/* 41 = dup */
	2,  INT,	upipe,			/* 42 = pipe */
	2,  INT,	utimes,			/* 43 = times */
	8,  INT,	uprofil,		/* 44 = profil */
	0,  LONG,	uunique,		/* 45 = unique */
	2,  INT,	usetgid,		/* 46 = setgid */
	0,  INT,	ugetgid,		/* 47 = getgid */
	4,  INT,	usignal,		/* 48 = signal */
	0,  INT,	unone,			/* 49 = ??? */
	0,  INT,	unone,			/* 50 = ??? */
	2,  INT,	uacct,			/* 51 = acct */
	0,  INT,	unull,			/* 52 = ??? (phys) */
	0,  INT,	ulock,			/* 53 = lock */
	6,  INT,	uioctl,			/* 54 = ioctl */
	0,  INT,	unone,			/* 55 = ??? (mpx) */
	0,  INT,	ugetegid,		/* 56 = getegid */
	0,  INT,	ugeteuid,		/* 57 = geteuid */
	0,  INT,	unone,			/* 58 = ??? */
	0,  INT,	unone,			/* 59 = ??? */
	2,  INT,	uumask,			/* 60 = umask */
	2,  INT,	uchroot,		/* 61 = chroot */
	0,  INT,	usetpgrp,		/* 62 = setpgrp */
	0,  INT,	ugetpgrp,		/* 63 = getpgrp */
	2,  INT,	usload,			/* 64 = sload */
	2,  INT,	usuload,		/* 65 = suload */
	6,  INT,	ufcntl,			/* 66 = fcntl */
	8,  INT,        upoll,			/* 67 = poll */
	0,  INT,	unone,			/* 68 (was 6, msgctl) */
	0,  INT,	unone,			/* 69 (was 6, msgget) */
	0,  INT,	unone,			/* 70 (was 12, msgrcv) */
	0,  INT,	unone,			/* 71 (was 8, msgsnd) */
	4,  LONG,	ualarm2,		/* 72 = alarm2 */
	0,  LONG,	utick			/* 73 = tick  */
};
