/*
 * This header file defines everything which
 * may be shared between passes of the compiler.
 * This includes limits, types,
 * the opcodes, both in the scratch files and
 * in trees, that are used by all parts of the C compiler
 * and any other compilers that use the C compiler back
 * end (coder and optimizer).
 *
 * Limits.
 */
#define NARGS   32		/* Max. args in a function */
#define	NCSYMB	128		/* Max symbol */
#define	NMNAME	64		/* Longest module name */

/*
 * Scratch file operators.
 */
#define	NOTUSED	0		/* Pads block in RSX */
#define FNAME	1		/* File name */
#define LLABEL	2		/* Local label */
#define	FINISH	3		/* Soft end of file */
#define GLABEL	4		/* Global label */
#define SLABEL	5		/* Static label */
#define BLOCK	6		/* Block of bytes */
#define	PROLOG	7		/* Function prolog */
#define	EPILOG	8		/* Function epilog */
#define LLLINK	9		/* Switch table link */
#define	AUTOS	10		/* Auto adjust */
#define JUMP	11		/* Jump */
#define	CODE	12		/* Machine instruction */
#define	LINE	13		/* Line # */	
#define REXPR	14		/* Return expression */
#define EEXPR	15		/* Effect expression */
#define SEXPR	16		/* Switch expression */
#define SBODY	17		/* Switch body */
#define IEXPR	18		/* Init. expression */
#define IBLOCK	19		/* Init. absolute block */
#define ALIGN	20		/* Allignment */
#define TEXPR	21		/* True jump expression */
#define FEXPR	22		/* False jump expression */
#define ENTER	23		/* Enter an area */
#define	MNAME	24		/* Module name */
#define COMM	25		/* Common in D space */
#define DLOCAT	26		/* Debug label location */
#define DLABEL	27		/* Debug label item */
				/* Segment guess, withdrawn */
#define UREFER	29		/* Undefined reference for floating printf */

/*
 * Symbolic segments. The "SANY" code is
 * never used in an "ENTER"; it only appears as a
 * segment residence flag in an identifier ("LID" or
 * "GID") node.
 */
#define	SCODE	0		/* Code */
#define	SLINK	1		/* Links et al; can be code */
#define	SPURE	2		/* Pure data */
#define	SSTRN	3		/* Strings */
#define	SDATA	4		/* General data */
#define	SBSS	5		/* Uninitialized data */
#define	SANY	6		/* Any segment */
#define SSTACK	7		/* Stack segment */
#define SALIEN	8		/* Some other language */
#define SDBG	9		/* Debugging information */
#define SSYM	10		/* Symbol declarations */

#define NSEG	11		/* Number of segments */

/*
 * Tree operators.
 * Operators are divided into 
 * little subranges.
 * 0<=x<=9	Machine independent leaf.
 * 10<=x<=19	Machine specific leaf.
 * 20<=x<=79	Machine independent operator.
 * 80<=x<=99	Machine specific operator.
 * 100 up.	Keywords, etc. for a parser.
 * No tree passed to the code generator
 * can contain a machine specific
 * operator.
 */
#define	MILBASE	0		/* Machine independent leaf base */
#define	MDLBASE	15		/* Machine dependent leaf base */
#define	MIOBASE	20		/* Machine independent operator base */
#define	MDOBASE	80		/* Machine dependent operator base */
#define	ETCBASE	100		/* Misc. base */

#define NIL	0		/* End of tree */
#define ICON	1		/* Integer constant */
#define LCON	2		/* Long constant */
#define DCON	3		/* Double constant */
#define	LID	5		/* Local id */
#define	GID	6		/* Global id */
#define	REG	7		/* Register */
#define	AID	8		/* Automatic id */
#define	PID	9		/* Parameter id */
#define ZCON	10		/* Sizeof constant */

#define ADD	20		/* + */
#define SUB	21		/* - */
#define MUL	22		/* * */
#define DIV	23		/* / */
#define REM	24		/* % */
#define AND	25		/* & */
#define OR	26		/* | */
#define XOR	27		/* ^ */
#define SHL	28		/* << */
#define SHR	29		/* >> */

#define AADD	30		/* += */
#define ASUB	31		/* -= */
#define AMUL	32		/* *= */
#define ADIV	33		/* /= */
#define AREM	34		/* %= */
#define AAND	35		/* &= */
#define AOR	36		/* |= */
#define AXOR	37		/* ^= */
#define ASHL	38		/* <<= */
#define ASHR	39		/* >>= */

#define EQ	40		/* == */
#define NE	41		/* != */
#define GT	42		/* > */
#define GE	43		/* >= */
#define LE	44		/* <= */
#define LT	45		/* < */
#define UGT	46		/* > if unsigned */
#define UGE	47		/* >= if unsigned */
#define ULE	48		/* <= if unsigned */
#define ULT	49		/* < if unsigned */

#define STAR	50		/* Indirection */
#define ADDR	51		/* Address of */
#define NEG	52		/* - */
#define COM	53		/* ~ */
#define NOT	54		/* ! */
#define QUEST	55		/* ? */
#define COLON	56		/* : */
#define INCBEF	57		/* ++ prefix */
#define DECBEF	58		/* -- prefix */
#define INCAFT	59		/* ++ postfix */
#define DECAFT	60		/* -- postfix */
#define COMMA	61		/* , */
#define CALL	62		/* Call of function */
#define ANDAND	63		/* && */
#define OROR	64		/* || */
#define CAST	65		/* Type cast */
#define CONVERT	66		/* Conversion */
#define FIELD	67		/* Field op */
#define SIZEOF	68		/* sizeof */
#define ASSIGN	69		/* = */
#define	NOP	70		/* Drain */
#define INIT    71		/* Init. type */
#define	ARGLST	72		/* Link for arglist */
#define	LEAF	73		/* Leaf node */
#define	FIXUP	74		/* Table fix up */
#define	BLKMOVE	75		/* Block move operation */
#define POS	76		/* Unary plus */

/*
 * Special names for Types, Dims, and Storage classes
 * for use in passing debugger type information between passes.
 */
#define DT_NONE  0		/* No type (yet) */
#define DT_CHAR  1		/* Char */
#define DT_UCHAR 2		/* Unsigned char */
#define DT_SHORT 3		/* Short */
#define DT_USHORT 4		/* Unsigned short */
#define DT_INT   5		/* Int */
#define DT_UINT  6		/* Unsigned int */
#define DT_LONG  7		/* Long */
#define DT_ULONG 8		/* Unsigned long */
#define DT_FLOAT 9		/* Float */
#define DT_DOUBLE 10		/* Double */
#define	DT_VOID	11		/* void */
#define DT_STRUCT 12		/* Struct */
#define DT_UNION 13		/* Union */
#define DT_ENUM  14		/* Enumeration */

#define DD_PTR   15		/* Pointer */
#define DD_FUNC  16		/* Function returning */
#define DD_ARRAY 17		/* Array */

#define DX_MEMBS 18		/* Member list */
#define DX_NAME  19		/* Named type */

/*
 * Subranges denote associated information:
 *	SEX-LAB		only name string.
 *	AUTO-CALL	name and (int) value.
 *	MOS-MOU		name, width, offset, value.
 */
#define DC_SEX   21		/* Static external */
#define DC_GDEF  22		/* Global def. */
#define DC_GREF  23		/* Global ref. */
#define DC_TYPE  24		/* Typedef name */
#define DC_STAG  25		/* Structure tag */
#define DC_UTAG  26		/* Union tag */
#define DC_ETAG  27		/* Enumeration tag */
#define DC_FILE  28		/* Source file name */
#define DC_LINE  29		/* Line number */
#define DC_LAB   30		/* Label */

#define DC_AUTO  31		/* Auto */
#define DC_PAUTO 32		/* Parametric auto */
#define DC_REG   33		/* Register */
#define DC_PREG  34		/* Parametric register */
#define DC_SIN   35		/* Static internal */
#define DC_MOE   36		/* Member of enumeration */
#define DC_CALL  37		/* Function call */

#define DC_MOS   38		/* Member of structure */
#define DC_MOU   39		/* Member of union */
