#
# Calculate how many mailers we need.
#
DATABASE mwc

MAIN
	DEFINE  a RECORD LIKE address.*
	DEFINE  sws ARRAY[500] OF SMALLINT
	DEFINE  p RECORD LIKE product.*
	DEFINE  i RECORD LIKE inv_line.*
	DEFINE  sw SMALLINT
	DEFINE  c_no, s_no INTEGER
	DEFINE	i_date DATE

	# Delete work file if it exists
	WHENEVER ERROR CONTINUE
	DROP TABLE workf
	WHENEVER ERROR STOP

	CREATE TABLE workf (
		cust_no		INTEGER,
		tbl		SMALLINT,
		info		SMALLINT,
		info_date	DATE
	)

	DECLARE cur1 CURSOR FOR SELECT * FROM product

	#
	# Preload table to speed things up.
	# This makes the difference between 15 min and 4 hrs.
	#
	FOREACH cur1 INTO p.*
		LET sw = p.prod_no
		IF p.prod_name MATCHES "*Coherent*" THEN
			LET sws[sw] = 2
			IF p.prod_name MATCHES "*3.1*" THEN
				LET sws[sw] = 3
			END IF
			IF p.prod_name MATCHES "*3.2*" THEN
				LET sws[sw] = 4
			END IF
			IF p.prod_name MATCHES "*4.0*" THEN
				LET sws[sw] = 5
				IF p.prod_name MATCHES "*Update*" THEN
					LET sws[sw] = 6
				END IF
			END IF
			IF p.prod_name MATCHES "*Club*"  THEN
				LET sws[sw] = 7
			END IF
		ELSE
			LET sws[sw] = 1
		END IF
	END FOREACH

	CLOSE cur1

	START REPORT mail_list

	#
	# Get product information from inv lines
	#
	DECLARE cur2 CURSOR FOR
	 SELECT address.*, inv_line.*, invoice.invoice_date
	   FROM address, OUTER (invoice, OUTER inv_line)
	  WHERE	address.add_type <> "b"
	    AND	invoice.cust_no = address.cust_no
	    AND	inv_line.invoice_no = invoice.invoice_no
	    
	FOREACH cur2 INTO a.*, i.*, i_date
		LET sw = 1
		IF i.prod_no IS NOT NULL THEN
			LET sw = i.prod_no
			LET sw = sws[sw]
		END IF

		OUTPUT TO REPORT mail_list(a.cust_no, a.country, sw, 1, i_date)
	END FOREACH

	CLOSE cur2

	#
	# Get regcards data
	#
	DECLARE cur3 CURSOR FOR
	 SELECT regcard.ser_no, regcard.reg_date, 
	 	address.cust_no, address.country
	   FROM regcard, address
	  WHERE regcard.cust_no = address.cust_no
	    AND	address.add_type <> "b"

	FOREACH cur3 INTO s_no, i_date, c_no, a.country
		IF s_no IS NULL THEN
			LET s_no = 0
		END IF
		LET s_no = s_no / 100000000
		CASE
		WHEN s_no = 8	# german 3.1 regcad
			LET sw = 3
		WHEN s_no = 4	# 4.0 regcard
			LET sw = 4
		WHEN s_no = 3	# 3.2 regcard
			LET sw = 4
		WHEN s_no = 2	# 3.1 regcard
			LET sw = 3
		WHEN s_no = 1	# 3.0 regcard
			LET sw = 2
		OTHERWISE
			CONTINUE FOREACH
		END CASE

		OUTPUT TO REPORT mail_list(c_no, a.country, sw, 0, i_date)
	END FOREACH

	CLOSE cur3

	#
	# Get new regcards data
	#
	DECLARE cur4 CURSOR FOR
	 SELECT newreg.ser_no, newreg.reg_date,
	 	address.cust_no, address.country
	   FROM newreg, address
	  WHERE newreg.cust_no = address.cust_no
	    AND	address.add_type <> "b"

	FOREACH cur4 INTO s_no, i_date, c_no, a.country
		IF s_no IS NULL THEN
			LET s_no = 0
		END IF
		LET s_no = s_no / 100000000
		CASE
		WHEN s_no = 8	# german 3.1 regcad
			LET sw = 3
		WHEN s_no = 4	# 4.0 regcard
			LET sw = 4
		WHEN s_no = 3	# 3.2 newreg
			LET sw = 4
		WHEN s_no = 2	# 3.1 newreg
			LET sw = 3
		WHEN s_no = 1	# 3.0 newreg
			LET sw = 2
		OTHERWISE
			CONTINUE FOREACH
		END CASE

		OUTPUT TO REPORT mail_list(c_no, a.country, sw, 0, i_date)
	END FOREACH

	CLOSE cur4

	FINISH REPORT mail_list
END MAIN

REPORT mail_list(cst_no, country, i, i_source, i_date)
	DEFINE	cst_no INTEGER
	DEFINE	country LIKE address.country
	DEFINE	i, i_source SMALLINT
	DEFINE	i_date DATE

	DEFINE	nfo CHAR(1)
	DEFINE	sw INTEGER
	DEFINE  us, excl, ca, other, tot ARRAY[9] OF SMALLINT
	DEFINE  head ARRAY[9] OF CHAR(40)
	DEFINE  subtot, c_amt MONEY(10, 2)

	DEFINE w RECORD
		cust_no		INTEGER,
		tbl		SMALLINT,
		info		SMALLINT,
		info_date	DATE
	END RECORD

	OUTPUT
		REPORT TO "mailcalc.rep"
		PAGE LENGTH 80

	ORDER BY cst_no, i

	FORMAT
	FIRST PAGE HEADER
		PRINT	DATE, 10 SPACES, "Mailer calculation report"

		FOR sw = 1 TO 9
			LET us[sw] = 0
			LET excl[sw] = 0
			LET ca[sw] = 0
			LET other[sw] = 0
			LET tot[sw] = 0
		END FOR
 
		LET head[1] = "No Coherent product"
		LET head[2] = "Coherent pre 3.1"
		LET head[3] = "Coherent 3.1"
		LET head[4] = "Coherent 3.2"
		LET head[5] = "Coherent 4.0"
		LET head[6] = "Coherent 4.0 Update"
		LET head[7] = "Coherent Club"
		LET head[8] = "Coherent returned for full credit"
		LET head[9] = "Removed from mailing list"
 
	BEFORE GROUP OF cst_no
		LET sw  = 1	# no product spotted

	ON EVERY ROW
		CASE
		WHEN i > sw
			LET sw = i
			LET w.info = i_source
			LET w.info_date = i_date
		WHEN i == sw
		 AND i_source > w.info
			LET w.info = i_source
			LET w.info_date = i_date			
		END CASE

	AFTER GROUP OF cst_no
		SELECT SUM(cmemo.amount)
		  INTO c_amt
		  FROM invoice, cmemo
		 WHERE invoice.cust_no = cst_no
		   AND cmemo.invoice_no = invoice.invoice_no

		IF c_amt IS NOT NULL AND c_amt > 0 THEN
			SELECT SUM(invoice.subtotal)
			  INTO subtot
			  FROM invoice
			 WHERE invoice.cust_no = cst_no

			IF subtot IS NULL OR subtot <= c_amt THEN
				LET sw = 8
			END IF
		END IF

		SELECT all_nfo
		  INTO nfo
		  FROM customer
		 WHERE cust_no = cst_no

		CASE
		WHEN nfo = "x"
			LET sw = 9
		END CASE

		LET tot[sw] = tot[sw] + 1

		CASE
		WHEN country IS NULL 
			LET us[sw] = us[sw] + 1
		WHEN country == "CANADA"
			LET ca[sw] = ca[sw] + 1
	    	WHEN country == "GERMANY"
	    	  OR country == "ENGLAND"
	    	  OR country == "HOLLAND"
	    	  OR country == "SPAIN"
	    	  OR country == "JAPAN"
			LET excl[sw] = excl[sw] + 1
		OTHERWISE
			LET other[sw] = other[sw] + 1
		END CASE

		LET w.tbl = sw
		LET w.cust_no = cst_no
		INSERT INTO workf VALUES (w.*)

	ON LAST ROW
		FOR sw = 1 TO 9
			SKIP 1 LINE
			LET tot[sw] = tot[sw] - excl[sw]

			PRINT  head[sw], " LIST", sw USING "##"
			PRINT	 us[sw], " US"
			PRINT 	 ca[sw], " CANADA"
			PRINT  excl[sw], " EXCLUDED"
			PRINT other[sw], " OTHER"
			PRINT   tot[sw], " TOTAL"
		END FOR
END REPORT
