#
# WAND DATA
#
GLOBALS "globals0.4gl"

# static variable
DEFINE invoice_no LIKE pickup_line.invoice_no

FUNCTION wand_data()
	DISPLAY FORM wand_form

	MESSAGE ""
	LET chosen = FALSE

	MENU "WAND"
	COMMAND "Add" "Add one or more wand entries"
		CALL enter_wand()

	COMMAND "Find" "Find a wand entry"
		CALL find_wand()

		IF chosen THEN
			NEXT OPTION "Delete"
		END IF

	COMMAND "Delete" "Delete a wand entry"
		IF chosen THEN
			CALL yn("Are you sure you want to delete this? ")
		                RETURNING answer

	                IF answer <> "y" THEN
				CONTINUE MENU
			END IF
		END IF

		IF invoice_no IS NULL THEN
			CALL get_invoice_number()
		ELSE
			CALL yn("Is this the right invoice number? ")
				RETURNING answer
	                IF answer = "n" THEN
				CALL get_invoice_number()
			END IF
		END IF

		IF p_shipreg.ser_no IS NOT NULL THEN
			DELETE FROM shipreg
			WHERE ser_no = p_shipreg.ser_no
		ELSE
			# this should never happen, but just in case ...
			CONTINUE MENU
	        END IF

		# we now have the right invoice number
		DELETE FROM pickup_line
			WHERE pickup_line.invoice_no = invoice_no

                LET chosen = FALSE

	COMMAND "Exit" "Leave wand screen"
		MESSAGE ""
		EXIT MENU
	END MENU
END FUNCTION

FUNCTION find_wand()
	DEFINE	exist SMALLINT,
		answer CHAR(1)

	CLEAR FORM
	MESSAGE ""

	CONSTRUCT query1 ON shipreg.* FROM shipreg.*

	LET s1 = "SELECT * FROM shipreg WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE w_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH w_curs INTO p_shipreg.*
		LET exist = TRUE

		DISPLAY BY NAME p_shipreg.*

		CALL yn("Enter 'y' to select this record ")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE w_curs

	IF exist = FALSE THEN
		MESSAGE "No record found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more records"
		END IF
	END IF
END FUNCTION

#
# Enter wand data. 
#
FUNCTION enter_wand()
	DEFINE ret_status SMALLINT
	DEFINE counter INTEGER
	DEFINE num_returns INTEGER
	DEFINE ship_date LIKE invoice.ship_date

# initialize these to NULL on the first go-round
	MESSAGE "Enter a blank serial number to end wanding"

	LET p_shipreg.cust_no  = NULL
	LET invoice_no         = NULL
	LET p_shipreg.trace_no = NULL
	LET ship_date          = TODAY
	LET p_shipreg.ser_no   = NULL
	LET num_returns        = 1

	DISPLAY BY NAME
		p_shipreg.cust_no,
		invoice_no,
		p_shipreg.trace_no,
		ship_date,
		p_shipreg.ser_no

	INPUT BY NAME	p_shipreg.cust_no,
			invoice_no,
			p_shipreg.trace_no,
			ship_date,
			p_shipreg.ser_no
			WITHOUT DEFAULTS

# change shipping date from today to tomorrow
	ON KEY (CONTROL-T)
		IF infield(ship_date) THEN
			LET ship_date = ship_date + 1
			DISPLAY BY NAME ship_date
		END IF

# change shipping date from today to yesterday
	ON KEY (CONTROL-Y)
		IF infield(ship_date) THEN
			LET ship_date = ship_date - 1
			DISPLAY BY NAME ship_date
		END IF

#
# NB - the bar-code wand is programmed to output two (2) carriage returns.
# The booklet that lets us reprogram the wand is lost.  Therefore, the
# following kludge is necessary.
#
	AFTER FIELD cust_no
		IF num_returns < 2 THEN
			LET num_returns = num_returns + 1
			NEXT FIELD cust_no
		END IF

		IF p_shipreg.cust_no = 0 THEN
			MESSAGE "To end entry, put 0 into the serial-number field"
				ATTRIBUTE(REVERSE, BLINK)
			LET num_returns = 1
			NEXT FIELD cust_no
		END IF

		IF p_shipreg.cust_no IS NULL THEN
			MESSAGE "You must enter a customer number"
				ATTRIBUTE(REVERSE, BLINK)
			LET p_invoice.invoice_no = NULL
			DISPLAY BY NAME p_invoice.invoice_no
			LET num_returns = 1
			NEXT FIELD cust_no
		END IF

		LET counter = 0
		SELECT count(*)
			INTO counter
			FROM customer
			WHERE customer.cust_no = p_shipreg.cust_no

		IF counter = 0 THEN
			MESSAGE "This customer number is not valid"
				ATTRIBUTE(REVERSE, BLINK)
			LET p_invoice.invoice_no = NULL
			DISPLAY BY NAME p_invoice.invoice_no
			LET num_returns = 1
			NEXT FIELD cust_no
		END IF
		LET num_returns = 1
		NEXT FIELD invoice_no

	BEFORE FIELD invoice_no
		MESSAGE ""

	AFTER FIELD invoice_no
		IF num_returns < 2 THEN
			LET num_returns = num_returns + 1
			NEXT FIELD invoice_no
		END IF

		IF invoice_no IS NULL THEN
			MESSAGE "You must enter an invoice number"
				ATTRIBUTE(REVERSE, BLINK)
			LET num_returns = 1
			NEXT FIELD invoice_no
		END IF

		LET counter = 1
		SELECT count(*)
			INTO counter
			FROM invoice
			WHERE	invoice.invoice_no = invoice_no

		IF counter = 0 THEN
			MESSAGE "This invoice number is invalid - try again."
				ATTRIBUTE(REVERSE, BLINK)
			LET invoice_no = NULL
			DISPLAY BY NAME invoice_no
			NEXT FIELD invoice_no
		END IF

		# Add a record to the UPS tables in the data base
		CALL ups_add_noninteract (invoice_no, p_shipreg.cust_no)

		MESSAGE ""
		NEXT FIELD trace_no

	AFTER FIELD trace_no
		IF num_returns < 2 THEN
			LET num_returns = num_returns + 1
			NEXT FIELD trace_no
		END IF
		LET num_returns = 1
		NEXT FIELD ship_date

	AFTER FIELD ship_date
# this is always entered by hand, so you don't need the two CR jazz
		MESSAGE "Press CTRL-T to increase date, CTRL-Y to decrease"

		UPDATE invoice
			SET invoice.ship_date = ship_date
			WHERE invoice.invoice_no = invoice_no

		MESSAGE ""
		NEXT FIELD ser_no

	AFTER FIELD ser_no
		IF p_shipreg.ser_no IS NULL THEN
			IF num_returns > 1 THEN
				RETURN
			ELSE
				LET num_returns = num_returns + 1
				NEXT FIELD ser_no
			END IF
		END IF

		LET num_returns = 1

		CALL ch_num (p_shipreg.ser_no)
			RETURNING ret_status

		IF ret_status <> 0 THEN
			MESSAGE "Invalid serial number - try again"
				ATTRIBUTE(REVERSE, BLINK)
			LET p_shipreg.ser_no = NULL
			DISPLAY BY NAME p_shipreg.ser_no
			NEXT FIELD ser_no
		END IF

		SELECT COUNT (*)
			INTO counter
			FROM shipreg
			WHERE ser_no = p_shipreg.ser_no

		IF counter <> 0 THEN
			MESSAGE "Serial number already entered - try again"
				ATTRIBUTE(REVERSE, BLINK)
			LET p_shipreg.ser_no = NULL
			DISPLAY BY NAME p_shipreg.ser_no
			NEXT FIELD ser_no
		END IF

		INSERT INTO shipreg VALUES (
			p_shipreg.cust_no,
			p_shipreg.ser_no,
			p_shipreg.trace_no
		)

		MESSAGE "Serial number ", p_shipreg.ser_no, " recorded"
		LET p_shipreg.ser_no = NULL
		DISPLAY BY NAME p_shipreg.ser_no
		NEXT FIELD ser_no
	END INPUT
END FUNCTION

# get just the invoice number
FUNCTION get_invoice_number()
	LET invoice_no = NULL

	MESSAGE "Enter invoice number"

	INPUT BY NAME invoice_no
		
	AFTER FIELD invoice_no
		IF invoice_no IS NULL THEN
			NEXT FIELD invoice_no
		END IF

		CALL yn("Is this the right invoice number? ")
			RETURNING answer
		IF answer = "y" THEN
			MESSAGE ""
			RETURN
		END IF

		NEXT FIELD invoice_no

	END INPUT

END FUNCTION
