#
# Set ship date
#
GLOBALS "globals0.4gl"
FUNCTION mship_date()
	DISPLAY FORM sdate

LABEL loop:
	MESSAGE "Enter zero to end ship dates"

	INPUT BY NAME i_no

	IF i_no = 0 THEN
		MESSAGE ""
		RETURN
	END IF

	LET p_cust.contact = NULL

	SELECT contact, ship_date, icomments
	  INTO p_cust.contact, p_invoice.ship_date, p_invoice.icomments
	  FROM customer, invoice
	 WHERE invoice.invoice_no = i_no
	   AND customer.cust_no = invoice.cust_no

	IF p_cust.contact IS NULL THEN
		PROMPT "Invoice not found <enter> to continue"
		   FOR answer
		GOTO loop
	END IF

	DISPLAY BY NAME p_cust.contact

	LET p_invoice.ship_date = TODAY - 1
	
	MESSAGE "Enter blank date to refuse this entry"

	INPUT BY NAME   p_invoice.ship_date, p_invoice.icomments
	 WITHOUT DEFAULTS

	IF p_invoice.ship_date IS NULL THEN
		GOTO loop
	END IF

	UPDATE invoice SET invoice.ship_date = p_invoice.ship_date,
			   invoice.icomments = p_invoice.icomments
	 WHERE invoice.invoice_no = i_no

	GOTO loop
END FUNCTION
