#
# Produce Special list for jay
#
DATABASE mwc

#
# Produce mailing lists set up by mailcalc
#
GLOBALS
	DEFINE  a RECORD LIKE address.*
	DEFINE	c RECORD LIKE customer.*
	DEFINE  req SMALLINT
END GLOBALS

MAIN
	LET req = arg_val(1)

	DECLARE curs CURSOR FOR
	 SELECT address.*, customer.*
	   FROM workf, address, customer
	  WHERE workf.tbl IN (2, 3, 4)
	    AND address.cust_no = workf.cust_no
	    AND	address.add_type <> "s"
	    AND address.country = "NETHERLANDS"
	    AND	customer.cust_no = address.cust_no
	START REPORT mail_list

	FOREACH curs INTO a.*, c.*
		IF a.zipcode IS NULL THEN	# prevent control breaks
			LET a.zipcode = "-"
		END IF

		OUTPUT TO REPORT mail_list(c.*, a.*)
	END FOREACH

	FINISH REPORT mail_list

	CLOSE curs
END MAIN

REPORT mail_list(c, a)
	DEFINE  c RECORD LIKE customer.*
	DEFINE  a RECORD LIKE address.*
	DEFINE  s1 CHAR(100)

	OUTPUT
		REPORT TO "mail0"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY a.country, a.zipcode, a.cust_no

	FORMAT
	ON EVERY ROW
		PRINT c.contact CLIPPED, " ", a.cust_no USING "<<<<<<"
		PRINT a.line1 CLIPPED
		PRINT a.line2 CLIPPED
		PRINT a.line3 CLIPPED
		CALL addline(a.*) RETURNING s1
		PRINT	s1 CLIPPED
		PRINT a.country CLIPPED
		PRINT c.phone_no CLIPPED
END REPORT

#
# Create city, state zip address line.
#
FUNCTION addline(a)
	DEFINE a RECORD LIKE address.*
	DEFINE w CHAR(80)

	IF a.zipcode = "-" THEN
		LET a.zipcode = NULL
	END IF

	IF a.zipcode IS NOT NULL THEN
		LET w = a.zipcode CLIPPED
	ELSE
		LET w = NULL
	END IF

	IF a.state IS NOT NULL THEN
		LET w = a.state CLIPPED, " ", w CLIPPED
	END IF

	IF a.city IS NOT NULL THEN
		LET w = a.city CLIPPED, ", ", w CLIPPED
	END IF

	RETURN w
END FUNCTION
