#
# Code to handle the dest file
#
GLOBALS "globals0.4gl"

FUNCTION dest_menu()
	DISPLAY FORM dest_form

	LET chosen = FALSE

	MENU "DESTS"
	COMMAND "Add" "Add a new dest"
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_dest()

			CALL yn("Enter another row <y/n>")
				RETURNING answer
		END WHILE

	COMMAND "Query" "Search for a dest"
		CALL query_dest()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify a dest"
		IF chosen THEN
			CALL change_dest()
		ELSE
			MESSAGE "Use query first "
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete a dest"
		IF chosen THEN
			CALL yn("Are you sure <y/n>") RETURNING answer

			IF answer = "y" THEN
				CALL delete_dest()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "Use query first "
			NEXT OPTION "Query"
		END IF

	COMMAND "Exit" "Leave the dest menu"
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

#
# Report on all dests to file
#
REPORT dest_list (r_dest)
	DEFINE r_dest RECORD LIKE dests.*

	OUTPUT
		REPORT TO "dests.lst"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0
		PAGE LENGTH 80

	FORMAT
	ON EVERY ROW
		PRINT 	r_dest.dest_no USING "###", " ",
			r_dest.dest_name
END REPORT

FUNCTION enter_dest()
	MESSAGE ""
	CLEAR FORM

	INPUT BY NAME p_dest.dest_name
	AFTER FIELD dest_name
		IF p_dest.dest_name IS NULL THEN
			NEXT FIELD dest_name
		END IF
	END INPUT

	INSERT INTO dests VALUES (0, p_dest.dest_name)

	LET p_dest.dest_no = SQLCA.SQLERRD[2]

	DISPLAY BY NAME p_dest.dest_no

	MESSAGE "Row added"
END FUNCTION

FUNCTION query_dest()
	DEFINE exist SMALLINT,
	       answer CHAR(1)

	CLEAR FORM
	MESSAGE ""

	CONSTRUCT query1 ON dests.* FROM dests.*

	LET s1 = "SELECT * FROM dests WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE t_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH t_curs INTO p_dest.*
		LET exist = TRUE

		DISPLAY BY NAME p_dest.*

		CALL yn("Enter 'y' to select this dest")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE t_curs

	IF exist = FALSE THEN
		MESSAGE "No dest rows found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more rows"
		END IF
	END IF
END FUNCTION

FUNCTION change_dest()
	INPUT BY NAME p_dest.dest_name WITHOUT DEFAULTS

	UPDATE dests SET dests.* = p_dest.* 
	 WHERE dest_no = p_dest.dest_no
END FUNCTION

FUNCTION delete_dest()
	DELETE FROM dests WHERE dest_no = p_dest.dest_no

	CLEAR FORM
END FUNCTION
