#
# Bad media system. Reports. Release 2
#
GLOBALS "globals0.4gl"

#
# Menu for different reports
#
FUNCTION report_menu()

	CLEAR FORM

	MENU ""
	
	COMMAND "Total" "Get a total numbers. Output on screen"
		CALL total()

	COMMAND "Customer" "Information about customer. "
		CALL bad_report()

	COMMAND "Exit"
		EXIT MENU

	END MENU
END FUNCTION

#
# Total numbers of rows with certain field(s)
#
FUNCTION total()
	DEFINE bad_rows	SMALLINT

	CONSTRUCT query1
	  ON ser_no, 	cust_no,	call_d,
	     med_type,	cmnt,		reply,
	     ship_no,	prod_no,	disk,
	     head,	cylinder,	badfile,
	     controller,i_msgs
	  FROM ser_no, 	cust_no,	call_d,
	      med_type,	cmnt,		reply,
	      ship_no,	prod_no,	disk,
	      head,	cylinder,	badfile,
	      controller,i_msgs
	LET s1 = "SELECT COUNT(*) FROM bad_disk WHERE ",
		query1 CLIPPED 

	PREPARE s_2 FROM s1

	DECLARE tot_curs CURSOR FOR s_2

	OPEN tot_curs
	FETCH tot_curs INTO bad_rows
	CLOSE tot_curs

	PROMPT "Total is ", bad_rows, " Enter to continue" FOR tbl
END FUNCTION

#
# Bad report to do report about reship media by customer request
#
FUNCTION bad_report()

	CONSTRUCT query1
	  ON ser_no, 	cust_no,	call_d,
	     med_type,	cmnt,		reply,
	     ship_no,	prod_no,	disk,
	     head,	cylinder,	badfile,
	     controller,i_msgs
	  FROM ser_no, 	cust_no,	call_d,
	      med_type,	cmnt,		reply,
	      ship_no,	prod_no,	disk,
	      head,	cylinder,	badfile,
	      controller,i_msgs

	LET s1 = "SELECT * FROM bad_disk WHERE ",
		query1 CLIPPED 

	PREPARE s_1 FROM s1

	DECLARE rep_curs CURSOR FOR s_1

	START REPORT gen_report

	FOREACH rep_curs INTO p_bad.*

		SELECT * INTO p_cust.*, s_address.*, p_product.*
		   FROM customer, address, product
		   WHERE customer.cust_no = p_bad.cust_no AND
			address.cust_no = p_bad.cust_no   AND
			address.add_type <> "b"		  AND
			product.prod_no = p_bad.prod_no  

			
		OUTPUT TO REPORT gen_report(p_bad.*, p_cust.*, s_address.*,
			p_product.*)

			
	END FOREACH

	FINISH REPORT gen_report

	CLEAR SCREEN
	DISPLAY FORM bad_disk
END FUNCTION

#
# Print report
#
REPORT gen_report(p_bad, p_cust, s_address, p_product)
	DEFINE p_bad 		RECORD LIKE bad_disk.*
	DEFINE p_cust 		RECORD LIKE customer.*
	DEFINE s_address	RECORD LIKE address.*
	DEFINE p_product	RECORD LIKE product.*

	OUTPUT 
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	FORMAT
	
	PAGE HEADER
		PRINT PAGENO USING "pag <<<<", 20 SPACES, 
				"GENERAL RESHIPPED REPORT"
		PRINT query1 CLIPPED
		SKIP 2 LINES

	ON EVERY ROW
		PRINT "________________"
		SKIP 1 LINE 
		PRINT "Customer number ", p_cust.cust_no USING "######"
		PRINT "Customer name    ",  p_cust.contact, 
				"Phone ", p_cust.phone_no
		PRINT "Call date        ", p_bad.call_d, " Reshipped date ", 
								p_bad.reply
		PRINT "Product          ", p_product.prod_name CLIPPED, " ",
						p_product.comment1 CLIPPED
		PRINT "Reshipped        ", p_bad.disk
		
		IF p_bad.med_type = "b" THEN
			PRINT "Head             ", p_bad.head USING "##",
			      "      Cylinder   ", p_bad.cylinder USING "##",
			      "      Bad file   ", p_bad.badfile CLIPPED
			IF p_bad.controller IS NOT NULL THEN
				PRINT "Controller       ", p_bad.controller
			ELSE
				PRINT "Controller       N/A"
			END IF
			
			IF p_bad.i_msgs IS NOT NULL THEN
				PRINT "Instalation msgs  ", p_bad.i_msgs
			ELSE
				PRINT "Instalation msgs N/A"
			END IF
		END IF
	
		SKIP 1 LINE

		PRINT "           ADDRESS"
		PRINT p_cust.contact CLIPPED

		PRINT s_address.line1 CLIPPED

		IF s_address.line2 IS NOT NULL THEN
			PRINT s_address.line2 CLIPPED
			IF s_address.line3 IS NOT NULL THEN
				PRINT s_address.line3 CLIPPED
			END IF
		END IF

		PRINT s_address.city CLIPPED, " ", s_address.state CLIPPED, 
		   " ", s_address.country CLIPPED, s_address.zipcode CLIPPED
		SKIP 2 LINES
END REPORT
