#
# Misc functions for mwc database system.
#
GLOBALS "globals0.4gl"

#
# Get address information until there is a bill to and a ship to
# Call with 1 where address exists, 0 where it must be created
#
FUNCTION get_address(sw)
	DEFINE sw, fsw SMALLINT
	DEFINE bill_to, ship_to, add_sel CHAR(1)

	LET bill_to = "x"
	LET ship_to = "x"

	IF sw = 1 THEN	# Address exists
		SELECT * INTO b_address.* FROM address
		  WHERE cust_no = p_cust.cust_no AND
	        	add_type <> "s"
		DISPLAY BY NAME b_address.line1 THRU b_address.zipcode

		SELECT * INTO s_address.* FROM address
		  WHERE cust_no = p_cust.cust_no AND
	        	add_type <> "b"
	ELSE
		LET b_address.add_type = "x"
		LET s_address.add_type = "x"
		LET b_address.line1 = NULL
		LET b_address.line2 = NULL
		LET b_address.line3 = NULL
		LET b_address.city = NULL
		LET b_address.state = NULL
		LET b_address.country = NULL
		LET b_address.zipcode = NULL
		LET s_address.line1 = NULL
		LET s_address.line2 = NULL
		LET s_address.line3 = NULL
		LET s_address.city = NULL
		LET s_address.state = NULL
		LET s_address.country = NULL
		LET s_address.zipcode = NULL
	END IF

	LET add_sel = b_address.add_type

	WHILE bill_to = "x" OR ship_to = "x"
		MESSAGE "s = ship to, b = bill to, x = both"

		INPUT add_sel WITHOUT DEFAULTS FROM add_type
		IF add_sel = "b" OR add_sel = "x" THEN
			IF add_sel = "x" THEN
				LET ship_to = "y" # done without record
				LET s_address.add_type = "y"
			END IF
			LET bill_to = "y"
			LET b_address.add_type = add_sel
			LET add_sel = "s"

			INPUT BY NAME b_address.line1
				 THRU b_address.zipcode WITHOUT DEFAULTS
			AFTER FIELD country
			 CALL find_state(b_address.state, b_address.country)
				RETURNING fsw
				IF fsw = 0 THEN
					NEXT FIELD state
				END IF
			AFTER FIELD zipcode
				IF b_address.zipcode IS NULL THEN
					NEXT FIELD zipcode
				END IF
			END INPUT
		ELSE
			IF add_sel = "s" THEN
				LET ship_to = "s" # needs record
				LET s_address.add_type = "s"
				INPUT BY NAME s_address.line1
					THRU s_address.zipcode
					WITHOUT DEFAULTS
				AFTER FIELD country
				 CALL find_state(
				 	s_address.state, s_address.country)
					RETURNING fsw
					IF fsw = 0 THEN
						NEXT FIELD state
					END IF
				AFTER FIELD zipcode
					IF s_address.zipcode IS NULL THEN
						NEXT FIELD zipcode
					END IF
				END INPUT
				LET add_sel = "b"
			END IF
		END IF
	END WHILE
END FUNCTION

FUNCTION put_address(sw)
	DEFINE sw SMALLINT

	IF sw = 1 THEN
		DELETE FROM address WHERE cust_no = p_cust.cust_no
	END IF

	IF s_address.add_type = "s" THEN
		INSERT INTO address VALUES (
			p_cust.cust_no,
			s_address.add_type,
			s_address.line1,
			s_address.line2,
			s_address.line3,
			s_address.city,
			s_address.state,
			s_address.country,
			s_address.zipcode
		)
	END IF

	INSERT INTO address VALUES (
		p_cust.cust_no,
		b_address.add_type,
		b_address.line1,
		b_address.line2,
		b_address.line3,
		b_address.city,
		b_address.state,
		b_address.country,
		b_address.zipcode
	)
END FUNCTION

FUNCTION find_state(st, ctry)
	DEFINE st CHAR(4)
	DEFINE ctry CHAR(14)

	LET p_states.state = NULL
	LET p_states.country = NULL

	IF st IS NULL THEN
		IF ctry IS NULL THEN
			RETURN 0
		ELSE
			SELECT * INTO p_states.* FROM states
			 WHERE state IS NULL AND country = ctry
		END IF
	ELSE
		IF ctry IS NULL THEN
			SELECT * INTO p_states.* FROM states
			 WHERE state = st AND country IS NULL
		ELSE
			SELECT * INTO p_states.* FROM states
			 WHERE state = st AND country = ctry
		END IF
	END IF

	IF p_states.state IS NULL AND p_states.country IS NULL THEN
		RETURN 0
	END IF

	RETURN 1
END FUNCTION

#
# Get invoice and customer record.
#
FUNCTION get_invoice(i_numb)
	DEFINE i_numb INTEGER

	LET p_invoice.cust_no = NULL	# for callers convience
	SELECT * INTO p_invoice.* FROM invoice
	 WHERE invoice.invoice_no = i_numb
	IF status = NOTFOUND THEN
		RETURN
	END IF

	SELECT * INTO p_cust.* FROM customer
	 WHERE cust_no = p_invoice.cust_no

	DISPLAY BY NAME p_cust.contact
END FUNCTION	

#
# Display a message and get a y or n
#
FUNCTION yn(msg)
	DEFINE msg CHAR(50)
	DEFINE ans CHAR(1)

	WHILE 1=1
		PROMPT msg CLIPPED, " " FOR ans
		IF ans IS NULL THEN
			RETURN "n"
		END IF

		LET ans = downshift(ans)

		IF ans = "y" OR ans = "n" THEN
			RETURN ans
		END IF
	END WHILE
END FUNCTION

FUNCTION is_tnet()
	IF p_invoice.term_no < 5 THEN
		RETURN TRUE
	ELSE
		RETURN FALSE
	END IF
END FUNCTION
