.\"
.\" Adapted from README.Playing -- how to operate the okbridge program
.\" Matthew Clegg.  September 1990.  Updated May 1991, March 1992, May 1992.
.\"
.TH "OKBRIDGE" 6 "4 Aug 1992"
.SH NAME
okbridge \- multi-player networked bridge game
.SH SYNPOSIS
.na
.in +9n
.ti -9n
okbridge
.I position name server
[\fB\-dimR\fP]
[\fB\-p\fP\ \fIportno\fP]
[\fB\-G\fP]
[\fB\-r\fP\ \fIreplay\-file\fP]
[\fB\-b\fP\ \fIboards\-file\fP]
[\fB\-L\fP\ \fIlogfile\fP]
[\fB\-pn, -pe, -ps, -pw\fP]
[\fB\-n\fP\ \fIplayer-name\fP]
[\fB\-s\fP\ \fIserver-name\fP]
.in -9n
.ad
.SH OPTIONS
.IP "\fIposition\fP"
A position-dependent parameter which specifies the seat 
(north, south, east or west) which the local player wishes to occupy.
The \fIposition\fP should be specified as the first letter of the
name of the seat (n, s, e or w).
.IP "\fIname\fP"
A position-dependent parameter which specifies the name by which 
the local player would like to be identified
to other bridge players.  This name may be up to eight characters long.
If it is omitted, then the login name is used.
.IP "\fIserver\fP"
A position-dependent parameter which specifies the Internet name 
or number where the server will be running.
If the local player wishes to be the server, then the word "me" may be
used as the server name.
.IP "\fB-d\fP, \fB-i\fP, \fB-m\fP, \fB-R\fP"
Indicate that the playing and scoring conventions respectively for
Duplicate, IMP, Match point or Rubber bridge should be used.  
These parameters are only relevant for the player
who is the server.  In other words, the server makes the decision
for everyone about the scoring convention that will be used.
If this parameter is omitted, then the playing and scoring conventions
will default to those of rubber bridge.  The -R parameter is suppplied
for the sake of overriding any default which may appear in the .okbridgerc 
file.
.IP "\fB-p\fP \fIportno\fP"
Specifies the port number which will be used for establishing the
network connections.  It is only in unusual circumstances that this
parameter need be specified.
.IP "\fB-G\fP"
Specifies that the Global Player Service (GPS) should \fInot\fP be contacted.
See below for a description of the Global Player Service.
.IP "\fB-b\fP \fIboards-file\fP"
Specifies that the file \fIboards-file\fP contains a sequence of
duplicate deals which should be played.  This is equivalent to the LOAD 
command in the .okbridgerc file.  See the description of email duplicate
bridge below.
.IP "\fB-L\fP \fIlogfile\fP"
Specifies the name of the file to which the results of play will be
written.  This is equivalent to the LOG command in the .okbridgerc file.
.IP "\fB-z#\fP \fI[zhang-logfile]\fP"
Specifes an alternate log file which will be recorded in the format
developed by Shangyou Zhang.  The character '#' should be replaced by
a table number.  If the name of the file is omitted, then the name
"okb_#_rec" will be used.
.IP "\fB-pn, -pe, -ps, -pw\fP"
A position-independent parameter for specifying the player's position.
.IP "\fB-n\fP \fIplayer-name\fP"
A position-independent parameter for specifying the player's name.
.IP "\fB-s\fP \fIserver-name\fP"
A position-independent parameter for specifying the location of
the server.  If the server-name is given as "me", then the local
player will be the server.
.SH "PLAYING"
.PP
.SH "The Okbridge Milieu"
.PP
Okbridge allows people to play bridge together using the Internet.
It is a distributed program, which means that each player runs a
separate instance of the program, and these instances communicate
with each other through the Internet to cooperatively provide the
illusion of a bridge game.  
.PP
At any given moment, there may be many bridge tables currently open,
with players at these tables playing bridge together.  Each table
allows four people to play bridge together.  There may be a number of
additional people at a table who are observing the play.  Each table
has a host, who is called the \fIserver\fP.  While the server is hosting the
table, the table is said to be \fIopen\fP.  The server can be either
observing or playing.  A player who is not a server is said to
be a \fIclient\fP.
.PP
A list of currently open bridge tables is maintained in a worldwide
database called the Global Player Service (GPS).  When a new player
starts the okbridge program, the GPS is contacted and the list of
currently open bridge tables is displayed.  The player then has a
choice of either joining one of the currently open tables or hosting a
new table.
.PP
When four players have joined a table, they must choose \fIseats\fP before
they can begin play.  The seats are labeled north, south, east and
west, and a player chooses a seat by using one of the commands:
/NORTH, /SOUTH, /EAST or /WEST (see the list of commands below).
Also, the server may choose one of several scoring modes (see below).
Play can begin once the seats are all occupied.
.PP
In addition to playing bridge together, the players at a table may
talk with each other and find out a limited amount of information
about each other (see the /WHO and /WHOIS commands below).  There are
a number of options for controlling the format of the display and
input, see e.g., the /BELL, /DEFAULT, /FORMAL, /PROMPT, and /SPEC
commands.  Okbridge provides for very elementary convention
cards (see the /CC and /CCDEF commands below), and it provides some
support for duplicate play (also discussed below).

.SH "Invoking the okbridge Program"
Usually, it is sufficient to start okbridge simply
by typing one of the following two commands:
.IP okbridge
.IP "okbridge -n your-name"
.PP
This will contact the Global Player Service for a list of the currently
playing tables.  The /JOIN (or /CONNECT) command can the be used to join
an open table, or the /SERVE command can be used to begin serving a
new table.
.PP
However, if a game has been arranged in advance, then it is possible
to specify explicitly the name of the server and the seat arrangement.
Suppose that the names of the players are Alex,
Bob, Cathy and Dot.  Alex and Cathy will be one team, while Bob and Dot
will be the other.  They decide that Alex will be north, and Bob will be
east.  Further, they decide that Bob will be the server.  Here is a
list of the commands that each might use to invoke the okbridge program
on their respective (hypothetical) machines:

.nf
.na
 Name    Position  Machine         Command to invoke okbridge
 ----    --------  -------         --------------------------
 Alex    north     a.alaska.edu    okbridge n Alex b.berkeley.edu
 Bob     east      b.berkeley.edu  okbridge e Bob me
 Cathy   south     c.florida.edu   okbridge s Cathy b.berkeley.edu
 Dot     west      d.maine.edu     okbridge w Dot b.berkeley.edu
.ad
.fi

The server (in this case, Bob) should initiate his copy of the program
first.  When a client starts her copy of the program, an initial
display will be presented and the program will attempt to establish a
connection to the server.  During this time, the keyboard will be
unresponsive.  If the client is unable to establish the connection
within 15-30 seconds, then it will give up and display an error
message.  After the connection is established, the program will enter
a talk mode where messages can be exchanged with the other players.
.PP
When the server deals the first hand, each player's screen will be
redrawn, showing his or her cards.  The program prompts each player
for bids and broadcasts the bids to the other players.  After the
bidding is complete, playing mode is entered.  The screen is redrawn
in preparation for play.  Again, the program prompts each player for
plays and broadcasts the plays to the others.  After the playing is
complete, a review of the hand is presented to all of the players and
the scores are updated.  During this time, the players may freely
discuss the hand.  Pressing RETURN twice in succession proceeds to the
next hand.  The program continues in this cycle indefinitely until a
player leaves or until the server gives instructions which alter the
behavior of the program.
.PP
Other clients may join the table at any time.  A client who joins
while a hand is in progress will be able to observe the play and so
the client is said to be an \fIobserver\fP.  The observer may choose
to see the cards of the players by becoming a \fIspectator\fP (see the
/SPEC command below).  Spectators are not allowed to talk to the
players, though.  If one of the players vacates his or her position,
then an observer may take the position.

.SH "The Display and Entering Input"
.PP
Here we give an example of the screen display during bidding.  The numbers
in the left column do not actually appear on the screen -- they are given
for reference purposes only.

.nf
.na
   =======================================================================
 1 OKBRIDGE 1.6A WEST                                         THEY      WE
 2 HAND 1    (0:42)                                          -----   -----
 3 (S) Cathy's BID                                   TRICKS      0       0
 4                                                   VUL        NO      NO
 5      Alex     Bob      Cathy    Dot    |Cathy     ABOVE       0       0
 6      ----     ---      -----    ---    |-----     BELOW       0       0
 7   1  1S       --                       |S A652
 8                                        |H K754
 9                                        |D JT8
10                                        |C J3
11  
12  
13 
14 
15 
16 BID    2s
17 TALK
18  
19 -----------------------------------------------------------------------
20 |MODERATOR: TYPE /HELP FOR INSTRUCTIONS ABOUT THIS PROGRAM            |
21 |NETWORK- YOU ARE NOW SITTING AS WEST.                                |
22 |NETWORK- Alex HAS JOINED THE GAME AS NORTH                           |
23 |NETWORK- Cathy HAS JOINED THE GAME AS SOUTH                          |
24 |NETWORK- Bob HAS JOINED THE GAME AS EAST                             |
   =======================================================================
.ad
.fi

In the upper right corner of the screen (lines 1-6), the scores are
displayed.  The number of tricks taken by each side is displayed on
line 3.  The points above and below the line for each side are displayed
on lines 5 and 6, respectively.  And an indication of which sides are
vulnerable is displayed on line 4.  It has been pointed out to me that
during ordinary bridge play, the scores are only available to the players
between hands and not during the bidding and playing.  I apologize that
the okbridge program is not faithful to the real game in this respect.
.PP
At the beginning of line 2, we can see that this is the first hand
being played at that so far 42 seconds have elapsed in the play of the
hand.  On line 3, we can see that it is now Cathy's turn to bid.  On
lines 5-9, we can see the bids that have been made up to this point.
The display shows that Alex has bid 1 spade, while Bob has passed.
Cathy's cards are displayed to the right of this table of bids.
.PP
Line 16 is the place where the local player's input to the program is
entered.  The word `BID' at the lefthand margin is printed by the program
and indicates that the program is expecting Cathy to type her bid.
The characters `2s' were entered by Cathy, and they indicate that she
intends to bid 2 Spades.  At the time this screen was copied, the
cursor was located just to the right of the letter `s' in `2s'.
If Cathy now presses the return key, then the bid 2 Spades will be
transmitted to the other players.
.PP
Line 17 is the line where the local player may type messages which will
be transmitted to the other players.  When the cursor is on line 17,
any input that the user types will be transmitted to the other players
as a conversational message.
The user may switch between playing and talking by pressing the tab key.
.PP
Lines 20 through 24 display messages from the program and from other
players.  Each message is of the form `source: text', where `source'
is either MODERATOR or the name of one of the players.  Messages from
the MODERATOR give information about the internal state of the program.
.PP
When entering input, the backspace and delete keys will erase the last
character typed.  The escape key erases the entire input line.  And
pressing control-R causes the entire screen to be redrawn from scratch.
Always press return to have your input transmitted to the other players.
.PP
There is a `default' input option embedded in the input processor.
When the input line is empty, pressing return results in the display
of a `default' input.  When in bidding mode, the default input is
always `pass'.  When in playing mode, the default input is the lowest
ranked card which follows suit.  If there are two or more suits from
which a card may be played, then no default is made available.
Pressing return a second time (i.e., after
the default input has been displayed) causes the default input to be
transmitted to the other players.  Sometimes in playing mode there is
only one legal input.  In this case, this input is displayed
automatically -- you need only press return to transmit it to the
other players.
.PP
In addition, there are a number of control keys which have been
programmed to provide abbreviations for commands:

.nf
.na
 ^A   Alerts partner's last bid.
 ^B   When used during the play of a hand, the bidding is displayed
      for review.
 ^C   Quits the program.  (Confirmation is first requested.)
 ^D   Toggles the default input mode.  See the /DEFAULT command.
 ^G   Toggles the bell.  See the /BELL command.
 ^P   Toggles the prompt.  See the /PROMPT command.
 ^R   Refreshes the screen.
 ^T   Switches between talking and playing.
 ^U   Erases the current input.
 ^W   Sends a wakeup signal to your partner.
 ^X   Exits the program immediately (only if compiled in debug mode).

 TAB  Switches between talking and playing (same as ^T).
.ad
.fi

.SH "Bidding"
.PP
A contract bid is specified by giving the level and the trump suit.
The level is given as an integer in the range 1-7, while the trump
suits are of course clubs, diamonds, hearts, spades and no trump. 
However, the name of the trump suit is abbreviated to its initial
letter.  Thus, here are some examples of legal contract bids:
.IP  "1c, 1d, 1h, 1s, 1n, 2c, 2d, 2h, 2s, 2n, 3c, 3d, 3h, 3s, 3n, ..."
.IP  "A passing bid is given by entering `pass' or just `p'."
.IP  "A doubling bid is given by entering `double' or `X'."
.IP  "A redoubling bid is given by entering `redouble' or `XX'."
.PP
A bidder may alert his or her bid by typing an exclamation point
after the bid (e.g., 1c!).  This alert is broadcast to the opponents
but not to the partner of the alerting bidder.  Alternatively, the
partner of the bidder may alert the bid by using the /ALERT command
or the control-A key.  See the /ALERT command below.

.SH "Playing"
.PP
The name of a card is specified by giving its suit and then its rank.
The honor cards `ten', `jack', `queen', `king' and `ace' are
abbreviated respectively to T, J, Q, K and A.  Thus, the cards in
the deck are enumerated as

.nf
.na
    C2, C3, C4, C5, C6, C7, C8, C9, CT, CJ, CQ, CK, CA
    D2, D3, D4, D5, D6, D7, D8, D9, DT, DJ, DQ, DK, DA
    H2, H3, H4, H5, H6, H7, H8, H9, HT, HJ, HQ, HK, HA
    S2, S3, S4, S5, S6, S7, S8, S9, ST, SJ, SQ, SK, SA
.ad
.fi

It is allowable to write the rank first and then the suit, e.g., TC
instead of CT.

.SH Commands
.PP
There are a number of special commands that are available in the okbridge
program.  These special commands are invoked by entering at the beginning
of a line a slash `/', the name of the command, and perhaps some
parameters.  Here is a brief list of the available commands:

.IP "/ALERT"
Alerts your partner's last bid.  If you are playing in FORMAL mode,
the alert is displayed to your opponents only.  Otherwise, the alert
will be displayed to everyone.  Same as ^A.

.IP "/AUTOPASS [ON|OFF]"
During \fIPractice\fP mode, this command controls whether or not PASS bids
are automatically supplied by the moderator for absent players.  See the
description of \fIPractice\fP mode below.

.IP "/BELL [ON|OFF]"
By default, the okbridge program rings the terminal's bell whenever
it requests input from you.  However, this can be disabled by
typing /BELL OFF.  The state of the bell can be toggled with ^G.

.IP "/CC [NS|EW|MY|BOTH]"
Displays the convention card of the specified team(s).
By default, displays the convention card of the opponents.

.IP "/CCDEF [<Convention Card Name>] [<Convention-Card>]"
Stores or displays a named convention card in the internal database.
If both parameters are omitted, then displays all of the named 
convention cards.  If only the name of the convention card is
specified, then displays that convention card.  Otherwise,
enters a new definition for a named convention card.

.IP "/CLAIM [\fIn\fP]"
This command claims \fIn\fP additional tricks for the declarer.
If \fIn\fP is omitted, then all remaining tricks are claimed.
If \fIn\fP is negative, then this many -\fIn\fP tricks are conceded.
All hands are revealed to the defenders, and they are asked whether
or not they agree to the declarer's request.
If both agree, then the hand is ended early.  This command can
be used only by the declarer.

.IP "/CLS"
Clears all of the messages from the talk area of the display.

.IP "/DEFAULT [ON | OFF]"
This command controls whether or not defaults will be provided
for bids, plays and questions.  This mode can be toggled with ^D.

.IP "/EMAIL <your-email-address>"
Specifies your email address.  Other players will then be able to
find out your email address by using the /WHOIS command.

.IP "/FULLNAME <your-full-name>"
Specifies your full name.  Other players will then be able to find
out your name by using the /WHOIS command.  This name is also displayed
by the GPS.

.IP "/HELP [topic]"
Provides help about how to use Okbridge.
Type /HELP alone to obtain general help.

.IP "/LHB <message>"
Sends a message to the person who appears to the left of you in the
bidding display.  Same as the /RHO command.

.IP "/LHO <message>"
Sends a message to the person who will play or bid immediately
after you.  Same as the /RHB command.

.IP "/LOG [\fIfilename\fP]"
Typing /LOG \fIfilename\fP causes this hand and subsequent hands
to be written to the file with name \fIfilename\fP.  Omitting
\fIfilename\fP causes the current log file to be closed.
Adding a plus sign '+' to the beginning of \fIfilename\fP causes
the playing record to be appended to the end of the file.

.IP "/NAME <new-name>"
Changes your name to <new-name>.

.IP "/OPP <message>"
Sends a message which will be seen only by the opponents.

.IP "/PAUSE"
During bidding or play, this restores the entire screen to a talk
display.  This is useful for seeing messages which have scrolled out
of the small conversation area which appears during bidding and play.

.IP "/PING"
Sends an invisible message to each of the other players, which is
automatically echoed.  Reports the round-trip communication time.

.IP "/PRACTICE [ON|OFF]"
Turns on or off the \fIPractice\fP mode of play.  This mode allows
a partnership to practice bidding and the planning of play.  See the
description of \fIPractice\fP mode below.

.IP "/PROMPT [ON|OFF]"
By default, the dummy is asked to press RETURN after the end
of each trick.  This allows the dummy to see each trick as
it is played.  This prompting can be disabled by typing
/PROMPT OFF.  The prompt mode can be toggled with ^P.

.IP "/QUIT"
Terminates the program.

.IP "/REVEAL [<player-name> | NORTH | EAST | SOUTH | WEST"
| NE | NS | NW | SE | SW | EW]
.IP
This command can only be used by an observer or the dummy.  In this
case, the player enters \fIspectator\fP mode and the named hands are
revealed.  In spectator mode, the observer can have complete
information about the game.  Spectators may talk to each other, but
they may not talk to the players or to other observers who are not
spectators.  Spectator mode is not available in formal play.  If the
name of the player is omitted, then all hands are revealed.  (This
command is actually the same as the /SPEC command.)

.IP "/REVIEW"
Displays the bidding for review.  This is intended to be used
during the playing mode.  This command can be abbreviated with ^B.

.IP "/RHB <message>"
Sends a message to the person who appears to the right of you in
the bidding display.  Same as the /LHO command.

.IP "/RHO <message>"
Sends a message to the person who bids or plays immediately before
you.  Same as the /LHB command.

.IP "/SEAT NORTH|EAST|SOUTH|WEST|OBS"
.IP "/EAST, /NORTH, /OBS, /OBSERVER, /SOUTH, /WEST"
.IP
Selects a seat.  Can only be used before the first hand or between
hands.  Only one person may sit in the seats north, east, south, west,
but there may be many observers.

.IP "/SETCC [<your-convention-card>]"
Enters one line of text as your convention card.  This card will
then be announced to your partner and the opponents as the convention
card for your team.  Omitting convention card from this command will
cause your current convention card to be announced to your partner
and opponents.  If the convention card is just a single word, then
the list of convention cards specified in the .okbridgerc file with
the CCDEF command is searched for a matching entry.  If a matching
entry is found, then the corresponding convention card is used.

.IP "/SPEC [<player-name> | NORTH | EAST | SOUTH | WEST"
| NE | NS | NW | SE | SW | EW]
.IP
This command can only be used by an observer or the dummy.  In this
case, the player enters \fIspectator\fP mode and the named hands are
revealed.  In spectator mode, the observer can have complete
information about the game.  Spectators may talk to each other, but
they may not talk to the players or to other observers who are not
spectators.  Spectator mode is not available in formal play.  If the
name of the player is omitted, then all hands are revealed.  (This
command is actually the same as the /REVEAL command.)

.IP "/WAKEUP [<player-name> | ALL]"
Sends a wakeup signal to the named player, or to all players if
ALL is specified.  The wakeup signal rings the terminal bell and
prints the words "WAKE UP" in the conversation area.  If the name of the
player is omitted, then the signal is sent to your partner.
Pressing ^W is the same as typing /WAKEUP.

.IP "/WHO"
Gives a short list of the other players and their respective seats.

.IP "/WHOIS [<player-name>]"
Inquires about a specific player.  If the player has listed his/her
full name and email address in the .okbridgerc file, then this
information is given.  If <player-name> is omitted, then inquires
about both of the opponents.

.IP "/ZLOG [filename]"
This command is similar to the /LOG command in that it also opens
a log file, but the format of the log file is more compact.


.PP
.SH Server Commands

In addition, there are a number of commands which can be used only
by the server.  

.IP "/ASSIGN <player-name> NORTH|EAST|SOUTH|WEST|OBS"
Assigns a player to a given seat.  Can only be used before the
first hand has been dealt or between hands.

.IP "/DISCONNECT <player-name>"
Closes the connection to the named player.  
<player-name> can either be the name of a player (e.g., Worf)
or the name of a position (e.g., SOUTH).

.IP "/FORMAL [OFF|ON]"
Specifies whether formal playing rules will be used or queries which
playing rules are currently use.  In formal play, talk messages
are displayed only to the opponents, alerts are not displayed to the
partner of the alerter, and the dummy is not revealed to anyone
until the opening lead has been made.

.IP "/RESET"
Resets the program to its initial state. 

.IP "/SCORE RUBBER|DUPLICATE|MP|IMP|CLEAR"
Selects a scoring mode.  If the selected scoring mode is different from
the current scoring mode, then skips the current hand.  Using '/SCORE CLEAR'
will clear the scoreboard.

.IP "/SKIP [\fIn\fP]"
Ends the current hand immediately, without recording a score for it.
If we are the server, then the parameter \fIn\fP specifies the number 
of hands to skip (including the current one).
This command is useful in case the connection to one of the players is lost.


.PP
.SH The Global Player Service

The Global Player Service is a worldwide database of currently playing
bridge tables.  Using the GPS, it is possible to quickly locate other
people wishing to play bridge.  The following commands are for
accessing the GPS:

.IP "/TABLES"
Lists the currently playing tables.

.IP "/JOIN [<name>]"
Joins the table being served by <name>.  If <name> is omitted,
then the first table in the list provided by the /TABLES command
is joined.

.IP "/SERVE [<port-number>]"
Begins serving a table.  The table will be advertised to the GPS
automatically, so that other players may join.  If <port-number>
is omitted, then 1729 will be chosen by default.

.PP
The Global Player Service also supports a form of duplicate play.
It maintains a database of boards which have been played by other
foursomes.  These boards can be downloaded and played again, 
and match point scores will then be computed.  The following commands
are relevant to GPS duplicate:

.IP "/DUP [MP|IMP|END]"
Used by the server to initiate (or end) GPS duplicate play.  The MP
parameter is specified to play match point boards, while the IMP parameter
is given to play IMP boards.  The default is IMP play.  After each
board is downloaded and played, you will be able to see the results
of play by other foursomes.

.IP "/RESULTS [<results-file>]"
Downloads all of the GPS duplicate boards which have been played by
the local player.  The results of play for each board are then displayed.
If <results-file> is specified, then the results are saved to the given
file in email duplicate format.  A more verbose record of the play can
then be produced with the oktally command.  WARNING:  If you play often,
then you should specify the <results-file> and examine it using oktally.

.IP "/SCOREBOARD"
Displays the GPS duplicate scoreboard.  The top ten players in match point
play and in IMP play are listed.

.PP
In addition, there are the following GPS-related commands:

.IP "/PLAYERS [<name>]"
Lists the names of all of the players currently at the table
served by <name>.  If <name> is omitted, then lists all of the
players at all tables.

.IP "/CONNECT <host_name> [<port_number>]"
Connects to the table being served at <host_name> with port <port_number>.
If <port_number> is omitted, then 1729 is assumed.

.IP "/PERISH"
Disconnects from the GPS.  If we are serving a table, this table
is deleted from the GPS database.

.IP "/PUBLISH"
Reconnects to the GPS.  If we are serving a table, this table is
re-advertised to the GPS.

.SH Partnership Practice Mode

The \fIPractice\fP mode is based on a suggestion of Alan Truscott.  In
this mode, two (or more) players may practice their bidding.  The
moderator (OKbridge) supplies PASS bids for players which are absent.
After the hand has been bid, it is revealed to all of the players.
The players may then discuss and play it.

To enter \fIPractice\fP mode, the server uses the command '/PRACTICE ON'.
This will deal a new hand and allow the players to bid it.  During the
bidding, OKbridge will supply "PASS" bids for absent players.  Thus, if
North-South is practicing and East-West are absent, then a "PASS" will
be supplied by OKbridge automatically each time it is East or West's turn
to bid.

This is usually the preferred behavior.  However, for three-player practice,
it may be preferable to allow the third player to bid both hands for one side, 
say East-West.  In this case, the server should use the '/AUTOPASS OFF'
command.  This command will disable PASS bids from being supplied by
the moderator.  The third player can then bid for both East and West by
switching seats with the /EAST and /WEST commands.

After a contract has been reached, all four hands will be revealed to
each of the players.  The players will be able to discuss the bidding
together.  They can also play out the hand.  Each player is allowed to
play from anyone's hand.  That is to say, if it is West's turn to
play, anyone may select which one of West's cards to play.

The /CLAIM (or /SKIP) command can be used to end the hand early.
During \fIPractice\fP mode, any player may use the /CLAIM command to
specify the number of tricks to be claimed \fIfor the declarer.\fP
No confirmation is requested for claims made during \fIPractice\fP mode.
After the hand ends, the score is computed and displayed.


.SH Scoring
.PP
The following tables give a basic outline of how okbridge computes
the scores.  It is partially derived from the documentation supplied with
the bridge program written by Yuan and Chu.
.IP "Trick Score (below the line)"
If the contracting team succeeds in making their contract,
then the base score for the hand is computed according to
the following chart.  

.na
.nf
  Spades or Hearts     30 per trick | If doubled:
  Diamonds or Clubs    20 per trick |    multiply by 2
  Notrump        40 for first trick | If redoubled:
       30 for each additional trick |    multiply by 4
.fi
.ad

.IP
For rubber bridge, the score is computed
according to the number of tricks bid.  For other scoring
methods, the score is computed according to how many tricks
were actually made.

.IP
In a doubled contract in rubber bridge, overtricks are
scored at 100 points each if not vulnerable and 200 points
each if vulnerable.  In a redoubled contract in rubber bridge,
overtricks are scored at 200 and 400 respectively.

.IP
In rubber bridge, a game is scored if 100 points or more are
accumulated below the line.  The scoring side then becomes
vulnerable and wins the rubber if they win a second game.
In other forms of bridge, the vulnerability proceeds according
to a rotation which cycles every 16 hands.  

.IP Bonuses
For rubber bridge, there is a bonus for winning the rubber,
which is scored as follows: 

.nf
.na
  Rubber bonus:   500 if you win two games out of three
                  700 if you win the only two games
.ad
.fi
.IP
For all forms of bridge, there is a bonus for making a slam:

.nf
.na
                        Not Vulnerable   Vulnerable
  Slam Bonus:  Small Slam      500           750
               Grand Slam     1000          1500
.ad
.fi
.IP
In rubber, there is a bonus if the contracting
side has enough honor cards in the trump suit:

.nf
.na
  Honors:  4 trump honors in one hand          100
           5 trump honors in one hand          150
           4 aces in one hand at notrump       150
.ad
.fi
.IP
In non-rubber bridge, there is a 300 point bonus for bidding
and making a game when not vulnerable.  The bonus is 500 points
if vulnerable.
.IP
Making Doubled (or redoubled) Contract:	 50 points
.IP
Penalties (above the line):

.nf
.na
                Undoubled              Doubled
             Not Vul.   Vul.      Not Vul.   Vul.
  Down 1        50      100         100      200
  Down 2       100      200         300      500
  Down 3       150      300         500      800
  Down 4       200      400         700     1100
  Down 5       250      500         900     1400
  Down 6       300      600        1100     1700
  Down 7       350      700        1300     2100
  Down 8       400      800        1500     2500
   ...         ...      ...         ...      ...
.ad
.fi

Note that for non-rubber bridge, the penalty sequence for doubled
not vulnerable is 100, 300, 500, 800, 1100, etc.
If redoubled: multiply the doubled penalty by two.

.IP "IMP scoring"
The IMP (International Match Point) scoring system is based on
comparing the results of play for exactly two tables.  In this system,
the difference between the score of your team and the other team who
played the same cards as you is computed and then converted to a
number of IMPs according to a table.

.nf
.na
  Duplicate score  IMP pts     Duplicate score  IMP pts
  ---------------  -------     ---------------  -------
    <  20             0             750            12 
       50             1             900            13
       90             2            1100            14
      130             3            1300            15
      170             4            1500            16
      220             5            1750            17
      270             6            2000            18
      320             7            2250            19
      370             8            2500            20
      430             9            3000            21
      500             10           3500            22
      600             11           4000            23
                                   above           24
.ad
.fi
If more than two tables have played a board, then the IMP score
assigned to a team for the play of a board is the average of all of the
pairwise IMP scores.  If only one table has played a board, then the
IMP score assigned for the play of the board is determined using the
Mono IMP system described by Gary Greene in the May/June 1990 issue
of \fIBridge Today.\fP  Greene describes the Mono IMP system as follows:

"Mono-IMP scoring is based on an average expected score for each side's
high-card-point holding.  The table below shows the average score that
a given number of high-card points will produce in the long run.  I
have compiled statistics from over 10000 hands from a lunchtime game
played over the last five years, and they indicate that these values
are a realistic long-term average."

.nf
.na
     HCP   Vul   NV          HCP   Vul   NV
     ---   ---   ---         ---   ---   ---
     20    0     0      |    29    750   550  
     21    50    50     |    30    800   600  
     22    100   100    |    31    950   700  
     23    150   150    |    32    1100  800  
     24    300   200    |    33    1400  950  
     25    450   300    |    34    1500  1050 
     26    600   400    |    35    1650  1150 
     27    650   450    |    36    1850  1300 
     28    700   500    |    37+   2100  1500 
.ad
.fi

The number of Mono-IMPs awarded is determined by taking the difference between
the score actually made and the predicted score as given in the above table.
If the difference is less than 600 (in either direction), then the number
of Mono-IMPs awarded is equal to the difference divided by 50 and rounded
to the nearest half point.  If the difference is greater than 600, then the
number of Mono_IMPs awarded is equal to 12 plus 1 point for each 100
beyond 600, again rounded to the nearest half point.

.IP "Match Point Scoring"
The Match Point scoring system compares the results of many tables of
play.  A partnership receives one match point for each pair who played
the same hands and did worse than them and a half point for each pair
who scored exactly the same.  In OKbridge, match point scores are
normalized to lie between 0 and 1.  The number of match points which a
team receives is divided by the total number of match points which
could have been won.  Thus, normalized match points represent a per
cent ranking among the other teams who played the board.  If a board
has been played by only one table, then a simulated match point score
is assigned.  The simulated match point score is 1 if the Mono-IMP
score is 1 or greater, 0 if the Mono-IMP score is -1 or less, and 0.5
otherwise.

.SH "Playing Duplicate Bridge"
.PP
In addition to the GPS duplicate mode described above, okbridge allows
boards to be read from and written to files.  These files can be mailed
to other foursomes for play, allowing for 'email duplicate' matches.
.PP
To begin email duplicate play, the server at the first table uses the
/SAVE command to save a set of boards after they have been played.
The /SAVE command creates a record of the boards along with a complete
record of how they were played.  This file can then be mailed to others
for play.
.PP
To replay a set of boards which have been saved, the server
uses the /LOAD command to load the boards.  This loads the boards
from the file into memory and immediately begins playing them.
After the boards have been played, the server can /SAVE the boards
back to a file.  This will save the previous results of play along
with the new results.
.PP
Alternatively, a sequence of boards can be replayed by using the
/REPLAY command.  This first causes the boards to be read into the
program for play.  After they have been played, they are then
automatically saved along with the results back to the file from
which they were read.
.PP
To create a unplayed set of shuffled boards, use the
.IR okshuffle (6)
program.  Also, to merge a number of boards that have already been
played, you can use the
.IR oktally (6)
program. See their man pages for more details.

.SH "The .okbridgerc initialization file"
.PP
It is possible to store a number of default settings into a
file which will be read at initialization.  When the
program starts, the current working directory is first searched for a
file named ".okbridgerc".  If no file is found, then the home
directory is searched for the same file.  For an example of an .okbridgerc
file, see the file in this distribution named
"okbridgerc".  (Note that it is incorrectly named -- to be read by the
okbridge program, it should be named ".okbridgerc").

After the ".okbridgerc" file is read, the program then searches for
a file named ".okdefaults".  This file is of the same format as 
the ".okbridgerc", and any settings file override those found in
the ".okbridgerc" file.  When okbridge terminates, it may rewrite
the ".okdefaults" file, saving any settings which may have been
changed during the play of the program.

.PP
Each line in the ".okbridgerc" file is either a comment line or 
a (field, value) pair.  Comment lines begin with the pound sign '#' character.
Field, value pairs are of the format:

.nf
.na
          <Field-name>  <value>
.ad
.fi

The fields which are currently recognized are as follows:

.IP AUTOSAVE
This field specifies that the ".okdefaults" file should be rewritten
when okbridge terminates.  If this field is not present, then 
the ".okdefaults" file will not be changed.

.IP "BELL ON | OFF"
When requesting input (a bid or a play), the terminal's bell is rung
by default.  However, this can be disabled by specifying 'BELL OFF'.
This has the same effect as the '/BELL OFF' command.

.IP "CC \fIconvention-card\fP"
This is a one line description of the conventions which you like to use. 

.IP  "CCDEF \fIConvention-Card-Name\fP \fIConvention-Card\fP"
Stores a named convention card in the internal database.
This convention card can then be called up during the play of the
program with the command '/CC <card-name>'.

.IP  "DEFAULT ON | OFF"
This controls whether or not default inputs will be provided
for bids, plays and questions.

.IP  "EMAIL \fIemail-address\fP"
This should be your email address.  It is currently used only for
identification purposes.

.IP  "FULLNAME \fIyour-full-name\fP"
This field is used only for identification purposes, and should
contain your full name as you would wish it to be displayed to others.

.IP "GPS  ON | OFF"
Controls whether or not we will contact the Global Player Service
automatically when the program starts up.

.IP "GPS_IP \fIip-name-or-number-of-GPS\fP [\fIGPS-port\fP]"
Specifies the Internet number and port of the GPS.

.IP "HELPFILE \fIdirectory-name\fP"
This field specifies the location of the okbridge help file.

.IP "LOAD \fIemail-duplicate-filename\fP"
This field is only valid if the position is north and the scoring mode
is email duplicate.  In this case, okbridge will automatically read a
set of email duplicate boards from the named file.

.IP "LOG \fIfilename\fP"
If this statement is present in the startup file, then the hands will
automatically be logged to the given filename.  If the first character
of \fIfilename\fP is a plus sign '+', then the log is appended to
\fIfilename\fP.  Otherwise, \fIfilename\fP is overwritten.

.IP "MY_IP  \fIlocal-IP-number\fP"
This field specifies the IP number of the local player.
Usually, okbridge can determine the IP number correctly,
but on some systems, this field must be used.

.IP "NAME \fIlocal-player-name\fP"
This field specifies the name that will be used to identify the local
player to the other players.  If both the NAME field and the POSITION
field are present in the .okbridgerc startup file, then the
corresponding parameters can be omitted from the okbridge command
line.  In this case, the SERVER field should also be specified in 
the .okbridgerc file.

.IP "PORT \fIpositive-integer\fP"
This field specifies the internet port number that will be
used for communications with the server.  It is usually not
necessary to specify a port number.

.IP "PROMPT NO | YES"
The value of this field is only relevant in hands where the local
player is the dummy.  In this case, the dummy is ordinarily prompted
to press RETURN at the end of each trick.  This allows the dummy to
see the cards that are played as they are played.  However, if 'PROMPT
NO' is specified, then the dummy will not be prompted.

.IP "SCORING RUBBER | CHICAGO | DUPLICATE | EMAIL | IMP"
This field is only relevant if the local player is north.  In this
case, the SCORING field determines the type of scoring that will be
used by default in the game.

.IP "SEAT NORTH | EAST | SOUTH | WEST"
This field specifies the local player's position.  If both the NAME
field and the POSITION field are present in the .okbridgerc startup
file, then the corresponding parameters can be omitted from the
okbridge command line.  In this case, the SERVER field should also be
specified in the .okbridgerc file.

.IP "SERVER ME | \fIinternet-name-or-number\fP"
If the value of this field is 'ME', then the local player will assume
the role of server.  If the value of this field is anything else, then
it is interpreted as an internet name or number of the machine where
the server is running.

.IP  "ZLOG \fIfilename\fP"
This command is similar to the LOG command, in that it opens
a file for recording play, but the format of the file is more concise.

.SH "FILES"
".okbridgerc"	- user defaults file
.SH "SEE ALSO"
okshuffle(6),
oktally(6)
.SH AUTHOR
.PP
Matthew Clegg, mclegg@cs.ucsd.edu.
.PP
Man pages adapted by George Ferguson,
.br
ferguson@cs.rochester.edu.
