/* filename	: partact.c
 * purpose	: set partition type number
 * author	: Randy Wright
 * Copyright	: ((C)) Copyright 1993 Randy Wright
 *
 * $LOG$
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/fdisk.h>
#include <fcntl.h>
#include <errno.h>

main(argc,argv)
int argc;
char **argv;
{
char xdev[80], inbuf[80];
int i, fd, newpart, newtype;
HDISK_S hd;
FDISK_S *fptr;

if( argc < 3 )
	{
	if( isatty(0) )
		{
		printf( "Xdevice : "); fflush(stdout);
		gets(xdev);
		printf( "Partition to re-type: ");  fflush(stdout);
		newpart = atoi( (gets(inbuf)) );
		printf( "\n0	 Empty\n" );
		printf( "1	 MS-DOS, 12-bit FAT\n" );
		printf( "2	 Xenix\n" );
		printf( "4	 MS-DOS, 16-bit FAT\n" );
		printf( "5	 MS-DOS, extended partition\n" );
		printf( "6	 MS-DOS, large filesystem\n" );
		printf( "9	 Coherent\n" );
		printf( "10	 Coherent swap partition\n" );
		printf( "130	 Linux efs2 swap\n" );
		printf( "131	 Linux efs2\n" );
		printf( "165	 NetBSD\n" );
		printf( "\ntype number to use: "); fflush(stdout);
		newtype = atoi( (gets(inbuf)) );
		}
	else exit(1);
	}
else
	{
	strncpy(xdev, argv[1], 80 );
	newpart = atoi( argv[2] );
	}


if( (fd = open( xdev, O_RDWR)) < 0 )
	{
	printf( "Can't open %s\n", xdev );
	exit(1);
	}

if( (lseek( fd, 0L, 0 )) < 0 )
	{
	printf( "can't lseek to begining of drive %s\n", xdev );
	close(fd);
	exit(1);
	}

if( (read(fd, &hd, 512)) != 512 )
	{
	printf( "bad read of %s\n", xdev );
	perror("");
	close(fd);
	exit(1);
	}

if( hd.hd_sig != 0xaa55 )
	{
	printf( "bad signature.\n" );
	exit(1);
	}

printf( "signature : 0x%x\n", hd.hd_sig );


for( i=0, fptr = &hd.hd_partn[0]; i < 4;  i++, fptr++ )
	{
	if( i == newpart )
		{
		printf( "parition %d was %d\n", i,  fptr->p_sys );
		fptr->p_sys = (unsigned char)newtype;
		printf( "parition %d set to %d\n", i, fptr->p_sys );
		}
	else
		{
		printf( "parition %d is %d\n", i, fptr->p_sys );	
		}
	}

if( (lseek( fd, 0L, 0 )) < 0 )
	{
	printf( "can't lseek to begining of drive %s\n", xdev );
	close(fd);
	exit(1);
	}

if( (write(fd, &hd, 512)) != 512 )
	{
	printf( "bad read of %s\n", xdev );
	perror("");
	close(fd);
	exit(1);
	}

close(fd);
exit(0);
}
