/*
   Copyright (c) 1994 by Harry Pulley.

   May be freely distributed and modified provided that this copyright notice
   is not removed.  I am not responsible for any damages caused in any way,
   shape or form.
*/

#ifndef __SYS_SBIOCTL_H__
#define __SYS_SBIOCTL_H__

#ifndef SBP_MAJOR
#define SBP_MAJOR	21
#endif

#ifndef PAGE_SIZE
#define PAGE_SIZE	4096
#endif

#ifndef BUF_SIZE
#define BUF_SIZE	65536
#endif

struct sb_ioctl
{
	unsigned long	buffer_addr;
	unsigned long	buffer_len;
	unsigned short	parameter;
	unsigned short	*status;
};

#define MAP_BUFFER0	0
#define MAP_BUFFER1	1
#define SET_TIMECONST	2
#define PLAY_BUFFER0	3
#define PLAY_BUFFER1	4
#define RECORD_BUFFER0	5
#define RECORD_BUFFER1	6
#define SPKR_ON		7
#define SPKR_OFF	8
#define DMA_HALT	9
#define DMA_CONT	10
#define DMA_STATUS	11
#define RESET_DSP	12
#define DMA_COUNT	13
#define PCUE_BUFFER0	14
#define PCUE_BUFFER1	15
#define RCUE_BUFFER0	16
#define RCUE_BUFFER1	17
#define DSP_VER		18

/* normal speed time constant calculation */

#define time_const(x)	(256L-(1000000L/x))

#define hs_time_const(x)	(((65536-(256000000/x))&0xff00)>>8)

#endif
