#
# Install shell script for minicom and friends.
#
NAME="`whoami`" 2>/dev/null
if [ "$NAME" = "" ]
then
	echo "No whoami? Hmmm.. must be Coherent.. Trying \"who am i\""
	NAME="`who am i | cut -d' ' -f1`"
fi

if test "$NAME" != root
then
	echo "You must be root to install minicom."
	exit 1
fi

if test $# != 3
then
	echo "Usage: install.sh libdir bindir mandir"
	exit 1
fi

if test ! -d $1
then
	echo "$1: No such directory"
	exit 1
fi

if test ! -d $2
then
	echo "$2: No such directory"
	exit 1
fi

if test ! -d $3
then
	echo "$3: No such directory"
	exit 1
fi

if test -f minicom
then
	echo "Installing minicom in $2"
	cp minicom $2/minicom
	chmod 4755 $2/minicom
	chown root $2/minicom
	chgrp bin $2/minicom
fi

if test -f runscript
then
	echo "Installing runscript in $2"
	test -f /usr/bin/chmem && chmem 8192 runscript
	cp runscript $2/runscript
	chmod 755 $2/runscript
	chown bin $2/runscript
	chgrp bin $2/runscript
fi

if test -f keyserv
then
	echo "Installing keyserv in $1"
	test -f /usr/bin/chmem && chmem 8192 keyserv
	cp keyserv $1/keyserv
	chmod 755 $1/keyserv
	chown bin $1/keyserv
	chgrp bin $1/keyserv
fi

echo "Installing manpages in $3"
for i in minicom.1 runscript.1
do
	cp $i $3
	chmod 644 $3/$i
	chown bin $3/$i
	chgrp bin $3/$i
done

exit 0
