/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestBiDimensionalWidget.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
//
// This example tests the vtkBiDimensionalWidget.

// First include the required header files for the VTK classes we are using.
#include "vtkSmartPointer.h"
#include "vtkBiDimensionalWidget.h"
#include "vtkBiDimensionalRepresentation2D.h"
#include "vtkImageActor.h"
#include "vtkImageData.h"
#include "vtkImageMapper3D.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkInteractorStyleImage.h"
#include "vtkVolume16Reader.h"
#include "vtkImageShiftScale.h"
#include "vtkImageActor.h"
#include "vtkCommand.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkTestUtilities.h"
#include "vtkTransform.h"

const char BiDimensionalWidgetEventLog[] =
"# StreamVersion 1\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"EnterEvent 287 155 0 0 0 0 0\n"
"MouseMoveEvent 92 96 0 0 0 0 0\n"
"LeftButtonPressEvent 92 96 0 0 0 0 0\n"
"RenderEvent 92 96 0 0 0 0 0\n"
"LeftButtonReleaseEvent 92 96 0 0 0 0 0\n"
"MouseMoveEvent 92 96 0 0 0 0 0\n"
"RenderEvent 92 96 0 0 0 0 0\n"
"MouseMoveEvent 93 96 0 0 0 0 0\n"
"RenderEvent 93 96 0 0 0 0 0\n"
"MouseMoveEvent 93 97 0 0 0 0 0\n"
"RenderEvent 93 97 0 0 0 0 0\n"
"MouseMoveEvent 93 98 0 0 0 0 0\n"
"RenderEvent 93 98 0 0 0 0 0\n"
"MouseMoveEvent 93 99 0 0 0 0 0\n"
"RenderEvent 93 99 0 0 0 0 0\n"
"MouseMoveEvent 94 100 0 0 0 0 0\n"
"RenderEvent 94 100 0 0 0 0 0\n"
"MouseMoveEvent 95 101 0 0 0 0 0\n"
"RenderEvent 95 101 0 0 0 0 0\n"
"MouseMoveEvent 96 102 0 0 0 0 0\n"
"RenderEvent 96 102 0 0 0 0 0\n"
"MouseMoveEvent 99 104 0 0 0 0 0\n"
"RenderEvent 99 104 0 0 0 0 0\n"
"MouseMoveEvent 101 106 0 0 0 0 0\n"
"RenderEvent 101 106 0 0 0 0 0\n"
"MouseMoveEvent 119 118 0 0 0 0 0\n"
"RenderEvent 119 118 0 0 0 0 0\n"
"MouseMoveEvent 133 127 0 0 0 0 0\n"
"RenderEvent 133 127 0 0 0 0 0\n"
"MouseMoveEvent 140 137 0 0 0 0 0\n"
"RenderEvent 140 137 0 0 0 0 0\n"
"MouseMoveEvent 145 145 0 0 0 0 0\n"
"RenderEvent 145 145 0 0 0 0 0\n"
"MouseMoveEvent 151 155 0 0 0 0 0\n"
"RenderEvent 151 155 0 0 0 0 0\n"
"MouseMoveEvent 156 167 0 0 0 0 0\n"
"RenderEvent 156 167 0 0 0 0 0\n"
"MouseMoveEvent 158 176 0 0 0 0 0\n"
"RenderEvent 158 176 0 0 0 0 0\n"
"MouseMoveEvent 159 184 0 0 0 0 0\n"
"RenderEvent 159 184 0 0 0 0 0\n"
"MouseMoveEvent 159 190 0 0 0 0 0\n"
"RenderEvent 159 190 0 0 0 0 0\n"
"MouseMoveEvent 162 195 0 0 0 0 0\n"
"RenderEvent 162 195 0 0 0 0 0\n"
"MouseMoveEvent 166 201 0 0 0 0 0\n"
"RenderEvent 166 201 0 0 0 0 0\n"
"MouseMoveEvent 164 202 0 0 0 0 0\n"
"RenderEvent 164 202 0 0 0 0 0\n"
"MouseMoveEvent 164 205 0 0 0 0 0\n"
"RenderEvent 164 205 0 0 0 0 0\n"
"MouseMoveEvent 164 207 0 0 0 0 0\n"
"RenderEvent 164 207 0 0 0 0 0\n"
"MouseMoveEvent 166 209 0 0 0 0 0\n"
"RenderEvent 166 209 0 0 0 0 0\n"
"MouseMoveEvent 167 209 0 0 0 0 0\n"
"RenderEvent 167 209 0 0 0 0 0\n"
"MouseMoveEvent 167 208 0 0 0 0 0\n"
"RenderEvent 167 208 0 0 0 0 0\n"
"MouseMoveEvent 168 207 0 0 0 0 0\n"
"RenderEvent 168 207 0 0 0 0 0\n"
"MouseMoveEvent 168 206 0 0 0 0 0\n"
"RenderEvent 168 206 0 0 0 0 0\n"
"MouseMoveEvent 170 204 0 0 0 0 0\n"
"RenderEvent 170 204 0 0 0 0 0\n"
"MouseMoveEvent 171 204 0 0 0 0 0\n"
"RenderEvent 171 204 0 0 0 0 0\n"
"MouseMoveEvent 175 202 0 0 0 0 0\n"
"RenderEvent 175 202 0 0 0 0 0\n"
"MouseMoveEvent 178 199 0 0 0 0 0\n"
"RenderEvent 178 199 0 0 0 0 0\n"
"MouseMoveEvent 181 198 0 0 0 0 0\n"
"RenderEvent 181 198 0 0 0 0 0\n"
"MouseMoveEvent 183 197 0 0 0 0 0\n"
"RenderEvent 183 197 0 0 0 0 0\n"
"MouseMoveEvent 185 196 0 0 0 0 0\n"
"RenderEvent 185 196 0 0 0 0 0\n"
"MouseMoveEvent 185 195 0 0 0 0 0\n"
"RenderEvent 185 195 0 0 0 0 0\n"
"MouseMoveEvent 185 194 0 0 0 0 0\n"
"RenderEvent 185 194 0 0 0 0 0\n"
"MouseMoveEvent 186 194 0 0 0 0 0\n"
"RenderEvent 186 194 0 0 0 0 0\n"
"MouseMoveEvent 188 192 0 0 0 0 0\n"
"RenderEvent 188 192 0 0 0 0 0\n"
"MouseMoveEvent 191 190 0 0 0 0 0\n"
"RenderEvent 191 190 0 0 0 0 0\n"
"MouseMoveEvent 192 190 0 0 0 0 0\n"
"RenderEvent 192 190 0 0 0 0 0\n"
"MouseMoveEvent 193 190 0 0 0 0 0\n"
"RenderEvent 193 190 0 0 0 0 0\n"
"MouseMoveEvent 193 191 0 0 0 0 0\n"
"RenderEvent 193 191 0 0 0 0 0\n"
"MouseMoveEvent 194 192 0 0 0 0 0\n"
"RenderEvent 194 192 0 0 0 0 0\n"
"MouseMoveEvent 194 194 0 0 0 0 0\n"
"RenderEvent 194 194 0 0 0 0 0\n"
"MouseMoveEvent 195 194 0 0 0 0 0\n"
"RenderEvent 195 194 0 0 0 0 0\n"
"MouseMoveEvent 196 195 0 0 0 0 0\n"
"RenderEvent 196 195 0 0 0 0 0\n"
"MouseMoveEvent 196 196 0 0 0 0 0\n"
"RenderEvent 196 196 0 0 0 0 0\n"
"MouseMoveEvent 197 196 0 0 0 0 0\n"
"RenderEvent 197 196 0 0 0 0 0\n"
"MouseMoveEvent 198 196 0 0 0 0 0\n"
"RenderEvent 198 196 0 0 0 0 0\n"
"MouseMoveEvent 199 196 0 0 0 0 0\n"
"RenderEvent 199 196 0 0 0 0 0\n"
"MouseMoveEvent 202 196 0 0 0 0 0\n"
"RenderEvent 202 196 0 0 0 0 0\n"
"MouseMoveEvent 204 196 0 0 0 0 0\n"
"RenderEvent 204 196 0 0 0 0 0\n"
"MouseMoveEvent 205 196 0 0 0 0 0\n"
"RenderEvent 205 196 0 0 0 0 0\n"
"MouseMoveEvent 204 196 0 0 0 0 0\n"
"RenderEvent 204 196 0 0 0 0 0\n"
"MouseMoveEvent 204 198 0 0 0 0 0\n"
"RenderEvent 204 198 0 0 0 0 0\n"
"MouseMoveEvent 203 199 0 0 0 0 0\n"
"RenderEvent 203 199 0 0 0 0 0\n"
"MouseMoveEvent 202 199 0 0 0 0 0\n"
"RenderEvent 202 199 0 0 0 0 0\n"
"MouseMoveEvent 201 199 0 0 0 0 0\n"
"RenderEvent 201 199 0 0 0 0 0\n"
"MouseMoveEvent 201 200 0 0 0 0 0\n"
"RenderEvent 201 200 0 0 0 0 0\n"
"MouseMoveEvent 200 200 0 0 0 0 0\n"
"RenderEvent 200 200 0 0 0 0 0\n"
"MouseMoveEvent 200 201 0 0 0 0 0\n"
"RenderEvent 200 201 0 0 0 0 0\n"
"LeftButtonPressEvent 200 201 0 0 0 0 0\n"
"RenderEvent 200 201 0 0 0 0 0\n"
"LeftButtonReleaseEvent 200 201 0 0 0 0 0\n"
"MouseMoveEvent 200 201 0 0 0 0 0\n"
"RenderEvent 200 201 0 0 0 0 0\n"
"MouseMoveEvent 200 202 0 0 0 0 0\n"
"RenderEvent 200 202 0 0 0 0 0\n"
"MouseMoveEvent 199 202 0 0 0 0 0\n"
"RenderEvent 199 202 0 0 0 0 0\n"
"MouseMoveEvent 197 202 0 0 0 0 0\n"
"RenderEvent 197 202 0 0 0 0 0\n"
"MouseMoveEvent 196 202 0 0 0 0 0\n"
"RenderEvent 196 202 0 0 0 0 0\n"
"MouseMoveEvent 192 201 0 0 0 0 0\n"
"RenderEvent 192 201 0 0 0 0 0\n"
"MouseMoveEvent 188 200 0 0 0 0 0\n"
"RenderEvent 188 200 0 0 0 0 0\n"
"MouseMoveEvent 183 198 0 0 0 0 0\n"
"RenderEvent 183 198 0 0 0 0 0\n"
"MouseMoveEvent 179 196 0 0 0 0 0\n"
"RenderEvent 179 196 0 0 0 0 0\n"
"MouseMoveEvent 173 195 0 0 0 0 0\n"
"RenderEvent 173 195 0 0 0 0 0\n"
"MouseMoveEvent 162 193 0 0 0 0 0\n"
"RenderEvent 162 193 0 0 0 0 0\n"
"MouseMoveEvent 149 193 0 0 0 0 0\n"
"RenderEvent 149 193 0 0 0 0 0\n"
"MouseMoveEvent 135 194 0 0 0 0 0\n"
"RenderEvent 135 194 0 0 0 0 0\n"
"MouseMoveEvent 120 194 0 0 0 0 0\n"
"RenderEvent 120 194 0 0 0 0 0\n"
"MouseMoveEvent 110 194 0 0 0 0 0\n"
"RenderEvent 110 194 0 0 0 0 0\n"
"MouseMoveEvent 106 194 0 0 0 0 0\n"
"RenderEvent 106 194 0 0 0 0 0\n"
"MouseMoveEvent 103 194 0 0 0 0 0\n"
"RenderEvent 103 194 0 0 0 0 0\n"
"MouseMoveEvent 102 194 0 0 0 0 0\n"
"RenderEvent 102 194 0 0 0 0 0\n"
"MouseMoveEvent 100 194 0 0 0 0 0\n"
"RenderEvent 100 194 0 0 0 0 0\n"
"MouseMoveEvent 99 194 0 0 0 0 0\n"
"RenderEvent 99 194 0 0 0 0 0\n"
"MouseMoveEvent 98 194 0 0 0 0 0\n"
"RenderEvent 98 194 0 0 0 0 0\n"
"MouseMoveEvent 97 194 0 0 0 0 0\n"
"RenderEvent 97 194 0 0 0 0 0\n"
"MouseMoveEvent 96 195 0 0 0 0 0\n"
"RenderEvent 96 195 0 0 0 0 0\n"
"MouseMoveEvent 91 197 0 0 0 0 0\n"
"RenderEvent 91 197 0 0 0 0 0\n"
"MouseMoveEvent 88 199 0 0 0 0 0\n"
"RenderEvent 88 199 0 0 0 0 0\n"
"MouseMoveEvent 86 200 0 0 0 0 0\n"
"RenderEvent 86 200 0 0 0 0 0\n"
"MouseMoveEvent 85 201 0 0 0 0 0\n"
"RenderEvent 85 201 0 0 0 0 0\n"
"MouseMoveEvent 84 201 0 0 0 0 0\n"
"RenderEvent 84 201 0 0 0 0 0\n"
"MouseMoveEvent 83 201 0 0 0 0 0\n"
"RenderEvent 83 201 0 0 0 0 0\n"
"MouseMoveEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"MouseMoveEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"MouseMoveEvent 82 201 0 0 0 0 0\n"
"RenderEvent 82 201 0 0 0 0 0\n"
"MouseMoveEvent 83 201 0 0 0 0 0\n"
"RenderEvent 83 201 0 0 0 0 0\n"
"MouseMoveEvent 84 201 0 0 0 0 0\n"
"RenderEvent 84 201 0 0 0 0 0\n"
"MouseMoveEvent 85 201 0 0 0 0 0\n"
"RenderEvent 85 201 0 0 0 0 0\n"
"MouseMoveEvent 86 201 0 0 0 0 0\n"
"RenderEvent 86 201 0 0 0 0 0\n"
"MouseMoveEvent 87 201 0 0 0 0 0\n"
"RenderEvent 87 201 0 0 0 0 0\n"
"MouseMoveEvent 88 201 0 0 0 0 0\n"
"RenderEvent 88 201 0 0 0 0 0\n"
"MouseMoveEvent 89 201 0 0 0 0 0\n"
"RenderEvent 89 201 0 0 0 0 0\n"
"MouseMoveEvent 90 201 0 0 0 0 0\n"
"RenderEvent 90 201 0 0 0 0 0\n"
"MouseMoveEvent 91 201 0 0 0 0 0\n"
"RenderEvent 91 201 0 0 0 0 0\n"
"MouseMoveEvent 90 201 0 0 0 0 0\n"
"RenderEvent 90 201 0 0 0 0 0\n"
"MouseMoveEvent 90 202 0 0 0 0 0\n"
"RenderEvent 90 202 0 0 0 0 0\n"
"MouseMoveEvent 90 203 0 0 0 0 0\n"
"RenderEvent 90 203 0 0 0 0 0\n"
"MouseMoveEvent 90 204 0 0 0 0 0\n"
"RenderEvent 90 204 0 0 0 0 0\n"
"MouseMoveEvent 91 204 0 0 0 0 0\n"
"RenderEvent 91 204 0 0 0 0 0\n"
"MouseMoveEvent 92 204 0 0 0 0 0\n"
"RenderEvent 92 204 0 0 0 0 0\n"
"MouseMoveEvent 92 205 0 0 0 0 0\n"
"RenderEvent 92 205 0 0 0 0 0\n"
"LeftButtonPressEvent 92 205 0 0 0 0 0\n"
"RenderEvent 92 205 0 0 0 0 0\n"
"LeftButtonReleaseEvent 92 205 0 0 0 0 0\n"
"MouseMoveEvent 92 205 0 0 0 0 0\n"
"RenderEvent 92 205 0 0 0 0 0\n"
"MouseMoveEvent 93 205 0 0 0 0 0\n"
"RenderEvent 93 205 0 0 0 0 0\n"
"MouseMoveEvent 93 204 0 0 0 0 0\n"
"RenderEvent 93 204 0 0 0 0 0\n"
"MouseMoveEvent 93 203 0 0 0 0 0\n"
"RenderEvent 93 203 0 0 0 0 0\n"
"MouseMoveEvent 93 202 0 0 0 0 0\n"
"RenderEvent 93 202 0 0 0 0 0\n"
"MouseMoveEvent 94 200 0 0 0 0 0\n"
"RenderEvent 94 200 0 0 0 0 0\n"
"MouseMoveEvent 95 199 0 0 0 0 0\n"
"RenderEvent 95 199 0 0 0 0 0\n"
"MouseMoveEvent 96 197 0 0 0 0 0\n"
"RenderEvent 96 197 0 0 0 0 0\n"
"MouseMoveEvent 99 191 0 0 0 0 0\n"
"RenderEvent 99 191 0 0 0 0 0\n"
"MouseMoveEvent 103 186 0 0 0 0 0\n"
"RenderEvent 103 186 0 0 0 0 0\n"
"MouseMoveEvent 108 181 0 0 0 0 0\n"
"RenderEvent 108 181 0 0 0 0 0\n"
"MouseMoveEvent 111 174 0 0 0 0 0\n"
"RenderEvent 111 174 0 0 0 0 0\n"
"MouseMoveEvent 116 169 0 0 0 0 0\n"
"RenderEvent 116 169 0 0 0 0 0\n"
"MouseMoveEvent 119 165 0 0 0 0 0\n"
"RenderEvent 119 165 0 0 0 0 0\n"
"MouseMoveEvent 121 162 0 0 0 0 0\n"
"RenderEvent 121 162 0 0 0 0 0\n"
"MouseMoveEvent 122 158 0 0 0 0 0\n"
"RenderEvent 122 158 0 0 0 0 0\n"
"MouseMoveEvent 124 154 0 0 0 0 0\n"
"RenderEvent 124 154 0 0 0 0 0\n"
"MouseMoveEvent 128 148 0 0 0 0 0\n"
"RenderEvent 128 148 0 0 0 0 0\n"
"MouseMoveEvent 132 145 0 0 0 0 0\n"
"RenderEvent 132 145 0 0 0 0 0\n"
"MouseMoveEvent 136 143 0 0 0 0 0\n"
"RenderEvent 136 143 0 0 0 0 0\n"
"MouseMoveEvent 138 143 0 0 0 0 0\n"
"RenderEvent 138 143 0 0 0 0 0\n"
"MouseMoveEvent 140 143 0 0 0 0 0\n"
"RenderEvent 140 143 0 0 0 0 0\n"
"MouseMoveEvent 140 144 0 0 0 0 0\n"
"RenderEvent 140 144 0 0 0 0 0\n"
"MouseMoveEvent 140 146 0 0 0 0 0\n"
"RenderEvent 140 146 0 0 0 0 0\n"
"MouseMoveEvent 140 147 0 0 0 0 0\n"
"RenderEvent 140 147 0 0 0 0 0\n"
"MouseMoveEvent 140 150 0 0 0 0 0\n"
"RenderEvent 140 150 0 0 0 0 0\n"
"MouseMoveEvent 139 153 0 0 0 0 0\n"
"RenderEvent 139 153 0 0 0 0 0\n"
"MouseMoveEvent 138 154 0 0 0 0 0\n"
"RenderEvent 138 154 0 0 0 0 0\n"
"MouseMoveEvent 138 155 0 0 0 0 0\n"
"RenderEvent 138 155 0 0 0 0 0\n"
"MouseMoveEvent 137 156 0 0 0 0 0\n"
"RenderEvent 137 156 0 0 0 0 0\n"
"MouseMoveEvent 137 157 0 0 0 0 0\n"
"RenderEvent 137 157 0 0 0 0 0\n"
"MouseMoveEvent 136 159 0 0 0 0 0\n"
"RenderEvent 136 159 0 0 0 0 0\n"
"MouseMoveEvent 134 160 0 0 0 0 0\n"
"RenderEvent 134 160 0 0 0 0 0\n"
"MouseMoveEvent 134 161 0 0 0 0 0\n"
"RenderEvent 134 161 0 0 0 0 0\n"
"MouseMoveEvent 133 162 0 0 0 0 0\n"
"RenderEvent 133 162 0 0 0 0 0\n"
"MouseMoveEvent 133 161 0 0 0 0 0\n"
"RenderEvent 133 161 0 0 0 0 0\n"
"MouseMoveEvent 133 160 0 0 0 0 0\n"
"RenderEvent 133 160 0 0 0 0 0\n"
"LeftButtonPressEvent 133 160 0 0 0 0 0\n"
"RenderEvent 133 160 0 0 0 0 0\n"
"MouseMoveEvent 133 161 0 0 0 0 0\n"
"RenderEvent 133 161 0 0 0 0 0\n"
"MouseMoveEvent 134 162 0 0 0 0 0\n"
"RenderEvent 134 162 0 0 0 0 0\n"
"MouseMoveEvent 133 162 0 0 0 0 0\n"
"RenderEvent 133 162 0 0 0 0 0\n"
"MouseMoveEvent 133 163 0 0 0 0 0\n"
"RenderEvent 133 163 0 0 0 0 0\n"
"MouseMoveEvent 133 164 0 0 0 0 0\n"
"RenderEvent 133 164 0 0 0 0 0\n"
"MouseMoveEvent 134 164 0 0 0 0 0\n"
"RenderEvent 134 164 0 0 0 0 0\n"
"MouseMoveEvent 134 165 0 0 0 0 0\n"
"RenderEvent 134 165 0 0 0 0 0\n"
"MouseMoveEvent 135 166 0 0 0 0 0\n"
"RenderEvent 135 166 0 0 0 0 0\n"
"MouseMoveEvent 135 167 0 0 0 0 0\n"
"RenderEvent 135 167 0 0 0 0 0\n"
"MouseMoveEvent 136 168 0 0 0 0 0\n"
"RenderEvent 136 168 0 0 0 0 0\n"
"MouseMoveEvent 137 169 0 0 0 0 0\n"
"RenderEvent 137 169 0 0 0 0 0\n"
"MouseMoveEvent 140 171 0 0 0 0 0\n"
"RenderEvent 140 171 0 0 0 0 0\n"
"MouseMoveEvent 139 171 0 0 0 0 0\n"
"RenderEvent 139 171 0 0 0 0 0\n"
"MouseMoveEvent 138 171 0 0 0 0 0\n"
"RenderEvent 138 171 0 0 0 0 0\n"
"MouseMoveEvent 139 171 0 0 0 0 0\n"
"RenderEvent 139 171 0 0 0 0 0\n"
"MouseMoveEvent 139 172 0 0 0 0 0\n"
"RenderEvent 139 172 0 0 0 0 0\n"
"MouseMoveEvent 140 172 0 0 0 0 0\n"
"RenderEvent 140 172 0 0 0 0 0\n"
"MouseMoveEvent 141 173 0 0 0 0 0\n"
"RenderEvent 141 173 0 0 0 0 0\n"
"MouseMoveEvent 142 173 0 0 0 0 0\n"
"RenderEvent 142 173 0 0 0 0 0\n"
"MouseMoveEvent 143 174 0 0 0 0 0\n"
"RenderEvent 143 174 0 0 0 0 0\n"
"MouseMoveEvent 142 174 0 0 0 0 0\n"
"RenderEvent 142 174 0 0 0 0 0\n"
"MouseMoveEvent 141 174 0 0 0 0 0\n"
"RenderEvent 141 174 0 0 0 0 0\n"
"MouseMoveEvent 140 174 0 0 0 0 0\n"
"RenderEvent 140 174 0 0 0 0 0\n"
"MouseMoveEvent 139 173 0 0 0 0 0\n"
"RenderEvent 139 173 0 0 0 0 0\n"
"MouseMoveEvent 138 172 0 0 0 0 0\n"
"RenderEvent 138 172 0 0 0 0 0\n"
"MouseMoveEvent 137 172 0 0 0 0 0\n"
"RenderEvent 137 172 0 0 0 0 0\n"
"MouseMoveEvent 136 171 0 0 0 0 0\n"
"RenderEvent 136 171 0 0 0 0 0\n"
"MouseMoveEvent 135 171 0 0 0 0 0\n"
"RenderEvent 135 171 0 0 0 0 0\n"
"MouseMoveEvent 134 171 0 0 0 0 0\n"
"RenderEvent 134 171 0 0 0 0 0\n"
"MouseMoveEvent 131 169 0 0 0 0 0\n"
"RenderEvent 131 169 0 0 0 0 0\n"
"MouseMoveEvent 128 167 0 0 0 0 0\n"
"RenderEvent 128 167 0 0 0 0 0\n"
"MouseMoveEvent 123 164 0 0 0 0 0\n"
"RenderEvent 123 164 0 0 0 0 0\n"
"MouseMoveEvent 121 162 0 0 0 0 0\n"
"RenderEvent 121 162 0 0 0 0 0\n"
"MouseMoveEvent 119 160 0 0 0 0 0\n"
"RenderEvent 119 160 0 0 0 0 0\n"
"MouseMoveEvent 118 159 0 0 0 0 0\n"
"RenderEvent 118 159 0 0 0 0 0\n"
"LeftButtonReleaseEvent 118 159 0 0 0 0 0\n"
"RenderEvent 118 159 0 0 0 0 0\n"
"MouseMoveEvent 118 159 0 0 0 0 0\n"
"RenderEvent 118 159 0 0 0 0 0\n"
"MouseMoveEvent 118 160 0 0 0 0 0\n"
"RenderEvent 118 160 0 0 0 0 0\n"
"MouseMoveEvent 119 160 0 0 0 0 0\n"
"RenderEvent 119 160 0 0 0 0 0\n"
"MouseMoveEvent 120 160 0 0 0 0 0\n"
"RenderEvent 120 160 0 0 0 0 0\n"
"MouseMoveEvent 121 161 0 0 0 0 0\n"
"RenderEvent 121 161 0 0 0 0 0\n"
"MouseMoveEvent 122 161 0 0 0 0 0\n"
"RenderEvent 122 161 0 0 0 0 0\n"
"MouseMoveEvent 124 161 0 0 0 0 0\n"
"RenderEvent 124 161 0 0 0 0 0\n"
"MouseMoveEvent 126 161 0 0 0 0 0\n"
"RenderEvent 126 161 0 0 0 0 0\n"
"MouseMoveEvent 129 162 0 0 0 0 0\n"
"RenderEvent 129 162 0 0 0 0 0\n"
"MouseMoveEvent 133 162 0 0 0 0 0\n"
"RenderEvent 133 162 0 0 0 0 0\n"
"MouseMoveEvent 137 162 0 0 0 0 0\n"
"RenderEvent 137 162 0 0 0 0 0\n"
"MouseMoveEvent 140 162 0 0 0 0 0\n"
"RenderEvent 140 162 0 0 0 0 0\n"
"MouseMoveEvent 142 162 0 0 0 0 0\n"
"RenderEvent 142 162 0 0 0 0 0\n"
"MouseMoveEvent 143 162 0 0 0 0 0\n"
"RenderEvent 143 162 0 0 0 0 0\n"
"MouseMoveEvent 145 162 0 0 0 0 0\n"
"RenderEvent 145 162 0 0 0 0 0\n"
"MouseMoveEvent 147 161 0 0 0 0 0\n"
"RenderEvent 147 161 0 0 0 0 0\n"
"MouseMoveEvent 150 159 0 0 0 0 0\n"
"RenderEvent 150 159 0 0 0 0 0\n"
"MouseMoveEvent 157 157 0 0 0 0 0\n"
"RenderEvent 157 157 0 0 0 0 0\n"
"MouseMoveEvent 158 156 0 0 0 0 0\n"
"RenderEvent 158 156 0 0 0 0 0\n"
"MouseMoveEvent 160 156 0 0 0 0 0\n"
"RenderEvent 160 156 0 0 0 0 0\n"
"MouseMoveEvent 161 156 0 0 0 0 0\n"
"RenderEvent 161 156 0 0 0 0 0\n"
"MouseMoveEvent 161 157 0 0 0 0 0\n"
"RenderEvent 161 157 0 0 0 0 0\n"
"MouseMoveEvent 161 158 0 0 0 0 0\n"
"RenderEvent 161 158 0 0 0 0 0\n"
"MouseMoveEvent 161 159 0 0 0 0 0\n"
"RenderEvent 161 159 0 0 0 0 0\n"
"MouseMoveEvent 161 160 0 0 0 0 0\n"
"RenderEvent 161 160 0 0 0 0 0\n"
"MouseMoveEvent 161 161 0 0 0 0 0\n"
"RenderEvent 161 161 0 0 0 0 0\n"
"LeftButtonPressEvent 161 161 0 0 0 0 0\n"
"RenderEvent 161 161 0 0 0 0 0\n"
"MouseMoveEvent 161 162 0 0 0 0 0\n"
"RenderEvent 161 162 0 0 0 0 0\n"
"MouseMoveEvent 161 163 0 0 0 0 0\n"
"RenderEvent 161 163 0 0 0 0 0\n"
"MouseMoveEvent 161 164 0 0 0 0 0\n"
"RenderEvent 161 164 0 0 0 0 0\n"
"MouseMoveEvent 161 165 0 0 0 0 0\n"
"RenderEvent 161 165 0 0 0 0 0\n"
"MouseMoveEvent 161 166 0 0 0 0 0\n"
"RenderEvent 161 166 0 0 0 0 0\n"
"MouseMoveEvent 161 167 0 0 0 0 0\n"
"RenderEvent 161 167 0 0 0 0 0\n"
"MouseMoveEvent 161 168 0 0 0 0 0\n"
"RenderEvent 161 168 0 0 0 0 0\n"
"MouseMoveEvent 161 169 0 0 0 0 0\n"
"RenderEvent 161 169 0 0 0 0 0\n"
"MouseMoveEvent 161 170 0 0 0 0 0\n"
"RenderEvent 161 170 0 0 0 0 0\n"
"MouseMoveEvent 161 171 0 0 0 0 0\n"
"RenderEvent 161 171 0 0 0 0 0\n"
"MouseMoveEvent 160 171 0 0 0 0 0\n"
"RenderEvent 160 171 0 0 0 0 0\n"
"MouseMoveEvent 160 172 0 0 0 0 0\n"
"RenderEvent 160 172 0 0 0 0 0\n"
"MouseMoveEvent 159 173 0 0 0 0 0\n"
"RenderEvent 159 173 0 0 0 0 0\n"
"MouseMoveEvent 158 174 0 0 0 0 0\n"
"RenderEvent 158 174 0 0 0 0 0\n"
"MouseMoveEvent 157 175 0 0 0 0 0\n"
"RenderEvent 157 175 0 0 0 0 0\n"
"MouseMoveEvent 156 175 0 0 0 0 0\n"
"RenderEvent 156 175 0 0 0 0 0\n"
"MouseMoveEvent 155 177 0 0 0 0 0\n"
"RenderEvent 155 177 0 0 0 0 0\n"
"MouseMoveEvent 154 178 0 0 0 0 0\n"
"RenderEvent 154 178 0 0 0 0 0\n"
"MouseMoveEvent 152 180 0 0 0 0 0\n"
"RenderEvent 152 180 0 0 0 0 0\n"
"MouseMoveEvent 151 181 0 0 0 0 0\n"
"RenderEvent 151 181 0 0 0 0 0\n"
"MouseMoveEvent 151 182 0 0 0 0 0\n"
"RenderEvent 151 182 0 0 0 0 0\n"
"MouseMoveEvent 149 182 0 0 0 0 0\n"
"RenderEvent 149 182 0 0 0 0 0\n"
"MouseMoveEvent 149 183 0 0 0 0 0\n"
"RenderEvent 149 183 0 0 0 0 0\n"
"MouseMoveEvent 148 183 0 0 0 0 0\n"
"RenderEvent 148 183 0 0 0 0 0\n"
"MouseMoveEvent 149 183 0 0 0 0 0\n"
"RenderEvent 149 183 0 0 0 0 0\n"
"MouseMoveEvent 149 182 0 0 0 0 0\n"
"RenderEvent 149 182 0 0 0 0 0\n"
"MouseMoveEvent 150 182 0 0 0 0 0\n"
"RenderEvent 150 182 0 0 0 0 0\n"
"MouseMoveEvent 151 181 0 0 0 0 0\n"
"RenderEvent 151 181 0 0 0 0 0\n"
"MouseMoveEvent 152 181 0 0 0 0 0\n"
"RenderEvent 152 181 0 0 0 0 0\n"
"MouseMoveEvent 154 178 0 0 0 0 0\n"
"RenderEvent 154 178 0 0 0 0 0\n"
"MouseMoveEvent 155 177 0 0 0 0 0\n"
"RenderEvent 155 177 0 0 0 0 0\n"
"MouseMoveEvent 157 175 0 0 0 0 0\n"
"RenderEvent 157 175 0 0 0 0 0\n"
"MouseMoveEvent 159 174 0 0 0 0 0\n"
"RenderEvent 159 174 0 0 0 0 0\n"
"MouseMoveEvent 162 172 0 0 0 0 0\n"
"RenderEvent 162 172 0 0 0 0 0\n"
"MouseMoveEvent 164 171 0 0 0 0 0\n"
"RenderEvent 164 171 0 0 0 0 0\n"
"MouseMoveEvent 165 169 0 0 0 0 0\n"
"RenderEvent 165 169 0 0 0 0 0\n"
"LeftButtonReleaseEvent 165 169 0 0 0 0 0\n"
"RenderEvent 165 169 0 0 0 0 0\n"
"MouseMoveEvent 165 169 0 0 0 0 0\n"
"RenderEvent 165 169 0 0 0 0 0\n"
"MouseMoveEvent 165 170 0 0 0 0 0\n"
"RenderEvent 165 170 0 0 0 0 0\n"
"MouseMoveEvent 165 171 0 0 0 0 0\n"
"RenderEvent 165 171 0 0 0 0 0\n"
"MouseMoveEvent 165 172 0 0 0 0 0\n"
"RenderEvent 165 172 0 0 0 0 0\n"
"MouseMoveEvent 166 173 0 0 0 0 0\n"
"RenderEvent 166 173 0 0 0 0 0\n"
"MouseMoveEvent 167 175 0 0 0 0 0\n"
"RenderEvent 167 175 0 0 0 0 0\n"
"MouseMoveEvent 169 176 0 0 0 0 0\n"
"RenderEvent 169 176 0 0 0 0 0\n"
"MouseMoveEvent 170 177 0 0 0 0 0\n"
"RenderEvent 170 177 0 0 0 0 0\n"
"MouseMoveEvent 171 179 0 0 0 0 0\n"
"RenderEvent 171 179 0 0 0 0 0\n"
"MouseMoveEvent 175 181 0 0 0 0 0\n"
"RenderEvent 175 181 0 0 0 0 0\n"
"MouseMoveEvent 176 182 0 0 0 0 0\n"
"RenderEvent 176 182 0 0 0 0 0\n"
"MouseMoveEvent 179 183 0 0 0 0 0\n"
"RenderEvent 179 183 0 0 0 0 0\n"
"MouseMoveEvent 183 184 0 0 0 0 0\n"
"RenderEvent 183 184 0 0 0 0 0\n"
"MouseMoveEvent 185 185 0 0 0 0 0\n"
"RenderEvent 185 185 0 0 0 0 0\n"
"MouseMoveEvent 187 187 0 0 0 0 0\n"
"RenderEvent 187 187 0 0 0 0 0\n"
"MouseMoveEvent 187 188 0 0 0 0 0\n"
"RenderEvent 187 188 0 0 0 0 0\n"
"MouseMoveEvent 187 189 0 0 0 0 0\n"
"RenderEvent 187 189 0 0 0 0 0\n"
"MouseMoveEvent 188 189 0 0 0 0 0\n"
"RenderEvent 188 189 0 0 0 0 0\n"
"MouseMoveEvent 190 189 0 0 0 0 0\n"
"RenderEvent 190 189 0 0 0 0 0\n"
"MouseMoveEvent 191 189 0 0 0 0 0\n"
"RenderEvent 191 189 0 0 0 0 0\n"
"MouseMoveEvent 191 190 0 0 0 0 0\n"
"RenderEvent 191 190 0 0 0 0 0\n"
"MouseMoveEvent 191 191 0 0 0 0 0\n"
"RenderEvent 191 191 0 0 0 0 0\n"
"MouseMoveEvent 192 191 0 0 0 0 0\n"
"RenderEvent 192 191 0 0 0 0 0\n"
"MouseMoveEvent 192 192 0 0 0 0 0\n"
"RenderEvent 192 192 0 0 0 0 0\n"
"MouseMoveEvent 192 193 0 0 0 0 0\n"
"RenderEvent 192 193 0 0 0 0 0\n"
"MouseMoveEvent 193 193 0 0 0 0 0\n"
"RenderEvent 193 193 0 0 0 0 0\n"
"MouseMoveEvent 193 194 0 0 0 0 0\n"
"RenderEvent 193 194 0 0 0 0 0\n"
"MouseMoveEvent 195 195 0 0 0 0 0\n"
"RenderEvent 195 195 0 0 0 0 0\n"
"MouseMoveEvent 196 195 0 0 0 0 0\n"
"RenderEvent 196 195 0 0 0 0 0\n"
"MouseMoveEvent 197 198 0 0 0 0 0\n"
"RenderEvent 197 198 0 0 0 0 0\n"
"MouseMoveEvent 198 200 0 0 0 0 0\n"
"RenderEvent 198 200 0 0 0 0 0\n"
"MouseMoveEvent 199 200 0 0 0 0 0\n"
"RenderEvent 199 200 0 0 0 0 0\n"
"MouseMoveEvent 199 201 0 0 0 0 0\n"
"RenderEvent 199 201 0 0 0 0 0\n"
"LeftButtonPressEvent 199 201 0 0 0 0 0\n"
"RenderEvent 199 201 0 0 0 0 0\n"
"MouseMoveEvent 198 201 0 0 0 0 0\n"
"RenderEvent 198 201 0 0 0 0 0\n"
"MouseMoveEvent 197 201 0 0 0 0 0\n"
"RenderEvent 197 201 0 0 0 0 0\n"
"MouseMoveEvent 198 200 0 0 0 0 0\n"
"RenderEvent 198 200 0 0 0 0 0\n"
"MouseMoveEvent 197 200 0 0 0 0 0\n"
"RenderEvent 197 200 0 0 0 0 0\n"
"MouseMoveEvent 196 200 0 0 0 0 0\n"
"RenderEvent 196 200 0 0 0 0 0\n"
"MouseMoveEvent 195 200 0 0 0 0 0\n"
"RenderEvent 195 200 0 0 0 0 0\n"
"MouseMoveEvent 195 199 0 0 0 0 0\n"
"RenderEvent 195 199 0 0 0 0 0\n"
"MouseMoveEvent 194 199 0 0 0 0 0\n"
"RenderEvent 194 199 0 0 0 0 0\n"
"MouseMoveEvent 194 198 0 0 0 0 0\n"
"RenderEvent 194 198 0 0 0 0 0\n"
"MouseMoveEvent 192 196 0 0 0 0 0\n"
"RenderEvent 192 196 0 0 0 0 0\n"
"MouseMoveEvent 190 195 0 0 0 0 0\n"
"RenderEvent 190 195 0 0 0 0 0\n"
"MouseMoveEvent 189 193 0 0 0 0 0\n"
"RenderEvent 189 193 0 0 0 0 0\n"
"MouseMoveEvent 187 191 0 0 0 0 0\n"
"RenderEvent 187 191 0 0 0 0 0\n"
"MouseMoveEvent 186 190 0 0 0 0 0\n"
"RenderEvent 186 190 0 0 0 0 0\n"
"MouseMoveEvent 184 188 0 0 0 0 0\n"
"RenderEvent 184 188 0 0 0 0 0\n"
"MouseMoveEvent 183 187 0 0 0 0 0\n"
"RenderEvent 183 187 0 0 0 0 0\n"
"MouseMoveEvent 181 186 0 0 0 0 0\n"
"RenderEvent 181 186 0 0 0 0 0\n"
"MouseMoveEvent 180 185 0 0 0 0 0\n"
"RenderEvent 180 185 0 0 0 0 0\n"
"MouseMoveEvent 178 184 0 0 0 0 0\n"
"RenderEvent 178 184 0 0 0 0 0\n"
"MouseMoveEvent 178 182 0 0 0 0 0\n"
"RenderEvent 178 182 0 0 0 0 0\n"
"MouseMoveEvent 176 181 0 0 0 0 0\n"
"RenderEvent 176 181 0 0 0 0 0\n"
"MouseMoveEvent 175 180 0 0 0 0 0\n"
"RenderEvent 175 180 0 0 0 0 0\n"
"MouseMoveEvent 174 180 0 0 0 0 0\n"
"RenderEvent 174 180 0 0 0 0 0\n"
"MouseMoveEvent 174 181 0 0 0 0 0\n"
"RenderEvent 174 181 0 0 0 0 0\n"
"MouseMoveEvent 173 181 0 0 0 0 0\n"
"RenderEvent 173 181 0 0 0 0 0\n"
"MouseMoveEvent 172 181 0 0 0 0 0\n"
"RenderEvent 172 181 0 0 0 0 0\n"
"MouseMoveEvent 171 181 0 0 0 0 0\n"
"RenderEvent 171 181 0 0 0 0 0\n"
"MouseMoveEvent 171 180 0 0 0 0 0\n"
"RenderEvent 171 180 0 0 0 0 0\n"
"MouseMoveEvent 170 180 0 0 0 0 0\n"
"RenderEvent 170 180 0 0 0 0 0\n"
"MouseMoveEvent 169 180 0 0 0 0 0\n"
"RenderEvent 169 180 0 0 0 0 0\n"
"MouseMoveEvent 168 180 0 0 0 0 0\n"
"RenderEvent 168 180 0 0 0 0 0\n"
"MouseMoveEvent 167 180 0 0 0 0 0\n"
"RenderEvent 167 180 0 0 0 0 0\n"
"MouseMoveEvent 166 180 0 0 0 0 0\n"
"RenderEvent 166 180 0 0 0 0 0\n"
"MouseMoveEvent 165 180 0 0 0 0 0\n"
"RenderEvent 165 180 0 0 0 0 0\n"
"MouseMoveEvent 165 179 0 0 0 0 0\n"
"RenderEvent 165 179 0 0 0 0 0\n"
"MouseMoveEvent 164 179 0 0 0 0 0\n"
"RenderEvent 164 179 0 0 0 0 0\n"
"MouseMoveEvent 163 178 0 0 0 0 0\n"
"RenderEvent 163 178 0 0 0 0 0\n"
"MouseMoveEvent 162 176 0 0 0 0 0\n"
"RenderEvent 162 176 0 0 0 0 0\n"
"MouseMoveEvent 161 175 0 0 0 0 0\n"
"RenderEvent 161 175 0 0 0 0 0\n"
"MouseMoveEvent 160 175 0 0 0 0 0\n"
"RenderEvent 160 175 0 0 0 0 0\n"
"MouseMoveEvent 160 174 0 0 0 0 0\n"
"RenderEvent 160 174 0 0 0 0 0\n"
"LeftButtonReleaseEvent 160 174 0 0 0 0 0\n"
"RenderEvent 160 174 0 0 0 0 0\n"
"MouseMoveEvent 160 174 0 0 0 0 0\n"
"RenderEvent 160 174 0 0 0 0 0\n"
"MouseMoveEvent 159 174 0 0 0 0 0\n"
"RenderEvent 159 174 0 0 0 0 0\n"
"MouseMoveEvent 158 174 0 0 0 0 0\n"
"RenderEvent 158 174 0 0 0 0 0\n"
"MouseMoveEvent 157 174 0 0 0 0 0\n"
"RenderEvent 157 174 0 0 0 0 0\n"
"MouseMoveEvent 156 173 0 0 0 0 0\n"
"RenderEvent 156 173 0 0 0 0 0\n"
"MouseMoveEvent 155 172 0 0 0 0 0\n"
"RenderEvent 155 172 0 0 0 0 0\n"
"MouseMoveEvent 153 170 0 0 0 0 0\n"
"RenderEvent 153 170 0 0 0 0 0\n"
"MouseMoveEvent 152 169 0 0 0 0 0\n"
"RenderEvent 152 169 0 0 0 0 0\n"
"MouseMoveEvent 145 165 0 0 0 0 0\n"
"RenderEvent 145 165 0 0 0 0 0\n"
"MouseMoveEvent 143 165 0 0 0 0 0\n"
"RenderEvent 143 165 0 0 0 0 0\n"
"MouseMoveEvent 135 158 0 0 0 0 0\n"
"RenderEvent 135 158 0 0 0 0 0\n"
"MouseMoveEvent 134 155 0 0 0 0 0\n"
"RenderEvent 134 155 0 0 0 0 0\n"
"MouseMoveEvent 132 151 0 0 0 0 0\n"
"RenderEvent 132 151 0 0 0 0 0\n"
"MouseMoveEvent 129 146 0 0 0 0 0\n"
"RenderEvent 129 146 0 0 0 0 0\n"
"MouseMoveEvent 126 139 0 0 0 0 0\n"
"RenderEvent 126 139 0 0 0 0 0\n"
"MouseMoveEvent 123 135 0 0 0 0 0\n"
"RenderEvent 123 135 0 0 0 0 0\n"
"MouseMoveEvent 122 131 0 0 0 0 0\n"
"RenderEvent 122 131 0 0 0 0 0\n"
"MouseMoveEvent 122 128 0 0 0 0 0\n"
"RenderEvent 122 128 0 0 0 0 0\n"
"MouseMoveEvent 122 125 0 0 0 0 0\n"
"RenderEvent 122 125 0 0 0 0 0\n"
"MouseMoveEvent 121 124 0 0 0 0 0\n"
"RenderEvent 121 124 0 0 0 0 0\n"
"MouseMoveEvent 121 122 0 0 0 0 0\n"
"RenderEvent 121 122 0 0 0 0 0\n"
"MouseMoveEvent 119 121 0 0 0 0 0\n"
"RenderEvent 119 121 0 0 0 0 0\n"
"MouseMoveEvent 118 121 0 0 0 0 0\n"
"RenderEvent 118 121 0 0 0 0 0\n"
"MouseMoveEvent 116 120 0 0 0 0 0\n"
"RenderEvent 116 120 0 0 0 0 0\n"
"MouseMoveEvent 115 119 0 0 0 0 0\n"
"RenderEvent 115 119 0 0 0 0 0\n"
"MouseMoveEvent 114 119 0 0 0 0 0\n"
"RenderEvent 114 119 0 0 0 0 0\n"
"MouseMoveEvent 113 118 0 0 0 0 0\n"
"RenderEvent 113 118 0 0 0 0 0\n"
"MouseMoveEvent 111 118 0 0 0 0 0\n"
"RenderEvent 111 118 0 0 0 0 0\n"
"MouseMoveEvent 111 116 0 0 0 0 0\n"
"RenderEvent 111 116 0 0 0 0 0\n"
"MouseMoveEvent 110 116 0 0 0 0 0\n"
"RenderEvent 110 116 0 0 0 0 0\n"
"MouseMoveEvent 109 115 0 0 0 0 0\n"
"RenderEvent 109 115 0 0 0 0 0\n"
"MouseMoveEvent 107 113 0 0 0 0 0\n"
"RenderEvent 107 113 0 0 0 0 0\n"
"MouseMoveEvent 106 111 0 0 0 0 0\n"
"RenderEvent 106 111 0 0 0 0 0\n"
"MouseMoveEvent 106 110 0 0 0 0 0\n"
"RenderEvent 106 110 0 0 0 0 0\n"
"MouseMoveEvent 106 108 0 0 0 0 0\n"
"RenderEvent 106 108 0 0 0 0 0\n"
"MouseMoveEvent 105 107 0 0 0 0 0\n"
"RenderEvent 105 107 0 0 0 0 0\n"
"MouseMoveEvent 105 104 0 0 0 0 0\n"
"RenderEvent 105 104 0 0 0 0 0\n"
"MouseMoveEvent 105 103 0 0 0 0 0\n"
"RenderEvent 105 103 0 0 0 0 0\n"
"MouseMoveEvent 104 103 0 0 0 0 0\n"
"RenderEvent 104 103 0 0 0 0 0\n"
"MouseMoveEvent 103 102 0 0 0 0 0\n"
"RenderEvent 103 102 0 0 0 0 0\n"
"MouseMoveEvent 102 102 0 0 0 0 0\n"
"RenderEvent 102 102 0 0 0 0 0\n"
"MouseMoveEvent 101 102 0 0 0 0 0\n"
"RenderEvent 101 102 0 0 0 0 0\n"
"MouseMoveEvent 100 102 0 0 0 0 0\n"
"RenderEvent 100 102 0 0 0 0 0\n"
"MouseMoveEvent 99 102 0 0 0 0 0\n"
"RenderEvent 99 102 0 0 0 0 0\n"
"MouseMoveEvent 99 103 0 0 0 0 0\n"
"RenderEvent 99 103 0 0 0 0 0\n"
"MouseMoveEvent 98 103 0 0 0 0 0\n"
"RenderEvent 98 103 0 0 0 0 0\n"
"MouseMoveEvent 97 103 0 0 0 0 0\n"
"RenderEvent 97 103 0 0 0 0 0\n"
"MouseMoveEvent 95 103 0 0 0 0 0\n"
"RenderEvent 95 103 0 0 0 0 0\n"
"MouseMoveEvent 93 103 0 0 0 0 0\n"
"RenderEvent 93 103 0 0 0 0 0\n"
"MouseMoveEvent 92 103 0 0 0 0 0\n"
"RenderEvent 92 103 0 0 0 0 0\n"
"MouseMoveEvent 91 103 0 0 0 0 0\n"
"RenderEvent 91 103 0 0 0 0 0\n"
"MouseMoveEvent 90 103 0 0 0 0 0\n"
"RenderEvent 90 103 0 0 0 0 0\n"
"MouseMoveEvent 89 103 0 0 0 0 0\n"
"RenderEvent 89 103 0 0 0 0 0\n"
"MouseMoveEvent 88 103 0 0 0 0 0\n"
"RenderEvent 88 103 0 0 0 0 0\n"
"MouseMoveEvent 88 102 0 0 0 0 0\n"
"RenderEvent 88 102 0 0 0 0 0\n"
"MouseMoveEvent 87 102 0 0 0 0 0\n"
"RenderEvent 87 102 0 0 0 0 0\n"
"MouseMoveEvent 87 101 0 0 0 0 0\n"
"RenderEvent 87 101 0 0 0 0 0\n"
"MouseMoveEvent 87 100 0 0 0 0 0\n"
"RenderEvent 87 100 0 0 0 0 0\n"
"MouseMoveEvent 87 99 0 0 0 0 0\n"
"RenderEvent 87 99 0 0 0 0 0\n"
"MouseMoveEvent 87 98 0 0 0 0 0\n"
"RenderEvent 87 98 0 0 0 0 0\n"
"MouseMoveEvent 87 97 0 0 0 0 0\n"
"RenderEvent 87 97 0 0 0 0 0\n"
"MouseMoveEvent 87 96 0 0 0 0 0\n"
"RenderEvent 87 96 0 0 0 0 0\n"
"MouseMoveEvent 87 95 0 0 0 0 0\n"
"RenderEvent 87 95 0 0 0 0 0\n"
"LeftButtonPressEvent 87 95 0 0 0 0 0\n"
"RenderEvent 87 95 0 0 0 0 0\n"
"MouseMoveEvent 88 95 0 0 0 0 0\n"
"RenderEvent 88 95 0 0 0 0 0\n"
"MouseMoveEvent 88 96 0 0 0 0 0\n"
"RenderEvent 88 96 0 0 0 0 0\n"
"MouseMoveEvent 88 96 0 0 0 0 0\n"
"RenderEvent 88 96 0 0 0 0 0\n"
"MouseMoveEvent 88 97 0 0 0 0 0\n"
"RenderEvent 88 97 0 0 0 0 0\n"
"MouseMoveEvent 88 98 0 0 0 0 0\n"
"RenderEvent 88 98 0 0 0 0 0\n"
"MouseMoveEvent 89 98 0 0 0 0 0\n"
"RenderEvent 89 98 0 0 0 0 0\n"
"MouseMoveEvent 89 99 0 0 0 0 0\n"
"RenderEvent 89 99 0 0 0 0 0\n"
"MouseMoveEvent 90 99 0 0 0 0 0\n"
"RenderEvent 90 99 0 0 0 0 0\n"
"MouseMoveEvent 89 99 0 0 0 0 0\n"
"RenderEvent 89 99 0 0 0 0 0\n"
"MouseMoveEvent 89 100 0 0 0 0 0\n"
"RenderEvent 89 100 0 0 0 0 0\n"
"MouseMoveEvent 90 100 0 0 0 0 0\n"
"RenderEvent 90 100 0 0 0 0 0\n"
"MouseMoveEvent 90 101 0 0 0 0 0\n"
"RenderEvent 90 101 0 0 0 0 0\n"
"MouseMoveEvent 91 102 0 0 0 0 0\n"
"RenderEvent 91 102 0 0 0 0 0\n"
"MouseMoveEvent 91 103 0 0 0 0 0\n"
"RenderEvent 91 103 0 0 0 0 0\n"
"MouseMoveEvent 90 103 0 0 0 0 0\n"
"RenderEvent 90 103 0 0 0 0 0\n"
"MouseMoveEvent 91 103 0 0 0 0 0\n"
"RenderEvent 91 103 0 0 0 0 0\n"
"MouseMoveEvent 92 103 0 0 0 0 0\n"
"RenderEvent 92 103 0 0 0 0 0\n"
"MouseMoveEvent 93 104 0 0 0 0 0\n"
"RenderEvent 93 104 0 0 0 0 0\n"
"MouseMoveEvent 94 104 0 0 0 0 0\n"
"RenderEvent 94 104 0 0 0 0 0\n"
"MouseMoveEvent 95 105 0 0 0 0 0\n"
"RenderEvent 95 105 0 0 0 0 0\n"
"MouseMoveEvent 96 106 0 0 0 0 0\n"
"RenderEvent 96 106 0 0 0 0 0\n"
"MouseMoveEvent 97 106 0 0 0 0 0\n"
"RenderEvent 97 106 0 0 0 0 0\n"
"MouseMoveEvent 99 107 0 0 0 0 0\n"
"RenderEvent 99 107 0 0 0 0 0\n"
"MouseMoveEvent 102 109 0 0 0 0 0\n"
"RenderEvent 102 109 0 0 0 0 0\n"
"MouseMoveEvent 104 109 0 0 0 0 0\n"
"RenderEvent 104 109 0 0 0 0 0\n"
"MouseMoveEvent 104 110 0 0 0 0 0\n"
"RenderEvent 104 110 0 0 0 0 0\n"
"MouseMoveEvent 104 111 0 0 0 0 0\n"
"RenderEvent 104 111 0 0 0 0 0\n"
"MouseMoveEvent 105 111 0 0 0 0 0\n"
"RenderEvent 105 111 0 0 0 0 0\n"
"MouseMoveEvent 106 111 0 0 0 0 0\n"
"RenderEvent 106 111 0 0 0 0 0\n"
"LeftButtonReleaseEvent 106 111 0 0 0 0 0\n"
"RenderEvent 106 111 0 0 0 0 0\n"
"MouseMoveEvent 106 111 0 0 0 0 0\n"
"RenderEvent 106 111 0 0 0 0 0\n"
"MouseMoveEvent 106 112 0 0 0 0 0\n"
"RenderEvent 106 112 0 0 0 0 0\n"
"MouseMoveEvent 106 113 0 0 0 0 0\n"
"RenderEvent 106 113 0 0 0 0 0\n"
"MouseMoveEvent 106 114 0 0 0 0 0\n"
"RenderEvent 106 114 0 0 0 0 0\n"
"MouseMoveEvent 106 115 0 0 0 0 0\n"
"RenderEvent 106 115 0 0 0 0 0\n"
"MouseMoveEvent 108 118 0 0 0 0 0\n"
"RenderEvent 108 118 0 0 0 0 0\n"
"MouseMoveEvent 111 122 0 0 0 0 0\n"
"RenderEvent 111 122 0 0 0 0 0\n"
"MouseMoveEvent 114 125 0 0 0 0 0\n"
"RenderEvent 114 125 0 0 0 0 0\n"
"MouseMoveEvent 114 126 0 0 0 0 0\n"
"RenderEvent 114 126 0 0 0 0 0\n"
"MouseMoveEvent 114 127 0 0 0 0 0\n"
"RenderEvent 114 127 0 0 0 0 0\n"
"MouseMoveEvent 113 127 0 0 0 0 0\n"
"RenderEvent 113 127 0 0 0 0 0\n"
"MouseMoveEvent 113 128 0 0 0 0 0\n"
"RenderEvent 113 128 0 0 0 0 0\n"
"MouseMoveEvent 114 129 0 0 0 0 0\n"
"RenderEvent 114 129 0 0 0 0 0\n"
"MouseMoveEvent 115 130 0 0 0 0 0\n"
"RenderEvent 115 130 0 0 0 0 0\n"
"MouseMoveEvent 116 131 0 0 0 0 0\n"
"RenderEvent 116 131 0 0 0 0 0\n"
"MouseMoveEvent 119 132 0 0 0 0 0\n"
"RenderEvent 119 132 0 0 0 0 0\n"
"MouseMoveEvent 121 133 0 0 0 0 0\n"
"RenderEvent 121 133 0 0 0 0 0\n"
"MouseMoveEvent 122 133 0 0 0 0 0\n"
"RenderEvent 122 133 0 0 0 0 0\n"
"MouseMoveEvent 123 133 0 0 0 0 0\n"
"RenderEvent 123 133 0 0 0 0 0\n"
"MouseMoveEvent 124 133 0 0 0 0 0\n"
"RenderEvent 124 133 0 0 0 0 0\n"
"MouseMoveEvent 125 133 0 0 0 0 0\n"
"RenderEvent 125 133 0 0 0 0 0\n"
"MouseMoveEvent 125 134 0 0 0 0 0\n"
"RenderEvent 125 134 0 0 0 0 0\n"
"MouseMoveEvent 126 135 0 0 0 0 0\n"
"RenderEvent 126 135 0 0 0 0 0\n"
"MouseMoveEvent 128 135 0 0 0 0 0\n"
"RenderEvent 128 135 0 0 0 0 0\n"
"MouseMoveEvent 128 136 0 0 0 0 0\n"
"RenderEvent 128 136 0 0 0 0 0\n"
"MouseMoveEvent 128 137 0 0 0 0 0\n"
"RenderEvent 128 137 0 0 0 0 0\n"
"MouseMoveEvent 129 138 0 0 0 0 0\n"
"RenderEvent 129 138 0 0 0 0 0\n"
"MouseMoveEvent 129 139 0 0 0 0 0\n"
"RenderEvent 129 139 0 0 0 0 0\n"
"MouseMoveEvent 130 140 0 0 0 0 0\n"
"RenderEvent 130 140 0 0 0 0 0\n"
"MouseMoveEvent 131 140 0 0 0 0 0\n"
"RenderEvent 131 140 0 0 0 0 0\n"
"LeftButtonPressEvent 131 140 0 0 0 0 0\n"
"RenderEvent 131 140 0 0 0 0 0\n"
"MouseMoveEvent 132 140 0 0 0 0 0\n"
"RenderEvent 132 140 0 0 0 0 0\n"
"MouseMoveEvent 133 140 0 0 0 0 0\n"
"RenderEvent 133 140 0 0 0 0 0\n"
"MouseMoveEvent 134 140 0 0 0 0 0\n"
"RenderEvent 134 140 0 0 0 0 0\n"
"MouseMoveEvent 135 140 0 0 0 0 0\n"
"RenderEvent 135 140 0 0 0 0 0\n"
"MouseMoveEvent 136 140 0 0 0 0 0\n"
"RenderEvent 136 140 0 0 0 0 0\n"
"MouseMoveEvent 137 140 0 0 0 0 0\n"
"RenderEvent 137 140 0 0 0 0 0\n"
"MouseMoveEvent 138 140 0 0 0 0 0\n"
"RenderEvent 138 140 0 0 0 0 0\n"
"MouseMoveEvent 139 140 0 0 0 0 0\n"
"RenderEvent 139 140 0 0 0 0 0\n"
"MouseMoveEvent 140 140 0 0 0 0 0\n"
"RenderEvent 140 140 0 0 0 0 0\n"
"MouseMoveEvent 141 140 0 0 0 0 0\n"
"RenderEvent 141 140 0 0 0 0 0\n"
"MouseMoveEvent 142 140 0 0 0 0 0\n"
"RenderEvent 142 140 0 0 0 0 0\n"
"MouseMoveEvent 143 140 0 0 0 0 0\n"
"RenderEvent 143 140 0 0 0 0 0\n"
"MouseMoveEvent 143 141 0 0 0 0 0\n"
"RenderEvent 143 141 0 0 0 0 0\n"
"MouseMoveEvent 143 142 0 0 0 0 0\n"
"RenderEvent 143 142 0 0 0 0 0\n"
"MouseMoveEvent 143 143 0 0 0 0 0\n"
"RenderEvent 143 143 0 0 0 0 0\n"
"MouseMoveEvent 142 143 0 0 0 0 0\n"
"RenderEvent 142 143 0 0 0 0 0\n"
"MouseMoveEvent 141 143 0 0 0 0 0\n"
"RenderEvent 141 143 0 0 0 0 0\n"
"MouseMoveEvent 141 144 0 0 0 0 0\n"
"RenderEvent 141 144 0 0 0 0 0\n"
"MouseMoveEvent 141 145 0 0 0 0 0\n"
"RenderEvent 141 145 0 0 0 0 0\n"
"MouseMoveEvent 141 146 0 0 0 0 0\n"
"RenderEvent 141 146 0 0 0 0 0\n"
"MouseMoveEvent 141 147 0 0 0 0 0\n"
"RenderEvent 141 147 0 0 0 0 0\n"
"MouseMoveEvent 141 148 0 0 0 0 0\n"
"RenderEvent 141 148 0 0 0 0 0\n"
"MouseMoveEvent 141 149 0 0 0 0 0\n"
"RenderEvent 141 149 0 0 0 0 0\n"
"MouseMoveEvent 141 150 0 0 0 0 0\n"
"RenderEvent 141 150 0 0 0 0 0\n"
"MouseMoveEvent 141 151 0 0 0 0 0\n"
"RenderEvent 141 151 0 0 0 0 0\n"
"LeftButtonReleaseEvent 141 151 0 0 0 0 0\n"
"RenderEvent 141 151 0 0 0 0 0\n"
"MouseMoveEvent 141 151 0 0 0 0 0\n"
"RenderEvent 141 151 0 0 0 0 0\n"
"MouseMoveEvent 141 152 0 0 0 0 0\n"
"RenderEvent 141 152 0 0 0 0 0\n"
"MouseMoveEvent 141 153 0 0 0 0 0\n"
"RenderEvent 141 153 0 0 0 0 0\n"
"MouseMoveEvent 142 153 0 0 0 0 0\n"
"RenderEvent 142 153 0 0 0 0 0\n"
"MouseMoveEvent 141 153 0 0 0 0 0\n"
"RenderEvent 141 153 0 0 0 0 0\n"
"MouseMoveEvent 140 153 0 0 0 0 0\n"
"RenderEvent 140 153 0 0 0 0 0\n"
"MouseMoveEvent 136 152 0 0 0 0 0\n"
"RenderEvent 136 152 0 0 0 0 0\n"
"MouseMoveEvent 130 150 0 0 0 0 0\n"
"RenderEvent 130 150 0 0 0 0 0\n"
"MouseMoveEvent 120 147 0 0 0 0 0\n"
"RenderEvent 120 147 0 0 0 0 0\n"
"MouseMoveEvent 105 143 0 0 0 0 0\n"
"RenderEvent 105 143 0 0 0 0 0\n"
"MouseMoveEvent 98 143 0 0 0 0 0\n"
"RenderEvent 98 143 0 0 0 0 0\n"
"MouseMoveEvent 93 143 0 0 0 0 0\n"
"RenderEvent 93 143 0 0 0 0 0\n"
"MouseMoveEvent 91 141 0 0 0 0 0\n"
"RenderEvent 91 141 0 0 0 0 0\n"
"MouseMoveEvent 89 140 0 0 0 0 0\n"
"RenderEvent 89 140 0 0 0 0 0\n"
"MouseMoveEvent 86 138 0 0 0 0 0\n"
"RenderEvent 86 138 0 0 0 0 0\n"
"MouseMoveEvent 85 138 0 0 0 0 0\n"
"RenderEvent 85 138 0 0 0 0 0\n"
"MouseMoveEvent 84 137 0 0 0 0 0\n"
"RenderEvent 84 137 0 0 0 0 0\n"
"MouseMoveEvent 82 136 0 0 0 0 0\n"
"RenderEvent 82 136 0 0 0 0 0\n"
"MouseMoveEvent 80 136 0 0 0 0 0\n"
"RenderEvent 80 136 0 0 0 0 0\n"
"MouseMoveEvent 78 136 0 0 0 0 0\n"
"RenderEvent 78 136 0 0 0 0 0\n"
"MouseMoveEvent 76 136 0 0 0 0 0\n"
"RenderEvent 76 136 0 0 0 0 0\n"
"MouseMoveEvent 73 136 0 0 0 0 0\n"
"RenderEvent 73 136 0 0 0 0 0\n"
"MouseMoveEvent 71 136 0 0 0 0 0\n"
"RenderEvent 71 136 0 0 0 0 0\n"
"MouseMoveEvent 69 135 0 0 0 0 0\n"
"RenderEvent 69 135 0 0 0 0 0\n"
"MouseMoveEvent 67 133 0 0 0 0 0\n"
"RenderEvent 67 133 0 0 0 0 0\n"
"MouseMoveEvent 63 132 0 0 0 0 0\n"
"RenderEvent 63 132 0 0 0 0 0\n"
"MouseMoveEvent 59 130 0 0 0 0 0\n"
"RenderEvent 59 130 0 0 0 0 0\n"
"MouseMoveEvent 51 127 0 0 0 0 0\n"
"RenderEvent 51 127 0 0 0 0 0\n"
"MouseMoveEvent 51 126 0 0 0 0 0\n"
"RenderEvent 51 126 0 0 0 0 0\n"
"MouseMoveEvent 50 125 0 0 0 0 0\n"
"RenderEvent 50 125 0 0 0 0 0\n"
"MouseMoveEvent 51 125 0 0 0 0 0\n"
"RenderEvent 51 125 0 0 0 0 0\n"
"MouseMoveEvent 52 125 0 0 0 0 0\n"
"RenderEvent 52 125 0 0 0 0 0\n"
"MouseMoveEvent 53 125 0 0 0 0 0\n"
"RenderEvent 53 125 0 0 0 0 0\n"
"MouseMoveEvent 54 125 0 0 0 0 0\n"
"RenderEvent 54 125 0 0 0 0 0\n"
"MouseMoveEvent 55 125 0 0 0 0 0\n"
"RenderEvent 55 125 0 0 0 0 0\n"
"MouseMoveEvent 57 124 0 0 0 0 0\n"
"RenderEvent 57 124 0 0 0 0 0\n"
"MouseMoveEvent 58 124 0 0 0 0 0\n"
"RenderEvent 58 124 0 0 0 0 0\n"
"MouseMoveEvent 60 123 0 0 0 0 0\n"
"RenderEvent 60 123 0 0 0 0 0\n"
"MouseMoveEvent 61 122 0 0 0 0 0\n"
"RenderEvent 61 122 0 0 0 0 0\n"
"MouseMoveEvent 62 122 0 0 0 0 0\n"
"RenderEvent 62 122 0 0 0 0 0\n"
  ;

// This does the actual work: updates the probe.
// Callback for the interaction
class vtkBiDimensionalCallback : public vtkCommand
{
public:
  static vtkBiDimensionalCallback *New()
  { return new vtkBiDimensionalCallback; }
  virtual void Execute(vtkObject *, unsigned long, void*)
  {
    std::cout << "End interaction event\n" << std::flush;
  }
  vtkBiDimensionalCallback() {}
};

int TestBiDimensionalWidget( int argc, char *argv[] )
{
  // Create the pipeline
  char* fname = vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/headsq/quarter");

  vtkSmartPointer<vtkVolume16Reader> v16 =
    vtkSmartPointer<vtkVolume16Reader>::New();
  v16->SetDataDimensions(64, 64);
  v16->SetDataByteOrderToLittleEndian();
  v16->SetImageRange(1, 93);
  v16->SetDataSpacing(3.2, 3.2, 1.5);
  v16->SetFilePrefix(fname);
  v16->ReleaseDataFlagOn();
  v16->SetDataMask(0x7fff);
  v16->Update();
  delete[] fname;

  double range[2];
  v16->GetOutput()->GetScalarRange(range);

  vtkSmartPointer<vtkImageShiftScale> shifter =
    vtkSmartPointer<vtkImageShiftScale>::New();
  shifter->SetShift(-1.0*range[0]);
  shifter->SetScale(255.0/(range[1]-range[0]));
  shifter->SetOutputScalarTypeToUnsignedChar();
  shifter->SetInputConnection(v16->GetOutputPort());
  shifter->ReleaseDataFlagOff();
  shifter->Update();

  vtkSmartPointer<vtkImageActor> imageActor =
    vtkSmartPointer<vtkImageActor>::New();
  imageActor->GetMapper()->SetInputConnection(shifter->GetOutputPort());
  imageActor->VisibilityOn();
  imageActor->SetDisplayExtent(0, 63, 0, 63, 46, 46);
  imageActor->InterpolateOn();

  double bounds[6];
  imageActor->GetBounds(bounds);

  // Create the RenderWindow, Renderer and both Actors
  //
  vtkSmartPointer<vtkRenderer> ren1 =
    vtkSmartPointer<vtkRenderer>::New();
  vtkSmartPointer<vtkRenderWindow> renWin =
    vtkSmartPointer<vtkRenderWindow>::New();
  renWin->AddRenderer(ren1);

  vtkSmartPointer<vtkRenderWindowInteractor> iren =
    vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);

  vtkSmartPointer<vtkInteractorStyleImage> style =
    vtkSmartPointer<vtkInteractorStyleImage>::New();
  iren->SetInteractorStyle(style);

  // VTK widgets consist of two parts: the widget part that handles event processing;
  // and the widget representation that defines how the widget appears in the scene
  // (i.e., matters pertaining to geometry).
  vtkSmartPointer<vtkBiDimensionalRepresentation2D> rep =
    vtkSmartPointer<vtkBiDimensionalRepresentation2D>::New();

  vtkSmartPointer<vtkBiDimensionalWidget> widget =
    vtkSmartPointer<vtkBiDimensionalWidget>::New();
  widget->SetInteractor(iren);
  widget->SetRepresentation(rep);

  vtkSmartPointer<vtkBiDimensionalCallback> callback = vtkSmartPointer<vtkBiDimensionalCallback>::New();
  widget->AddObserver(vtkCommand::EndInteractionEvent,callback);

  // Add the actors to the renderer, set the background and size
  ren1->AddActor(imageActor);
  ren1->SetBackground(0.1, 0.2, 0.4);
  renWin->SetSize(300, 300);

  // record events
  vtkSmartPointer<vtkInteractorEventRecorder> recorder = vtkSmartPointer<vtkInteractorEventRecorder>::New();
  recorder->SetInteractor(iren);

#ifdef RECORD
  recorder->SetFileName("record.log");
  recorder->On();
  recorder->Record();
#else
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(BiDimensionalWidgetEventLog);
#endif

  // render the image
  //
  iren->Initialize();
  renWin->Render();
  widget->On();

#ifndef RECORD
  recorder->Play();
  recorder->Off();
#endif

  iren->Start();

  return EXIT_SUCCESS;

}
