/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.loading;

import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.xj3d.core.loading.ContentLoadQueue;
import org.xj3d.core.loading.LoadRequest;

class ContentLoader
implements Runnable {
    private static final String UNKNOWN_ERROR_MSG = "Unknown error in content loading process";
    private static final String CONTENT_ERROR_MSG = "Error setting external content:";
    private static final String INVALID_FIELD_MSG = "Internal error caused by attempting to send content to an invalid field index: ";
    private static final String NO_URLS_MSG = "Cannot resolve any URLS for URL: ";
    private Thread th;
    private ContentLoadQueue pendingList;
    private Map inProgress;
    private boolean terminateCurrent;
    private boolean processNext;
    private ErrorReporter errorReporter;
    private LoadRequest currentRequest;

    ContentLoader(ThreadGroup threadGroup, ContentLoadQueue contentLoadQueue, Map map) {
        this.pendingList = contentLoadQueue;
        this.inProgress = map;
        this.terminateCurrent = false;
        this.processNext = true;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.th = new Thread(threadGroup, this, "Xj3D Content Loader");
        this.th.start();
    }

    public void run() {
        while (this.processNext) {
            try {
                this.currentRequest = this.pendingList.getNext();
                if (this.currentRequest == null || this.currentRequest.loadList.size() == 0) {
                    if (!this.processNext) break;
                    continue;
                }
                this.terminateCurrent = false;
                this.inProgress.put(this.currentRequest.url, this.currentRequest);
                this.currentRequest.handler.processLoadRequest(this.errorReporter, this.currentRequest.url, this.currentRequest.loadList);
                this.inProgress.remove(this.currentRequest.url);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
                continue;
            }
            this.currentRequest = null;
            Thread.yield();
        }
        this.th = null;
    }

    boolean isAlive() {
        if (this.th == null) {
            return false;
        }
        return this.th.isAlive();
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null && !this.terminateCurrent && this.processNext) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    void abortCurrentFile() {
        this.terminateCurrent = true;
        if (this.currentRequest != null) {
            this.currentRequest.handler.abortCurrentFile();
        }
    }

    void shutdown() {
        this.terminateCurrent = true;
        this.processNext = false;
        if (this.currentRequest != null) {
            this.currentRequest.handler.shutdown();
        }
    }
}

