/**
	@license GNU GPLv2
	PROJECT "trovacap"
	Copyright  2006 Danilo Cicerone

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software Foundation,
	Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

/**
	@file dlg_info.cxx
	@author Danilo Cicerone info@digitazero.org
	@date 2006-12-05
	@version 0.2.2
*/

#include "dlg_info.h"

/*----------------------------------------------------------------------------*/

WinInfo::WinInfo()
{
	dlg_info = new Fl_Window((Fl::w() - winW)/2, (Fl::h() - winH)/2, winW, winH,
		"trovacap: Info");
	dlg_info->user_data((void*)(this));
	dlg_info->color(FL_BACKGROUND2_COLOR);
	dlg_info->begin();
	{
		string lbl;
		lbl = "trovacap 0.2.2\n";
		lbl += "Copyright  2006 Danilo Cicerone\n";
		lbl += "This is free software; see the source for copying conditions. ";
		lbl += "There is NO warranty; not even for MERCHANTABILITY or ";
		lbl += "FITNESS FOR A PARTICULAR PURPOSE.\n\n";
		lbl += "Credits:\n";
		lbl += "- Giuseppe Borz (Ubuntu packages);\n";
		lbl += "- Stefano Maffulli && FSFE (for ALL);\n";
		lbl += "- Cristiano Boncompagni;\n";
		lbl += "- Ivan Sergio Borgonovo, Roberto Vichi;\n";
		lbl += "\nProject Page: http://www.digitazero.org/?p=41\n";
		lbl += "Report bugs to: info@@digitazero.org\n";

		lbl_info = new Fl_Box(0, 0, winW, winH - 35);
		lbl_info->align(165|FL_ALIGN_INSIDE);
		lbl_info->color(FL_BACKGROUND2_COLOR);
		lbl_info->labelfont(1);
		lbl_info->labelsize(14);
		lbl_info->copy_label(lbl.c_str());

		btn_annulla = new Fl_Button((winW - 100)/2, winH -30, 100, 25, "&Chiudi");
		btn_annulla->callback((Fl_Callback*)cb_btn_annulla, (void*)(this));
		btn_annulla->color((Fl_Color)94);
	}
	dlg_info->end();
	dlg_info->set_modal();
}

/*----------------------------------------------------------------------------*/

WinInfo::~WinInfo()
{
	delete dlg_info;
}

/*----------------------------------------------------------------------------*/

void
WinInfo::show()
{
	dlg_info->show();
}

/*----------------------------------------------------------------------------*/

void
WinInfo::hide()
{
	dlg_info->hide();
}

/*----------------------------------------------------------------------------*/

int
WinInfo::visible()
{
	return dlg_info->visible();
}

/*----------------------------------------------------------------------------*/

int
WinInfo::standby()
{
	show();
	while (visible()) Fl::wait();

	return 0;
}

/*----------------------------------------------------------------------------*/

void
WinInfo::cb_btn_annulla(Fl_Button*, void* obj)
{
	static_cast<WinInfo *>(obj)->ex_annulla();
}

/*----------------------------------------------------------------------------*/

inline void
WinInfo::ex_annulla()
{
	hide();
}
