// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// More than one process tried to modify a resource at the same time.
type ConcurrentModificationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	return "ConcurrentModificationException"
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Some part of the dashboard data is invalid.
type DashboardInvalidInputError struct {
	Message *string

	DashboardValidationMessages []DashboardValidationMessage

	noSmithyDocumentSerde
}

func (e *DashboardInvalidInputError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DashboardInvalidInputError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DashboardInvalidInputError) ErrorCode() string             { return "InvalidParameterInput" }
func (e *DashboardInvalidInputError) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified dashboard does not exist.
type DashboardNotFoundError struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *DashboardNotFoundError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DashboardNotFoundError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DashboardNotFoundError) ErrorCode() string             { return "ResourceNotFound" }
func (e *DashboardNotFoundError) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Request processing has failed due to some unknown error, exception, or failure.
type InternalServiceFault struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InternalServiceFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServiceFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServiceFault) ErrorCode() string             { return "InternalServiceError" }
func (e *InternalServiceFault) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Data was not syntactically valid JSON.
type InvalidFormatFault struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidFormatFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidFormatFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidFormatFault) ErrorCode() string             { return "InvalidFormat" }
func (e *InvalidFormatFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The next token specified is invalid.
type InvalidNextToken struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidNextToken) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextToken) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextToken) ErrorCode() string             { return "InvalidNextToken" }
func (e *InvalidNextToken) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Parameters were used together that cannot be used together.
type InvalidParameterCombinationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterCombinationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterCombinationException) ErrorCode() string {
	return "InvalidParameterCombination"
}
func (e *InvalidParameterCombinationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The value of an input parameter is bad or out-of-range.
type InvalidParameterValueException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterValueException) ErrorCode() string             { return "InvalidParameterValue" }
func (e *InvalidParameterValueException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation exceeded one or more limits.
type LimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string             { return "LimitExceededException" }
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota for alarms for this customer has already been reached.
type LimitExceededFault struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *LimitExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededFault) ErrorCode() string             { return "LimitExceeded" }
func (e *LimitExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An input parameter that is required is missing.
type MissingRequiredParameterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingRequiredParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingRequiredParameterException) ErrorCode() string             { return "MissingParameter" }
func (e *MissingRequiredParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The named resource does not exist.
type ResourceNotFound struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFound) ErrorCode() string             { return "ResourceNotFound" }
func (e *ResourceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The named resource does not exist.
type ResourceNotFoundException struct {
	Message *string

	ResourceType *string
	ResourceId   *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
