#! /bin/bash
#     The Shoreline Firewall (Shorewall) Packet Filtering Firewall - V5.0
#
#     This program is under GPL [http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt]
#
#     (c) 2010,2012 - Tom Eastep (teastep@shorewall.net)
#
#       On most distributions, this file should be called /etc/init.d/shorewall.
#
#       Complete documentation is available at http://shorewall.net
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of Version 2 of the GNU General Public License
#       as published by the Free Software Foundation.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
### BEGIN INIT INFO
# Provides: shorewall-init
# Required-Start: $local_fs
# Required-Stop:  $local_fs
# Default-Start:  2 3 5
# Default-Stop:   0 1 6
# Short-Description: Initialize the firewall at boot time
# Description:       Place the firewall in a safe state at boot time
#                    prior to bringing up the network.  
### END INIT INFO

#Return values acc. to LSB for all commands but status:
# 0 - success
# 1 - generic or unspecified error
# 2 - invalid or excess argument(s)
# 3 - unimplemented feature
# 4 - insufficient privilege
# 5 - program is not installed
# 6 - program is not configured
# 7 - program is not running

if [ "$(id -u)" != "0" ]
then
  echo "You must be root to start, stop or restart \"Shorewall \"."
  exit 4
fi

# check if shorewall-init is configured or not
if [ -f "/etc/sysconfig/shorewall-init" ]
then
    . /etc/sysconfig/shorewall-init

    if [ -z "$PRODUCTS" ]
    then
	echo "No PRODUCTS configured"
	exit 6
    fi
else
    echo "/etc/sysconfig/shorewall-init not found"
    exit 6
fi

#
# The installer may alter this
#
. /usr/share/shorewall/shorewallrc

# set the STATEDIR variable
setstatedir() {
    local statedir
    if [ -f ${CONFDIR}/${PRODUCT}/vardir ]; then
	statedir=$( . /${CONFDIR}/${PRODUCT}/vardir && echo $VARDIR )
    fi

    [ -n "$statedir" ] && STATEDIR=${statedir} || STATEDIR=${VARLIB}/${PRODUCT}

    if [ -x ${STATEDIR}/firewall ]; then
	return 0
    elif [ $PRODUCT = shorewall ]; then
	${SBINDIR}/shorewall compile
    elif [ $PRODUCT = shorewall6 ]; then
	${SBINDIR}/shorewall -6 compile
    else
	return 6
    fi
}

# Initialize the firewall
shorewall_start () {
  local PRODUCT
  local STATEDIR

  printf "Initializing \"Shorewall-based firewalls\": "
  for PRODUCT in $PRODUCTS; do
      if setstatedir; then
	  if ! ${SBIN}/$PRODUCT status > /dev/null 2>&1; then
	      $STATEDIR/$PRODUCT/firewall ${OPTIONS} stop
	  fi
      fi
  done

  if [ -n "$SAVE_IPSETS" -a -f "$SAVE_IPSETS" ]; then
      ipset -R < "$SAVE_IPSETS"
  fi
}

# Clear the firewall
shorewall_stop () {
  local PRODUCT
  local STATEDIR

  printf "Clearing \"Shorewall-based firewalls\": "
  for PRODUCT in $PRODUCTS; do
      if setstatedir; then
	  ${STATEDIR}/firewall ${OPTIONS} clear
      fi
  done

  if [ -n "$SAVE_IPSETS" ]; then
      mkdir -p $(dirname "$SAVE_IPSETS")
      if ipset -S > "${SAVE_IPSETS}.tmp"; then
	  grep -qE -- '^(-N|create )' "${SAVE_IPSETS}.tmp" && mv -f "${SAVE_IPSETS}.tmp" "$SAVE_IPSETS" || rm -f "${SAVE_IPSETS}.tmp"
      else
	  rm -f "${SAVE_IPSETS}.tmp"
      fi
  fi
}

case "$1" in
    start)
	shorewall_start
	;;
    stop)
	shorewall_stop
	;;
    reload|forced-reload)
	;;
    *)
	echo "Usage: /etc/init.d/shorewall-init {start|stop}"
	exit 1
	;;
esac

exit 0
