// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "tcl.h"

#include "colorbarrgbtruecolor.h"
#include "util.h"

ColorbarRGBTrueColor::ColorbarRGBTrueColor(Tcl_Interp* i, Tk_Canvas c,
					   Tk_Item* item) 
  : ColorbarBase(i,c,item), ColorbarRGB(i,c,item), ColorbarTrue(i,c,item)
{
  colorCount = 0;
}

int ColorbarRGBTrueColor::initColormap()
{
  colorCount = (((ColorbarBaseOptions*)options)->colors);
  colorCells = new unsigned char[colorCount*3];

 // needed to initialize colorCells
  reset();

  return TCL_OK;
}

void ColorbarRGBTrueColor::updateColorCells()
{
  // fill rgb table
  // note: its filled bgr to match XImage
  //  for(int i=0; i<colorCount; i++) {
  for(int i=0, j=colorCount-1; i<colorCount; i++, j--) {
    int idr = invert ? calcContrastBias(j,bias[0],contrast[0]) : 
      calcContrastBias(i,bias[0],contrast[0]);
    int idg = invert ? calcContrastBias(j,bias[1],contrast[1]) : 
      calcContrastBias(i,bias[1],contrast[1]);
    int idb = invert ? calcContrastBias(j,bias[2],contrast[2]) : 
      calcContrastBias(i,bias[2],contrast[2]);

    colorCells[i*3]   = (int)(256.*idr/colorCount);
    colorCells[i*3+1] = (int)(256.*idg/colorCount);
    colorCells[i*3+2] = (int)(256.*idb/colorCount);
  }
}

