#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:34:37 
# _list-groups.sh

### P A R A M S

MYVERBOSE=
if [ "$1" == "-v" ];then
	export MYVERBOSE="True"
	shift
fi
MYFILTER="$1"
MYNOTFILTER="$2"

### S T A R T

do_it(){
	echo "$1 ($2) $3"
}

echo "--------------------------------------------------------------------------------"
echo "LIST OF GROUPS"
echo "condition : ${MYFILTER}"
echo "not condition : ${MYNOTFILTER}"
echo "id (gid) members"
echo "--------------------------------------------------------------------------------"

if [ "${MYFILTER}" = "" ];then
	MYFILTER="1"
fi
if [ "${MYNOTFILTER}" = "" ];then
	MYNOTFILTER="0"
fi

ids=`getent group | sort | awk 'BEGIN{FS=":"}{if('"${MYFILTER}"' && !'"${MYNOTFILTER}"') printf "%s:%s:%s#",$1,$3,$4}'`
IFS="#"
for i in ${ids}; do
	id=`echo ${i} | sed 's/\([^:]*\):.*$/\1/'`
	gid=`echo ${i} | sed 's/[^:]*:\([^:]*\):.*$/\1/'`
        members=`echo ${i} | sed 's/[^:]*:[^:]*:\([^:]*\)$/\1/'`

	#echo "entry=${i}"
	#echo "id=${id}"
	#echo "gid=${gid}"
	#echo "members=${members}"

	if [ "${gid}" -lt 500 ]; then
		continue
	fi
	if [ "${gid}" -eq 65534 ]; then
		continue
	fi
	
	do_it ${id} ${gid} ${members}
done

if [ ! -z "${MYVERBOSE}" ]; then

echo "--------------------------------------------------------------------------------"
ids=`getent group | sort | awk 'BEGIN{FS=":"}{if('"${MYFILTER}"' && !'"${MYNOTFILTER}"') printf "%s#",$1}'`
IFS="#"
for g in ${ids}; do
	python -c "import grp; print grp.getgrnam(\"${g}\");" #2> /dev/null;
done

echo "--------------------------------------------------------------------------------"
users=`getent passwd | sort | awk 'BEGIN{FS=":"}{printf "%s#",$1}'`
IFS="#"
for u in ${users}; do
	echo -n "${u} is in "; 
	if ! id -Gn ${u} 2> /dev/null; then
		echo "<error>"
	fi
done

fi

IFS="\t\n "
