% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{zelig_setx_to_df}
\alias{zelig_setx_to_df}
\title{Extracted fitted values from a Zelig object with \code{setx} values}
\usage{
zelig_setx_to_df(obj)
}
\arguments{
\item{obj}{a zelig object with simulated quantities of interest}
}
\description{
Extracted fitted values from a Zelig object with \code{setx} values
}
\details{
Fitted (\code{setx}) values in a tidy data formatted
\code{data.frame}. This was designed to enable the WhatIf package's
\code{whatif} function to extract "counterfactuals".
}
\examples{
#### QIs without first difference or range, from covariates fitted at
## central tendencies
z.1 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.1 <- setx(z.1)
zelig_setx_to_df(z.1)

#### QIs for first differences
z.2 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.2 <- setx(z.2, Petal.Length = 2)
z.2 <- setx1(z.2, Petal.Length = 4.4)
zelig_setx_to_df(z.2)

#### QIs for first differences, estimated by Species
z.3 <- zelig(Petal.Width ~ Petal.Length, by = "Species", data = iris,
             model = "ls")
z.3 <- setx(z.3, Petal.Length = 2)
z.3 <- setx1(z.3, Petal.Length = 4.4)
zelig_setx_to_df(z.3)

#### QIs for a range of fitted values
z.4 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.4 <- setx(z.4, Petal.Length = 2:4)
zelig_setx_to_df(z.4)

#### QIs for a range of fitted values, estimated by Species
z.5 <- zelig(Petal.Width ~ Petal.Length, by = "Species", data = iris,
             model = "ls")
z.5 <- setx(z.5, Petal.Length = 2:4)
zelig_setx_to_df(z.5)

#### QIs for two ranges of fitted values
z.6 <- zelig(Petal.Width ~ Petal.Length + Species, data = iris,
             model = "ls")
z.6 <- setx(z.6, Petal.Length = 2:4, Species = "setosa")
z.6 <- setx1(z.6, Petal.Length = 2:4, Species = "virginica")
zelig_setx_to_df(z.6)

}
\author{
Christopher Gandrud
}
